#  Display.tcl    
#  Copyright (c) 1997 Mark Black
#  Version 0.1
#
#  This library of functions is required for displaying data.
#  It contains the code for filling the list boxes.
#
# Contents:
#   repack       - Redraw the output window
#   filltext     - Fill the output window

#
# ------  Procedure to Customize the window to suit the variable to edit ---
#
# Negitive values are used to call fillCan with -ve type
proc repack { type } {
    global currenthost
    global level
    if { $type < 0 } {
	set level [ expr $type * -1 ]
	fillCan $level
    } elseif { $type == 0 } {
	.general.label configure -text "Tasks:  $currenthost"
	
    } elseif { $type == 1 } {
	.general.label configure -text "Hosts:  $currenthost"
	set returndata [queryHost $currenthost "get hosts" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 2 } {
	.general.label configure -text "User Groups:  $currenthost"
	set returndata [queryHost $currenthost "get group" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 3 } {
	.general.label configure -text "Mounting Filesystems:  $currenthost"
	set returndata [queryHost $currenthost "get fstab" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 4 } {
	.general.label configure -text "Inittab  (Delete Only):  $currenthost"
	set returndata [queryHost $currenthost "get inittab" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 5 } {
	.general.label configure -text "Users:  $currenthost"
	set returndata [queryHost $currenthost "get users" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 6 } {
	.general.label configure -text "DNS Client Configuration:  $currenthost"
	set returndata [queryHost $currenthost "get dnsc" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 7 } {
	.general.label configure -text "Login Message:  $currenthost"
	set returndata [queryHost $currenthost "get motd" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 8 } {
	.general.label configure -text "Mailing Lists & Mail Redirection:  $currenthost"
	set returndata [queryHost $currenthost "get alias" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 9 } {
	.general.label configure -text "Samba Shares on $currenthost"
	set returndata [queryHost $currenthost "get samba" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 10 } {
	.general.label configure -text "Exported Filesystems from $currenthost"
	set returndata [queryHost $currenthost "get exports" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 11 } {
	.general.label configure -text "Sudo Users on $currenthost"
	set returndata [queryHost $currenthost "get sudo" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 12 } {
	.general.label configure -text "Crontab on $currenthost"
	set returndata [queryHost $currenthost "get crontab" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 41 } {
	# DNS Master record config
	global currentdomain
	.general.label configure -text "DNS records for $currentdomain, on $currenthost"
	set returndata [queryHost $currenthost "DNS get host $currentdomain" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 42 } {
	# DNS Secondary Config
	global currentdomain
	.general.label configure -text "DNS Secondary Servers for $currentdomain"
	set returnval [queryHost $currenthost "DNS get soa $currentdomain" 0 ]
	set data [ split $returnval ":" ]
	set returndata {}
	foreach secserv [ split [ lindex $data 8 ] "," ] {
	    lappend returndata $secserv
	}
	filltext $returndata .general.text $type
    } elseif { $type == 70 } {
	.general.label configure -text "NIS password entries on $currenthost"
	set returndata [queryHost $currenthost "NIS get pass" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 71 } {
	.general.label configure -text "NIS group entries on $currenthost"
	set returndata [queryHost $currenthost "NIS get group" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 72 } {
	.general.label configure -text "NIS hosts entries on $currenthost"
	set returndata [queryHost $currenthost "NIS get hosts" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 81 } {
	.general.label configure -text "Backup files on $currenthost"
	set returndata [queryHost $currenthost "get tapes" 0 ]
    } elseif { $type == 82 } {
	.general.label configure -text "Restore files on $currenthost"
	set returndata [queryHost $currenthost "get tapes" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 83 } {
	.general.label configure -text "Schedule backups for $currenthost"
	set returndata [queryHost $currenthost "get tapes" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 90 } {
	.general.label configure -text "MAT Hosts managed by this Management Console"
	set returndata {}
	set fid [ open "../hosts" r ]
	while { [ gets $fid fout ] > 0 } {
	    lappend returndata $fout
	}
	close $fid
	filltext $returndata .general.text $type
    } elseif { $type == 91 } {
	.general.label configure -text "MAT users on $currenthost"
	set returndata [queryHost $currenthost "get matpass" 0 ]
	filltext $returndata .general.text $type
    } elseif { $type == 92 } {
	.general.label configure -text "MAT Logs for:  $currenthost"
	set returndata [queryHost $currenthost "get matlog" 0 ]
	filltext $returndata .general.text $type
    }
}


#
# -- Procedure to read data from raw data and fill list window --
#
proc filltext { data window type } {
    global currenthost
    global master
    . config -cursor watch
    $window config -cursor watch
    $window configure -state normal
    $window delete 0.0 end
    set master ""
    # Tasks
    set tabbing(0) {12 22 11 }
    set toplabel(0) "Task        Interval/Time         Retention  Output"
    # Hosts
    set tabbing(1) {16 24 }
    set toplabel(1) "IP Address      Host Name               Alias(s)"
    # Groups
    set tabbing(2) {12 6 }
    set toplabel(2) "Group name  GID#  Members"
    # Mounts
    set tabbing(3) {20 20 10 18 3 }
    set toplabel(3) "What to mount       Where to mount      Type      Options         Order"
    # Inittab
    set tabbing(4) {3 10 10 }
    set toplabel(4) "ID :  Type     :  Process"
    # Users
    set tabbing(5) {10 6 6 20 24 }
    set toplabel(5) "Login     UID#  GID#  Users Fullname      Home Directory          Shell"
    # DNS Clients
    set tabbing(6) {14 }
    set toplabel(6) "Keyword       Value"
    # Motd
    set toplabel(7) "Edit the text, Then press NEW to update"
    # Mail Aliases
    set tabbing(8) {17 10 }
    set toplabel(8) "Email Name       : Destination "
    # Samba
    set tabbing(9) {11 10 }
    set toplabel(9) "Share Name : Options "
    # Exports
    set tabbing(10) {11 10 }
    set toplabel(10) "Filesystem  Access "
    # Sudo
    set tabbing(11) {11 10 }
    set toplabel(11) "Login/Cmd  Permissions/Programs/Hosts "
    # Crontab
    set tabbing(12) {9 9 11 9 10}
    set toplabel(12) "Minutes  Hours    Month Day  Month    Week Day  Command "
    # DNS Master
    set tabbing(41) {12 16 21 }
    set toplabel(41) "Host Name   IP Address      Alias(es)            Comment"
    # DNS Secondaries
    set tabbing(42) 32
    set toplabel(42) "Secondary DNS Servers"
    # NIS Entries
    # NIS Password
    set tabbing(70) {10 6 6 20 24 }
    set toplabel(70) "Login     UID#  GID#  Users Fullname      Home Directory          Shell"
    # NIS Groups
    set tabbing(71) {12 6 }
    set toplabel(71) "Group name  GID#  Members"    
    # NIS Hosts
    set tabbing(72) {16 24 }
    set toplabel(72) "IP Address      Host Name               Alias(s)"
    # NIS Mail Aliases
    set tabbing(73) {17 10 }
    set toplabel(73) "Email Name       : Destination "
    # BACKUP/RESTORE tools
    set toplabel(81) "Select a tape device to backup to"
    set toplabel(82) "Select a tape device to restore from"
    set toplabel(83) "Select a tape device to schedule backups on"
    # MAT Hosts
    set tabbing(90) {13 20 }
    set toplabel(90) "Hostname     Services"
    # MAT Passwords
    set tabbing(91) {13 20 }
    set toplabel(91) "Login        Access"
    # MAT Logs
    set tabbing(92) {0 0 }
    set toplabel(92) "Read Only log files"

    set bold "-background #c0c000 -relief raised -borderwidth 1"
    set normal "-background {} -relief flat"
    set select "-underline 1"
    set tplabel $window
    append tplabel "label"
    $tplabel configure -state normal
    $tplabel delete 0.0 end
    $tplabel insert end $toplabel($type)
    $tplabel configure -state disabled
  
    if { $type == 0 } {
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    lappend master $tmp
	    set tmp2 [string trim [lindex $tmp 1 ]]
	    set outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 2 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 3 ]]
	    append outline $tmp2
	    $window insert end "$outline\n" l$position
	    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
	    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
	    $window tag bind l$position <Button-1> "Selecter $window l$position"
	    $window tag bind l$position <Double-1>  "Tasks $currenthost $position [lindex $data $position ]" 
	    if { [lindex $tmp 1 ] == "cleanup" } {
		$window tag configure l$position -foreground #00a000
	    } elseif { [string range [lindex $tmp 0 ] 0 0 ] == "T" } {
		$window tag configure l$position -foreground #a00000
	    } else {
		$window tag configure l$position -foreground #000000
	    }
	}
	$window configure -state disabled
    } elseif { $type == 1 } {
	# ------------------------------  HOSTS  --------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    lappend master $tmp
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 1 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
#		set tmp2 [string trim [lindex $tmp 2 ]]
		set tmp2 [string trim [lrange $tmp 2 end ]]
		append outline $tmp2
		$window insert end "$outline\n" l$position
		$window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		$window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		$window tag bind l$position <Button-1> "Selecter $window l$position"
		$window tag bind l$position <Double-1>  "Hosts $currenthost $position [lindex $data $position ]" 
		if { [lindex $tmp 1 ] == "localhost" } {
		    $window tag configure l$position -foreground #0000a0
		} else {
		    $window tag configure l$position -foreground #000000
		}
	    }
	}
	$window configure -state disabled
    } elseif {$type == 2 } {
	# -----------------  Groups  -------------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [split [lindex $data $position ] ":" ]
	    lappend master [lindex $data $position ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 3 ]
	    $window insert end "$outline\n" l$position
	    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
	    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
	    $window tag bind l$position <Button-1> "Selecter $window l$position"
	    $window tag bind l$position <Double-1>  "Groups $currenthost $position [lindex $data $position ]" 
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif { $type == 3 } {
	# --------------------------------  Fstab  --------------------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    lappend master $tmp
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    set outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 1 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 2 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 3 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 5 ]]
	    append outline $tmp2
	    $window insert end "$outline\n" l$position
	    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
	    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
	    $window tag bind l$position <Button-1> "Selecter $window l$position"
	    $window tag bind l$position <Double-1>  "Fstab $currenthost $position [lindex $data $position ]" 
	    if { [lindex $tmp 2 ]  == "nfs" } {
		$window tag configure l$position -foreground #00a000
	    } elseif { [lindex $tmp 2 ] == "ext2" } {
		$window tag configure l$position -foreground #a00000
	    } elseif { [lindex $tmp 2 ] == "msdos" } {
		$window tag configure l$position -foreground #0000a0
	    } else {
		$window tag configure l$position -foreground #000000
	    }
	}
	$window configure -state disabled
    } elseif {$type == 4 } {
	# --------------------------------------  Groups  ---------------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp2 [lindex $data $position ]
	    lappend master $tmp2
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set tmp [split $tmp2 ":" ]
		set outline [lindex $tmp 0 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline ": "
		append outline [lindex $tmp 2 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline ": " 
		append outline [lindex $tmp 3 ]
		$window insert end "$outline\n" l$position
		$window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		$window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		$window tag bind l$position <Button-1> "Selecter $window l$position"
		#	    $window tag bind l$position <Double-1>  "Groups $currenthost $position [lindex $data $position ]" 
	    } else {
		$window insert end "$tmp2\n"
	    }
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif { $type == 5 } {
	# ------------------  This is the Users Displayer  -------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [split [lindex $data $position ] ":" ]
	    lappend master [lindex $data $position ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 3 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length [lindex $tmp 3]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 4 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length [lindex $tmp 4]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 5 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 4] -[string length [lindex $tmp 5]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 6 ]
	    $window insert end "$outline\n" l$position
	    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
	    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
	    $window tag bind l$position <Button-1> "Selecter $window l$position"
	    $window tag bind l$position <Double-1>  "User $currenthost $position [lindex $data $position ]" 
	    if { [string index [lindex $tmp 1 ] 0 ] == "!" } {
		$window tag configure l$position -foreground #00a000
	    } elseif { [lindex $tmp 1 ] == "" } {
		$window tag configure l$position -foreground #a00000
	    } elseif { [lindex $tmp 1 ] == "*" } {
		$window tag configure l$position -foreground #0000a0
	    } else {
		$window tag configure l$position -foreground #000000
	    }
	}
	$window configure -state disabled
    }  elseif { $type == 6 } {
	# ---------------------------------  DNS Client  --------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    lappend master $tmp
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [string trimleft $tmp [lindex $tmp 0 ]]]
		append outline $tmp2
		$window insert end "$outline\n" l$position
		$window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		$window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		$window tag bind l$position <Button-1> "Selecter $window l$position"
		$window tag bind l$position <Double-1>  "DnsClient $currenthost 0 0" 
		if { [lindex $tmp 0 ] == "domain" } {
		    $window tag configure l$position -foreground #0000a0
		} elseif { [lindex $tmp 0 ] == "search" } {
		    $window tag configure l$position -foreground #606020
		} else {
		    $window tag configure l$position -foreground #000000
		}
	    }
	}
	$window configure -state disabled
    } elseif {$type == 8 } {
	# -------------------------------  Mail Lists  ---------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp2 [lindex $data $position ]
	    lappend master $tmp2
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set tmp [split $tmp2 ":" ]
		set outline [lindex $tmp 0 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline ": "

		set trimval [ expr [string length [lindex $tmp 0 ] ] + 1 ]
		set tmp3 [ string trim [ string range $tmp2 $trimval end ] ]

		append outline $tmp3
		$window insert end "$outline\n" l$position
		$window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		$window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		$window tag bind l$position <Button-1> "Selecter $window l$position"
		$window tag bind l$position <Double-1>  "Mail $currenthost $position [lindex $data $position ]"
		set schar [string range $tmp3 0 0 ]
		if { $schar == ":" | $schar == "\""  } {
		    $window tag configure l$position -foreground #0000d0
		} elseif { $schar == "/" } {
		    $window tag configure l$position -foreground #20a020
		} elseif { $schar == "|" } {
		    $window tag configure l$position -foreground #20a090
		} else {
		    $window tag configure l$position -foreground #803030
		}
	    } else {
		$window insert end "$tmp2\n" 
	    }
	}
	$window configure -state disabled
    } elseif {$type == 9 } {
	# ------------------------------- Samba Shares  ---------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp2 [lindex $data $position ]
	    lappend master $tmp2
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set tmp [split $tmp2 ":" ]
		set outline [lindex $tmp 0 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline ": "
		append outline [lindex $tmp 1 ]
		$window insert end "$outline\n" l$position
		$window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		$window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		$window tag bind l$position <Button-1> "Selecter $window l$position"
		$window tag bind l$position <Double-1>  "Sudo $currenthost $position [lindex $data $position ]" 
	    } else {
		$window insert end "$tmp2\n"
	    }
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif {$type == 10 } {
	# ------------------------------- Exported Filesystems  ---------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp2 [lindex $data $position ]
	    lappend master $tmp2
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set tmp [split $tmp2 ":" ]
		set outline [lindex $tmp 0 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline [lindex $tmp 1 ]
		$window insert end "$outline\n" l$position
		$window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		$window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		$window tag bind l$position <Button-1> "Selecter $window l$position"
		$window tag bind l$position <Double-1>  "Sudo $currenthost $position [lindex $data $position ]" 
	    } else {
		$window insert end "$tmp2\n"
	    }
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif {$type == 11 } {
	# ------------------------------- Sudo Users  ---------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    lappend master $tmp
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 1 ]]
		append outline $tmp2
		$window insert end "$outline\n" l$position
		$window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		$window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		$window tag bind l$position <Button-1> "Selecter $window l$position"
		$window tag bind l$position <Double-1>  "Sudo $currenthost $position [lindex $data $position ]" 
	    } else {
		$window insert end "$tmp2\n"
	    }
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif {$type == 12 } {
	# ------------------------------- Crontab File  ---------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    lappend master $tmp
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 1 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 2 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 3 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 4 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 4] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		for { set loc 5 } { $loc < [llength $tmp] } { incr loc 1 } {
		    set tmp2 [string trim [lindex $tmp $loc ]]
		    append outline "$tmp2 "
		}
		$window insert end "$outline\n" l$position
		$window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		$window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		$window tag bind l$position <Button-1> "Selecter $window l$position"
		$window tag bind l$position <Double-1>  "CronEdit $currenthost $position [lindex $data $position ]" 
	    } else {
		$window insert end "$tmp\n"
		$window tag bind l$position <Any-Enter> ""
		$window tag bind l$position <Any-Leave> ""
		$window tag bind l$position <Button-1> ""
		$window tag bind l$position <Double-1>  ""
	    }
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif { $type == 41 } {
	# ------------------------   This is the DNS Hosts Displayer  -----------------------------------
	global currentdomain
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp2 [lindex $data $position ]
	    set tmp [split $tmp2 ":" ]
	    puts $tmp2
	    lappend master $tmp2
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 1 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 1]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 4 ]
	    $window insert end "$outline\n" l$position
	    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
	    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
	    $window tag bind l$position <Button-1> "Selecter $window l$position"
	    $window tag bind l$position <Double-1>  "DnsEdit $currenthost $currentdomain [lindex [ split [lindex $data $position ] ":" ] 0 ]  [lindex $data $position ]" 
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif { $type == 42 } {
	# ------------------------   This is the DNS Secondary Displayer  -----------------------------------
	global currentdomain
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp2 [lindex $data $position ]
	    lappend master $tmp2
	    set outline $tmp2
	    $window insert end "$outline\n" l$position
	    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
	    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
	    $window tag bind l$position <Button-1> "Selecter $window l$position"
	    $window tag bind l$position <Double-1>  "DnsSecEdit $currentdomain [lindex $data $position ]" 
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif { $type == 70 } {
	# ----------------------------  NIS Password  -------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [split [lindex $data $position ] ":" ]
	    lappend master [lindex $data $position ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 3 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length [lindex $tmp 3]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 4 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length [lindex $tmp 4]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 5 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 4] -[string length [lindex $tmp 5]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 6 ]
	    $window insert end "$outline\n" l$position
	    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
	    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
	    $window tag bind l$position <Button-1> "Selecter $window l$position"
	    $window tag bind l$position <Double-1>  "NISUser $currenthost [lindex [split [lindex $data $position] ":"] 0] [lindex $data $position ]" 
	    if { [string index [lindex $tmp 1 ] 0 ] == "!" } {
		$window tag configure l$position -foreground #00a000
	    } elseif { [lindex $tmp 1 ] == "" } {
		$window tag configure l$position -foreground #a00000
	    } elseif { [lindex $tmp 1 ] == "*" } {
		$window tag configure l$position -foreground #0000a0
	    } else {
		$window tag configure l$position -foreground #000000
	    }
	}
	$window configure -state disabled
    } elseif {$type == 71 } {
	# -----------------  NIS Groups  -------------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [split [lindex $data $position ] ":" ]
	    lappend master [lindex $data $position ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 3 ]
	    $window insert end "$outline\n" l$position
	    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
	    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
	    $window tag bind l$position <Button-1> "Selecter $window l$position"
	    $window tag bind l$position <Double-1>  "NISGroups $currenthost [lindex [split [lindex $data $position] ":"] 0] [lindex $data $position ]" 
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif { $type == 72 } {
	# ------------------------------  NIS HOSTS  --------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    lappend master $tmp
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 1 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lrange $tmp 2 end ]]
		append outline $tmp2
		$window insert end "$outline\n" l$position
		$window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		$window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		$window tag bind l$position <Button-1> "Selecter $window l$position"
		$window tag bind l$position <Double-1>  "NISHosts $currenthost [lindex [split [lindex $data $position] ] 0] [lindex $data $position ]" 
		if { [lindex $tmp 1 ] == "localhost" } {
		    $window tag configure l$position -foreground #0000a0
		} else {
		    $window tag configure l$position -foreground #000000
		}
	    }
	}
	$window configure -state disabled
    } elseif { $type == 90 } {
	# ------------------------   MAT Hosts Displayer  -----------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp2 [lindex $data $position ]
	    lappend master $tmp2
	    set tmp [split $tmp2 ":" ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    foreach line [ split [lindex $tmp 3 ] "," ] {
		if { $line == "DNS" } {
		    append outline "DNS Master, "
		} elseif { $line == "NIS" } {
		    append outline "NIS Master, "
		} elseif { $line == "NFS" } {
		    append outline "NFS Server, "
		} elseif { $line == "SAMBA" } {
		    append outline "Samba Server, "
		} elseif { $line == "TAPE" } {
		    append outline "Backup Host "
		} 
	    }
	    $window insert end "$outline\n" l$position
	    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
	    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
	    $window tag bind l$position <Button-1> "Selecter $window l$position"
	    $window tag bind l$position <Double-1>  "MatHost [lindex $data $position ]"
	    $window tag configure l$position -foreground #000000
	}
	$window configure -state disabled
    } elseif { $type == 91 } {
	# ---------------------------------  MAT USERS  ------------------------------
	global feature_list_file
	global feature_list
	set feature_list {}
	set fid [ open $feature_list_file r ]
	while { [ gets $fid fout ] > 0 } {
	    lappend feature_list $fout
	}
	close $fid
	for  { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    lappend master $tmp
	    set tmp2 [lindex [split $tmp ":" ] 0 ]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		# Don't use tmp2  needed for color
		foreach item [ perms2list  [string trim [lindex [split $tmp ":" ] 2 ]] $feature_list ] {
		    append outline "$item, "
		}
		$window insert end "$outline\n" l$position
		if { $tmp2 == "root" } {
		    $window tag configure l$position -foreground #000000
		    $window tag bind l$position <Any-Enter> ""
		    $window tag bind l$position <Any-Leave> ""
		    $window tag bind l$position <Button-1> ""
		    $window tag bind l$position <Double-1>  "" 
		} else {
		    $window tag bind l$position <Any-Enter> "$window tag configure l$position $bold"
		    $window tag bind l$position <Any-Leave> "$window tag configure l$position $normal"
		    $window tag bind l$position <Button-1> "Selecter $window l$position"
		    $window tag bind l$position <Double-1>  "MatUser $currenthost $position [lindex $data $position ]" 
		    $window tag configure l$position -foreground #0000a0
		}
	    }
	}
	$window configure -state disabled
    } else {
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    $window tag delete l$position
	    set tmp [lindex $data $position ]
	    $window insert end "$tmp\n" l$position
	    $window tag configure l$position -foreground #000000
	}
    }
    . config -cursor top_left_arrow
    $window config -cursor xterm
}



