/*

This is the main class for the DNS Administrator

 Version 1.0.3
 Copyright (c) 1998, Alex Rass.
 This software may be used and distributed according to the terms
 of the GNU Public License, incorporated herein by reference.
 Read the file COPYING, distributed with this package, for the full
 details of the GNU Public License.

Please send all the bug fixes and additions to the code to: utils@cybercreek.com
This way we can incorporate the changes and everyone will benefit from each
other's additions in the new versions.  If you do not do this, you will have
to make all the changes over and over, as new versions get released.

*/

import java.awt.*;
import javax.swing.*;
//import com.sun.java.swing.*;

public class FrameMain extends Frame {
    private String DomainFileName, DomainDirectoryPath;
    private Domain mainDomain;
    private int LastClicked=-1;
    public FrameMain() {
        //{{INIT_CONTROLS
		setLayout(null);
		setBackground(java.awt.Color.lightGray);
		setSize(240,532);
		setVisible(false);
		openFileDialog1.setMode(FileDialog.LOAD);
		openFileDialog1.setTitle("Open");
		//$$ openFileDialog1.move(24,328);
		pMenuFixer.setLayout(null);
		add(pMenuFixer);
		pMenuFixer.setBackground(java.awt.Color.black);
		pMenuFixer.setBounds(0,0,239,1);
		pDomainDetails.setLayout(null);
		add(pDomainDetails);
		pDomainDetails.setBounds(0,360,240,172);
		panelTop.setLayout(null);
		pDomainDetails.add(panelTop);
		panelTop.setBackground(java.awt.Color.white);
		panelTop.setBounds(0,0,240,2);
		panel6.setLayout(null);
		panelTop.add(panel6);
		panel6.setBackground(java.awt.Color.gray);
		panel6.setBounds(0,0,240,1);
		panel4.setLayout(null);
		pDomainDetails.add(panel4);
		panel4.setBackground(java.awt.Color.white);
		panel4.setBounds(0,130,240,2);
		panel7.setLayout(null);
		panel4.add(panel7);
		panel7.setBackground(java.awt.Color.gray);
		panel7.setBounds(0,0,240,1);
		pDomainDetails.add(tfLocalDomain);
		tfLocalDomain.setBounds(68,4,172,20);
		pDomainDetails.add(tfLocalDomainFilename);
		tfLocalDomainFilename.setBounds(68,24,172,20);
		pDomainDetails.add(taLocalDomainComment);
		taLocalDomainComment.setBounds(68,44,172,44);
		label4.setText("Comment:");
		pDomainDetails.add(label4);
		label4.setBounds(4,48,60,16);
		label5.setText("Filename:");
		pDomainDetails.add(label5);
		label5.setBounds(4,26,60,16);
		label6.setText("Domain:");
		pDomainDetails.add(label6);
		label6.setBounds(4,6,60,16);
		bWrite.setLabel("Write Changes!");
		pDomainDetails.add(bWrite);
		bWrite.setBackground(java.awt.Color.gray);
		bWrite.setBounds(20,140,132,24);
		bRevert.setLabel("Revert");
		pDomainDetails.add(bRevert);
		bRevert.setBackground(java.awt.Color.pink);
		bRevert.setBounds(156,140,50,24);
		label9.setText("Set as:");
		pDomainDetails.add(label9);
		label9.setBounds(4,88,60,16);
		rbPrimary.setCheckboxGroup(SetAs);
		rbPrimary.setState(true);
		rbPrimary.setLabel("Primary");
		pDomainDetails.add(rbPrimary);
		rbPrimary.setBounds(68,88,88,16);
		rbSecondary.setCheckboxGroup(SetAs);
		rbSecondary.setLabel("Secondary");
		pDomainDetails.add(rbSecondary);
		rbSecondary.setBounds(68,104,92,16);
		pGlobals.setLayout(null);
		add(pGlobals);
		pGlobals.setBounds(0,0,240,125);
		label1.setText("Domain:");
		pGlobals.add(label1);
		label1.setBounds(4,4,52,16);
		pGlobals.add(tfDomain);
		tfDomain.setBounds(68,4,172,20);
		label2.setText("Directory:");
		pGlobals.add(label2);
		label2.setBounds(4,24,52,16);
		pGlobals.add(tfDirectory);
		tfDirectory.setBounds(68,24,172,20);
		label3.setText("Service:");
		pGlobals.add(label3);
		label3.setBounds(4,44,52,16);
		pGlobals.add(tfService);
		tfService.setBounds(68,44,172,20);
		label7.setText("Cache:");
		pGlobals.add(label7);
		label7.setBounds(4,84,52,16);
		pGlobals.add(tfSortlist);
		tfSortlist.setBounds(68,64,172,20);
		pGlobals.add(tfCache1);
		tfCache1.setBounds(68,84,172,20);
		pGlobals.add(tfCache2);
		tfCache2.setBounds(68,104,172,20);
		label8.setText("Sortlist:");
		pGlobals.add(label8);
		label8.setBounds(4,64,52,16);
		pDomainList.setLayout(null);
		add(pDomainList);
		pDomainList.setBounds(0,127,240,232);
		panelTop1.setLayout(null);
		pDomainList.add(panelTop1);
		panelTop1.setBackground(java.awt.Color.white);
		panelTop1.setBounds(0,0,240,2);
		panel8.setLayout(null);
		panelTop1.add(panel8);
		panel8.setBackground(java.awt.Color.gray);
		panel8.setBounds(0,0,240,1);
		pDomainList.add(lDomains);
		lDomains.setBounds(0,4,240,200);
		bNew.setLabel("New");
		pDomainList.add(bNew);
		bNew.setBounds(50,209,50,20);
		bAdd.setLabel("Add / Save");
		pDomainList.add(bAdd);
		bAdd.setBounds(104,209,80,20);
		bDelete.setLabel("Delete");
		pDomainList.add(bDelete);
		bDelete.setBounds(188,209,50,20);
		lCount.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		lCount.setText("Test");
		pDomainList.add(lCount);
		lCount.setBackground(new java.awt.Color(204,204,204));
		lCount.setForeground(java.awt.Color.black);
		lCount.setFont(new Font("Dialog", Font.PLAIN, 12));
		lCount.setBounds(0,213,42,10);
		setTitle("DNS-Admin");
		//}}

        //{{INIT_MENUS
		menu1.setLabel("File");
		menu1.add(miOpen);
		miOpen.setLabel("Open...");
		menu1.add(miSave);
		miSave.setLabel("Save");
		menu1.addSeparator();
		menu1.add(miExit);
		miExit.setLabel("Exit");
		mainMenuBar.add(menu1);
		menu3.setLabel("Help");
		menu3.add(miAbout);
		miAbout.setLabel("About..");
		mainMenuBar.add(menu3);
		mainMenuBar.setHelpMenu(menu3);
		//$$ mainMenuBar.move(0,328);
		setMenuBar(mainMenuBar);
		//}}

        //{{REGISTER_LISTENERS
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        miOpen.addActionListener(lSymAction);
        miAbout.addActionListener(lSymAction);
        miExit.addActionListener(lSymAction);
        bRevert.addActionListener(lSymAction);
        SymItem lSymItem = new SymItem();
        lDomains.addItemListener(lSymItem);
        bDelete.addActionListener(lSymAction);
        bWrite.addActionListener(lSymAction);
        lDomains.addActionListener(lSymAction);
        bAdd.addActionListener(lSymAction);
        bNew.addActionListener(lSymAction);
        SymMouse aSymMouse = new SymMouse();
        bNew.addMouseListener(aSymMouse);
        bAdd.addMouseListener(aSymMouse);
        bDelete.addMouseListener(aSymMouse);
        bWrite.addMouseListener(aSymMouse);
        bRevert.addMouseListener(aSymMouse);
        rbPrimary.addMouseListener(aSymMouse);
        rbSecondary.addMouseListener(aSymMouse);
        //}}

        DomainFileName = "named.boot";
        DomainDirectoryPath = "/etc/";
        LoadDomainFile ();               // Load the rest of the form
    }

    public FrameMain(String title) {
        this();
        setTitle(title);
    }

    static public void main(String args[]) {
        (new FrameMain()).show();
    }

    public void addNotify() {
        // Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();

        super.addNotify();

        if (fComponentsAdjusted)
            return;

        // Adjust components according to the insets
        setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
        Component components[] = getComponents();
        for (int i = 0; i < components.length; i++) {
            Point p = components[i].getLocation();
            p.translate(getInsets().left, getInsets().top);
            components[i].setLocation(p);
        }
        fComponentsAdjusted = true;
    }

    // Used for addNotify check.
    boolean fComponentsAdjusted = false;

    //{{DECLARE_CONTROLS
	java.awt.FileDialog openFileDialog1 = new java.awt.FileDialog(this);
	java.awt.Panel pMenuFixer = new java.awt.Panel();
	java.awt.Panel pDomainDetails = new java.awt.Panel();
	java.awt.Panel panelTop = new java.awt.Panel();
	java.awt.Panel panel6 = new java.awt.Panel();
	java.awt.Panel panel4 = new java.awt.Panel();
	java.awt.Panel panel7 = new java.awt.Panel();
	java.awt.TextField tfLocalDomain = new java.awt.TextField();
	java.awt.TextField tfLocalDomainFilename = new java.awt.TextField();
	java.awt.TextArea taLocalDomainComment = new java.awt.TextArea("",0,0,TextArea.SCROLLBARS_NONE);
	java.awt.Label label4 = new java.awt.Label();
	java.awt.Label label5 = new java.awt.Label();
	java.awt.Label label6 = new java.awt.Label();
	java.awt.Button bWrite = new java.awt.Button();
	java.awt.Button bRevert = new java.awt.Button();
	java.awt.Label label9 = new java.awt.Label();
	java.awt.Checkbox rbPrimary = new java.awt.Checkbox();
	java.awt.CheckboxGroup SetAs = new java.awt.CheckboxGroup();
	java.awt.Checkbox rbSecondary = new java.awt.Checkbox();
	java.awt.Panel pGlobals = new java.awt.Panel();
	java.awt.Label label1 = new java.awt.Label();
	java.awt.TextField tfDomain = new java.awt.TextField();
	java.awt.Label label2 = new java.awt.Label();
	java.awt.TextField tfDirectory = new java.awt.TextField();
	java.awt.Label label3 = new java.awt.Label();
	java.awt.TextField tfService = new java.awt.TextField();
	java.awt.Label label7 = new java.awt.Label();
	java.awt.TextField tfSortlist = new java.awt.TextField();
	java.awt.TextField tfCache1 = new java.awt.TextField();
	java.awt.TextField tfCache2 = new java.awt.TextField();
	java.awt.Label label8 = new java.awt.Label();
	java.awt.Panel pDomainList = new java.awt.Panel();
	java.awt.Panel panelTop1 = new java.awt.Panel();
	java.awt.Panel panel8 = new java.awt.Panel();
	java.awt.List lDomains = new java.awt.List(4);
	java.awt.Button bNew = new java.awt.Button();
	java.awt.Button bAdd = new java.awt.Button();
	java.awt.Button bDelete = new java.awt.Button();
	javax.swing.JLabel lCount = new javax.swing.JLabel();
	//}}

    //{{DECLARE_MENUS
	java.awt.MenuBar mainMenuBar = new java.awt.MenuBar();
	java.awt.Menu menu1 = new java.awt.Menu();
	java.awt.MenuItem miOpen = new java.awt.MenuItem();
	java.awt.MenuItem miSave = new java.awt.MenuItem();
	java.awt.MenuItem miExit = new java.awt.MenuItem();
	java.awt.Menu menu3 = new java.awt.Menu();
	java.awt.MenuItem miAbout = new java.awt.MenuItem();
	//}}

    class SymWindow extends java.awt.event.WindowAdapter {
        public void windowClosing(java.awt.event.WindowEvent event) {
            Object object = event.getSource();
            if (object == FrameMain.this)
                Frame1_WindowClosing(event);
        }
    }

    void Frame1_WindowClosing(java.awt.event.WindowEvent event) {
        dispose();                       // free the system resources
        System.exit(0);                  // close the application
    }

    class SymAction implements java.awt.event.ActionListener {
        public void actionPerformed(java.awt.event.ActionEvent event) {
            Object object = event.getSource();
            if (object == miOpen)
                miOpen_Action(event);
            else if (object == miAbout)
                miAbout_Action(event);
            else if (object == miExit)
                miExit_Action(event);
            else if (object == miSave)
                bWrite_Action(event);
            else if (object == bRevert)
                bRevert_Action(event);
            else if (object == bDelete)
                bDelete_Action(event);
            else if (object == bWrite)
                bWrite_Action(event);
            else if (object == lDomains)
                lDomains_DblClicked(event);
            else if (object == bAdd)
                bAdd_Action(event);
            else if (object == bNew)
                bNew_Action(event);
        }
    }

    void miAbout_Action(java.awt.event.ActionEvent event) {
        JOptionPane.showMessageDialog (this, "DNS Administrator 1.0\nCopywrite (C) 1998 by Alex Rass", "About:", JOptionPane.INFORMATION_MESSAGE);
    }

    void miExit_Action(java.awt.event.ActionEvent event) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to quit?", "Exit?", JOptionPane.YES_NO_OPTION,
           JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION)
                System.exit(0);
    }

    void miOpen_Action(java.awt.event.ActionEvent event) {
        //{{CONNECTION
        // Action from Open... Show the OpenFileDialog
        openFileDialog1.show();
        //}}
        DomainFileName = openFileDialog1.getFile();
        if( DomainFileName  == null ) return;

        DomainDirectoryPath = openFileDialog1.getDirectory();
        if( DomainDirectoryPath  == null ) return;
        LoadDomainFile ();               // Load the rest of the form
    }

    void LoadDomainFile () {
        this.setTitle("DNS-Admin - "+ DomainDirectoryPath + DomainFileName );
        mainDomain = new Domain(DomainDirectoryPath + DomainFileName);
        tfDomain.setText(mainDomain.getDomain());
        tfDirectory.setText(mainDomain.getDirectory());
        tfService.setText(mainDomain.getService());
        tfSortlist.setText(mainDomain.getSortlist());
        tfCache1.setText(mainDomain.getCache1());
        tfCache2.setText(mainDomain.getCache2());
        lDomains.removeAll();
        if (mainDomain.getItemCount()>0)
        for (int lcv=0; lcv < mainDomain.getItemCount(); lcv++) {
            lDomains.add(mainDomain.getItem(lcv,0));
        }
        bRevert.setEnabled(mainDomain.fileOk());
        LastClicked = -1;
        lCount.setText(String.valueOf(mainDomain.getItemCount()));
    }

    class SymItem implements java.awt.event.ItemListener {
        public void itemStateChanged(java.awt.event.ItemEvent event) {
            Object object = event.getSource();
            if (object == lDomains)
                lDomains_ItemStateChanged(event);
        }
    }

    void lDomains_ItemStateChanged(java.awt.event.ItemEvent event) {
        int tmp = ((Integer)event.getItem()).intValue();
        tfLocalDomain.setText(mainDomain.getItem(tmp, 0));
        tfLocalDomainFilename.setText(mainDomain.getItem(tmp, 1));
        taLocalDomainComment.setText(mainDomain.getItem(tmp, 2));
        switch (mainDomain.getStatus(tmp)) {
            case 0: rbPrimary.setState(true); break;
            case 1: rbSecondary.setState(true); break;
        }
        LastClicked = tmp;
        //         lCount.setText(String.valueOf(LastClicked));
    }

    void lDomains_DblClicked(java.awt.event.ActionEvent event) {
        if (LastClicked>-1)
            (new FrameDetails(tfDirectory.getText()+'/'+mainDomain.getItem(LastClicked, 1))).show();
    }

    void bWrite_Action(java.awt.event.ActionEvent event) {
        mainDomain.setDomain(tfDomain.getText());
        mainDomain.setDirectory(tfDirectory.getText());
        mainDomain.setService(tfService.getText());
        mainDomain.setSortlist(tfSortlist.getText());
        mainDomain.setCache1(tfCache1.getText());
        mainDomain.setCache2(tfCache2.getText());
        //     if (!mainDomain.fileOk())

        if (mainDomain.writeOut(DomainDirectoryPath + DomainFileName))
            bRevert.setEnabled(true);
        else
            JOptionPane.showMessageDialog (this, "Could not write the file!", "Error:", JOptionPane.ERROR_MESSAGE);
    }

    void bRevert_Action(java.awt.event.ActionEvent event) {
        LoadDomainFile();
    }

    void bAdd_Action(java.awt.event.ActionEvent event) {
        String tmp = tfLocalDomain.getText();
        int found = -1;
        if (!tmp.equals("")) {
            if ((LastClicked > -1) && (!tmp.equals(lDomains.getItem(LastClicked))))
                // u have created a new entry.  overwrite/add?
                LastClicked = -1;

            if (LastClicked == -1) {
                found = mainDomain.findItem(tmp);
                if ((found >-1) && (found != LastClicked)) {
                    int result =JOptionPane.showConfirmDialog(null, "Such entry found.\n Overwrite?", "Error:", JOptionPane.YES_OPTION + JOptionPane.CANCEL_OPTION, JOptionPane.ERROR_MESSAGE);
                    if (result==0)
                        LastClicked = found;
                    else
                        return;
                }
            }
            if (LastClicked == -1) {
                lDomains.add (tmp);
                LastClicked = mainDomain.addItem();
            }
            else
                lDomains.replaceItem(tmp, LastClicked);
            mainDomain.setItem(LastClicked, 0, tfLocalDomain.getText());
            mainDomain.setItem(LastClicked, 1, tfLocalDomainFilename.getText());
            mainDomain.setItem(LastClicked, 2, taLocalDomainComment.getText());
            mainDomain.setStatus(LastClicked, rbPrimary.getState()?0:1);
            lDomains.select(LastClicked);
            lCount.setText(String.valueOf(mainDomain.getItemCount()));
        }
    }

    void bDelete_Action(java.awt.event.ActionEvent event) {
        if ((LastClicked>-1) && (LastClicked<lDomains.getItemCount())) {
            lDomains.remove(LastClicked);
            mainDomain.delItem(LastClicked);
        }
        LastClicked = -1;
        lCount.setText(String.valueOf(mainDomain.getItemCount()));
    }

    void bNew_Action(java.awt.event.ActionEvent event) {
        if (LastClicked >-1) {
            lDomains.deselect(LastClicked);
            LastClicked = -1;
        }
        lCount.setText(String.valueOf(mainDomain.getItemCount()));
    }

    class SymMouse extends java.awt.event.MouseAdapter {
        public void mouseEntered(java.awt.event.MouseEvent event) {
            Component cpt = (Component) event.getSource();
            cpt.setForeground(Color.blue.darker().darker());
        }
        public void mouseExited(java.awt.event.MouseEvent event) {
            Component cpt = (Component) event.getSource();
            cpt.setForeground(Color.black);
        }
    }
}


