/*

FrameMain is the main class for the DNS Administrator

 Copyright (c) 1998, by Alex Rass.
 This software may be used and distributed according to the terms
 of the GNU Public License, incorporated herein by reference.
 Read the file COPYING, distributed with this package, for the full
 details of the GNU Public License.

Please send all the bug fixes and additions to the code to: utils@cybercreek.com
This way we can incorporate the changes and everyone will benefit from each
other's additions in the new versions.  If you do not do this, you will have
to make all the changes over and over, as new versions get released.

*/

import java.awt.*;
import javax.swing.*;
//import Details;
//import com.sun.java.swing.*;

public class FrameDetails extends Frame {
    private String DetailsFile = null;
    private Details mainDetails;
    private int LastClicked=-1;
    private ButtonGroup bgrpType = new ButtonGroup();
    public boolean openedSelf = false;

    public FrameDetails() {
        //{{INIT_CONTROLS
        setVisible(false);
        setLayout(null);
        setBackground(Color.lightGray);
        setSize(542,297);
        openFileDialog1.setMode(FileDialog.LOAD);
        openFileDialog1.setTitle("Open");
        //$$ openFileDialog1.move(28,68);
        pMenuFixer.setLayout(null);
        add(pMenuFixer);
        pMenuFixer.setBackground(Color.black);
        pMenuFixer.setBounds(0,0,555,1);
        rbSNS.setSelected(true);
        rbSNS.setText("Name Server");
        bgrpType.add(rbSNS);
        add(rbSNS);
        rbSNS.setFont(new Font("Dialog", Font.PLAIN, 12));
        rbSNS.setBounds(341,120,110,16);
        rbSNS.setBackground(Color.lightGray);
        rbMail.setText("Mail Exchanger");
        rbMail.setFont(new Font("Dialog", Font.PLAIN, 12));
        rbMail.setBounds(341,136,110,16);
        rbMail.setBackground(Color.lightGray);
        bgrpType.add(rbMail);
        add(rbMail);
        rbAddress.setText("Address");
        rbAddress.setFont(new Font("Dialog", Font.PLAIN, 12));
        rbAddress.setBounds(341,152,110,16);
        rbAddress.setBackground(Color.lightGray);
        bgrpType.add(rbAddress);
        add(rbAddress);
        rbAlias.setText("Alias");
        rbAlias.setFont(new Font("Dialog", Font.PLAIN, 12));
        rbAlias.setBounds(341,168,110,16);
        rbAlias.setBackground(Color.lightGray);
        bgrpType.add(rbAlias);
        add(rbAlias);
        rbPoint.setFont(new Font("Dialog", Font.PLAIN, 12));
        rbPoint.setBounds(341,184,110,16);
        rbPoint.setText("Address Point");
        rbPoint.setBackground(Color.lightGray);
        bgrpType.add(rbPoint);
        add(rbPoint);
        label1.setText("Domain:");
        add(label1);
        label1.setBounds(4,6,76,16);
        add(tfDomain);
        tfDomain.setBounds(84,4,172,20);
        label2.setText("Primary NS:");
        add(label2);
        label2.setBounds(4,26,76,16);
        add(tfPNS);
        tfPNS.setBounds(84,24,172,20);
        label3.setText("Contact:");
        add(label3);
        label3.setBounds(4,46,76,16);
        add(tfEmail);
        tfEmail.setBounds(84,44,172,20);
        label4.setText("Serial Number:");
        add(label4);
        label4.setBounds(276,6,104,16);
        add(tfSerial);
        tfSerial.setBounds(384,4,158,20);
        label5.setText("Refresh Period:");
        add(label5);
        label5.setBounds(276,26,104,16);
        add(tfRefresh);
        tfRefresh.setBounds(384,24,158,20);
        label6.setText("Time b/w Retries:");
        add(label6);
        label6.setBounds(276,46,104,16);
        add(tfRetry);
        tfRetry.setBounds(384,44,158,20);
        label7.setText("Time till Expiration:");
        add(label7);
        label7.setBounds(276,66,106,16);
        add(tfExpire);
        tfExpire.setBounds(384,64,158,20);
        label8.setText("Time to Live:");
        add(label8);
        label8.setBounds(276,86,104,16);
        add(tfTTL);
        tfTTL.setBounds(384,84,158,20);
        add(lDomains);
        lDomains.setBounds(0,116,240,180);
        bNew.setLabel("New");
        add(bNew);
        bNew.setBounds(244,132,72,24);
        bAdd.setLabel("Add / Save");
        add(bAdd);
        bAdd.setBounds(244,156,72,24);
        bDelete.setLabel("Delete");
        add(bDelete);
        bDelete.setBounds(244,180,72,24);
        bSort.setLabel("Sort");
        add(bSort);
        bSort.setBounds(244,208,72,24);
        bSort.setVisible(false);
        panel3.setLayout(null);
        add(panel3);
        panel3.setBackground(java.awt.Color.white);
        panel3.setBounds(264,4,2,104);
        panel2.setLayout(null);
        panel3.add(panel2);
        panel2.setBackground(java.awt.Color.gray);
        panel2.setBounds(0,0,1,104);
        panel1.setLayout(null);
        add(panel1);
        panel1.setBackground(java.awt.Color.white);
        panel1.setBounds(4,108,534,2);
        panel4.setLayout(null);
        panel1.add(panel4);
        panel4.setBackground(java.awt.Color.gray);
        panel4.setBounds(0,0,534,1);
        bWrite.setLabel("Write Changes!");
        add(bWrite);
        bWrite.setBackground(java.awt.Color.gray);
        bWrite.setBounds(68,72,132,24);
        bRevert.setLabel("Revert");
        bRevert.setEnabled(false);
        add(bRevert);
        bRevert.setBackground(java.awt.Color.pink);
        bRevert.setBounds(204,72,50,24);
        pEditDetails.setLayout(null);
        add(pEditDetails);
        pEditDetails.setBounds(244,208,300,88);
        lDomainName.setText("Domain Name:");
        pEditDetails.add(lDomainName);
        lDomainName.setBounds(4,6,88,16);
        pEditDetails.add(tfDomainName);
        tfDomainName.setBounds(98,4,200,20);
        lPriority.setText("Priority:");
        pEditDetails.add(lPriority);
        lPriority.setBounds(4,26,56,16);
        pEditDetails.add(tfPriority);
        tfPriority.setBounds(98,24,96,20);
        lServerName.setText("Server Name:");
        pEditDetails.add(lServerName);
        lServerName.setBounds(4,46,84,16);
        pEditDetails.add(tfServerName);
        tfServerName.setBounds(98,44,200,20);
        label12.setText("Comment:");
        pEditDetails.add(label12);
        label12.setBounds(4,66,84,16);
        pEditDetails.add(tfComment);
        tfComment.setBounds(98,64,200,20);
        lHint.setText("0 - 4 billion");
        pEditDetails.add(lHint);
        lHint.setBounds(198,26,68,16);
        lCount.setHorizontalAlignment(SwingConstants.RIGHT);
        lCount.setText("Test");
        add(lCount);
        lCount.setBackground(new java.awt.Color(204,204,204));
        lCount.setForeground(java.awt.Color.black);
        lCount.setFont(new Font("Dialog", Font.PLAIN, 12));
        lCount.setBounds(244,116,68,10);
        setTitle("DNS-Admin");
        setResizable(false);
        //}}

        //{{INIT_MENUS
        menu1.setLabel("File");
        menu1.add(miOpen);
        miOpen.setLabel("Open...");
        menu1.add(miSave);
        miSave.setLabel("Save");
        menu1.addSeparator();
        menu1.add(miExit);
        miExit.setLabel("Exit");
        mainMenuBar.add(menu1);
        menu3.setLabel("Help");
        menu3.add(miAbout);
        miAbout.setLabel("About..");
        mainMenuBar.add(menu3);
        //$$ mainMenuBar.move(8,68);
        setMenuBar(mainMenuBar);
        //}}

        //{{REGISTER_LISTENERS
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        miOpen.addActionListener(lSymAction);
        miAbout.addActionListener(lSymAction);
        miExit.addActionListener(lSymAction);
        SymItem lSymItem = new SymItem();
        rbSNS.addItemListener(lSymItem);
        rbMail.addItemListener(lSymItem);
        rbAddress.addItemListener(lSymItem);
        rbAlias.addItemListener(lSymItem);
        rbPoint.addItemListener(lSymItem);
        SymMouse aSymMouse = new SymMouse();
        bSort.addMouseListener(aSymMouse);
        bNew.addMouseListener(aSymMouse);
        bAdd.addMouseListener(aSymMouse);
        bDelete.addMouseListener(aSymMouse);
        bWrite.addMouseListener(aSymMouse);
        bRevert.addMouseListener(aSymMouse);
        rbSNS.addMouseListener(aSymMouse);
        rbMail.addMouseListener(aSymMouse);
        rbAddress.addMouseListener(aSymMouse);
        rbAlias.addMouseListener(aSymMouse);
        rbPoint.addMouseListener(aSymMouse);
        lDomains.addItemListener(lSymItem);
        bNew.addActionListener(lSymAction);
        bAdd.addActionListener(lSymAction);
        bDelete.addActionListener(lSymAction);
        bSort.addActionListener(lSymAction);
        bRevert.addActionListener(lSymAction);
        bWrite.addActionListener(lSymAction);
        //}}

        handleRdrbPoint_ItemStateChanged();
    }

    public FrameDetails(String title) {
        this();
        setTitle("DNS-Admin - "+title);
        setLocation (50, 50);
        DetailsFile = title;
        LoadDetailsFile ();              // Load the rest of the form
    }

    static public void main(String args[]) {
        FrameDetails nf = new FrameDetails();
        nf.show();
        nf.openedSelf = true;
    }

    public void addNotify() {
        // Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();

        super.addNotify();

        if (fComponentsAdjusted)
            return;

        // Adjust components according to the insets
        setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
        Component components[] = getComponents();
        for (int i = 0; i < components.length; i++) {
            Point p = components[i].getLocation();
            p.translate(getInsets().left, getInsets().top);
            components[i].setLocation(p);
        }
        fComponentsAdjusted = true;
    }

    // Used for addNotify check.
    boolean fComponentsAdjusted = false;

    //{{DECLARE_CONTROLS
    java.awt.FileDialog openFileDialog1 = new java.awt.FileDialog(this);
    java.awt.Panel pMenuFixer = new java.awt.Panel();
    JRadioButton rbSNS = new JRadioButton();
    JRadioButton rbMail = new JRadioButton();
    JRadioButton rbAddress = new JRadioButton();
    JRadioButton rbAlias = new JRadioButton();
    JRadioButton rbPoint = new JRadioButton();
    java.awt.Label label1 = new java.awt.Label();
    java.awt.TextField tfDomain = new java.awt.TextField();
    java.awt.Label label2 = new java.awt.Label();
    java.awt.TextField tfPNS = new java.awt.TextField();
    java.awt.Label label3 = new java.awt.Label();
    java.awt.TextField tfEmail = new java.awt.TextField();
    java.awt.Label label4 = new java.awt.Label();
    java.awt.TextField tfSerial = new java.awt.TextField();
    java.awt.Label label5 = new java.awt.Label();
    java.awt.TextField tfRefresh = new java.awt.TextField();
    java.awt.Label label6 = new java.awt.Label();
    java.awt.TextField tfRetry = new java.awt.TextField();
    java.awt.Label label7 = new java.awt.Label();
    java.awt.TextField tfExpire = new java.awt.TextField();
    java.awt.Label label8 = new java.awt.Label();
    java.awt.TextField tfTTL = new java.awt.TextField();
    java.awt.List lDomains = new java.awt.List(4);
    java.awt.Button bNew = new java.awt.Button();
    java.awt.Button bAdd = new java.awt.Button();
    java.awt.Button bDelete = new java.awt.Button();
    java.awt.Button bSort = new java.awt.Button();
    java.awt.Panel panel3 = new java.awt.Panel();
    java.awt.Panel panel2 = new java.awt.Panel();
    java.awt.Panel panel1 = new java.awt.Panel();
    java.awt.Panel panel4 = new java.awt.Panel();
    java.awt.Button bWrite = new java.awt.Button();
    java.awt.Button bRevert = new java.awt.Button();
    java.awt.Panel pEditDetails = new java.awt.Panel();
    java.awt.Label lDomainName = new java.awt.Label();
    java.awt.TextField tfDomainName = new java.awt.TextField();
    java.awt.Label lPriority = new java.awt.Label();
    java.awt.TextField tfPriority = new java.awt.TextField();
    java.awt.Label lServerName = new java.awt.Label();
    java.awt.TextField tfServerName = new java.awt.TextField();
    java.awt.Label label12 = new java.awt.Label();
    java.awt.TextField tfComment = new java.awt.TextField();
    java.awt.Label lHint = new java.awt.Label();
    JLabel lCount = new JLabel();
    //}}

    //{{DECLARE_MENUS
    java.awt.MenuBar mainMenuBar = new java.awt.MenuBar();
    java.awt.Menu menu1 = new java.awt.Menu();
    java.awt.MenuItem miOpen = new java.awt.MenuItem();
    java.awt.MenuItem miSave = new java.awt.MenuItem();
    java.awt.MenuItem miExit = new java.awt.MenuItem();
    java.awt.Menu menu3 = new java.awt.Menu();
    java.awt.MenuItem miAbout = new java.awt.MenuItem();
    //}}

    class SymWindow extends java.awt.event.WindowAdapter {
        public void windowClosing(java.awt.event.WindowEvent event) {
            Object object = event.getSource();
            if (object == FrameDetails.this)
                Frame1_WindowClosing(event);
        }
    }

    void Frame1_WindowClosing(java.awt.event.WindowEvent event) {
        setVisible(false);
        dispose();                       // free the system resources
        if (openedSelf)
            System.exit(0); // close the application
    }

    class SymAction implements java.awt.event.ActionListener {
        public void actionPerformed(java.awt.event.ActionEvent event) {
            Object object = event.getSource();
            if (object == miOpen)
                miOpen_Action(event);
            else if (object == miAbout)
                miAbout_Action(event);
            else if (object == miExit)
                miExit_Action(event);
            else if (object == bNew)
                bNew_ActionPerformed(event);
            else if (object == bAdd)
                bAdd_ActionPerformed(event);
            else if (object == bDelete)
                bDelete_ActionPerformed(event);
            else if (object == bSort)
                bSort_ActionPerformed(event);
            else if (object == bRevert)
                bRevert_ActionPerformed(event);
            else if (object == bWrite)
                bWrite_ActionPerformed(event);
        }
    }

    void miAbout_Action(java.awt.event.ActionEvent event) {
        JOptionPane.showMessageDialog (this, "DNS Administrator 1.0.3\nCopywrite (C) 1998, 1999 by ALex Rass", "About:", JOptionPane.INFORMATION_MESSAGE);
    }

    void miExit_Action(java.awt.event.ActionEvent event) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to quit?", "Exit?", JOptionPane.YES_NO_OPTION,
        JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION) {
            setVisible(false);
            dispose();
        }
    }

    void miOpen_Action(java.awt.event.ActionEvent event) {
        //{{CONNECTION
        // Action from Open... Show the OpenFileDialog
        openFileDialog1.show();
        //}}
        if ( openFileDialog1.getFile() == null ) return;

        DetailsFile = openFileDialog1.getDirectory() + openFileDialog1.getFile() ;
        if( DetailsFile  == null ) return;

        LoadDetailsFile ();              // Load the rest of the form
    }

    void LoadDetailsFile () {
        this.setTitle("Domain: "+ DetailsFile);
        if ((DetailsFile==null) | DetailsFile.equals(""))
            return;
        mainDetails = new Details(DetailsFile);
        tfDomain.setText(mainDetails.getDomain());
        tfPNS.setText(mainDetails.getPrimaryNameServer());
        tfEmail.setText(mainDetails.getAdminEmailAddress());
        tfSerial.setText(mainDetails.getSerial());
        tfRefresh.setText(mainDetails.getRefresh());
        tfRetry.setText(mainDetails.getRetry());
        tfExpire.setText(mainDetails.getExpire());
        tfTTL.setText(mainDetails.getMinimumTTL());
        lDomains.removeAll();
        if (mainDetails.getItemCount()>0)
        for (int lcv=0; lcv < mainDetails.getItemCount(); lcv++) {
            lDomains.add(mainDetails.getItem(lcv,0));
        }
        bRevert.setEnabled(mainDetails.fileOk());
        LastClicked = -1;
        lCount.setText(String.valueOf(mainDetails.getItemCount()));
    }


    class SymItem implements java.awt.event.ItemListener {
        public void itemStateChanged(java.awt.event.ItemEvent event) {
            Object object = event.getSource();
            if ((object == rbSNS)|(object == rbMail)|(object == rbAddress)|(object == rbAlias)|(object == rbPoint))
                handleRdrbPoint_ItemStateChanged();
            else if (object == lDomains)
                lDomains_ItemStateChanged(event);
        }
    }

    void handleRdrbPoint_ItemStateChanged() {
        lPriority.setVisible(rbMail.isSelected());
        tfPriority.setVisible(rbMail.isSelected());
        lHint.setVisible(rbMail.isSelected());

        if (rbSNS.isSelected()) {
            lDomainName.setText("Domain Name:");
            lServerName.setText("Server Name:");
        }
        if (rbMail.isSelected()) {
            lDomainName.setText("Domain Name:");
            lServerName.setText("Server Name:");
        }
        if (rbAddress.isSelected()) {
            lDomainName.setText("Host Name:");
            lServerName.setText("IP Address:");
        }
        if (rbAlias.isSelected()) {
            lDomainName.setText("Alias:");
            lServerName.setText("Server Name:");
        }
        if (rbPoint.isSelected()) {
            lDomainName.setText("IP Address:");
            lServerName.setText("Server Name:");
        }
    }

    class SymMouse extends java.awt.event.MouseAdapter {
        public void mouseEntered(java.awt.event.MouseEvent event) {
            Component cpt = (Component) event.getSource();
            cpt.setForeground(Color.blue.darker().darker());
        }

        public void mouseExited(java.awt.event.MouseEvent event) {
            Component cpt = (Component) event.getSource();
            cpt.setForeground(Color.black);
        }
    }

    void lDomains_ItemStateChanged(java.awt.event.ItemEvent event) {
        int tmp = ((Integer)event.getItem()).intValue();
        tfDomainName.setText(mainDetails.getItem(tmp, 0));
        tfPriority.setText("");
        if  (mainDetails.getItem(tmp, 1) == null)
            System.err.println("Null inside the value"+tmp);
        if (mainDetails.getItem(tmp, 1).equals("in ns"))
            rbSNS.setSelected(true);
        else if (mainDetails.getItem(tmp, 1).equals("in mx")) {
            rbMail.setSelected(true);
            tfPriority.setText(mainDetails.getItem(tmp, 2));
        }
        else if (mainDetails.getItem(tmp, 1).equals("in a"))
            rbAddress.setSelected(true);
        else if (mainDetails.getItem(tmp, 1).equals("in cname"))
            rbAlias.setSelected(true);
        else if (mainDetails.getItem(tmp, 1).equals("in ptr"))
            rbPoint.setSelected(true);

                                         // reinforce rb rules
        handleRdrbPoint_ItemStateChanged();
        tfServerName.setText(mainDetails.getItem(tmp, 3));
        tfComment.setText(mainDetails.getItem(tmp, 4));
        LastClicked = tmp;
    }

    void bNew_ActionPerformed(java.awt.event.ActionEvent event) {
        if (LastClicked >-1)
            lDomains.deselect(LastClicked);
        LastClicked = -1;

        /*              tfDomainName.setText("");
                    tfPriority.setText("");
                        tfServerName.setText("");
                        tfComment.setText(""); */
    }

    boolean notAnInt(TextField tfIn) {
        try {
            new Integer(tfIn.getText());
        }
        catch (NumberFormatException ne) {
            tfIn.requestFocus();
            return true;
        }
        return false;
    }

    boolean hasAnAt(TextField tfIn) {
        int pos = tfIn.getText().indexOf('@');
        if (pos!=-1) {
            tfIn.requestFocus();
            return true;
        }
        return false;
    }

    void bAdd_ActionPerformed(java.awt.event.ActionEvent event) {
        String tmp = tfDomainName.getText();
        String type = "";
        int found = -1;
        boolean goon=true;
        if (!tmp.equals("")) {
            if (rbSNS.isSelected()) {
                type = "in ns";
                //                  if (Test4TrailingPeriodFails (tfDomainName)) {
                //                    JOptionPane.showMessageDialog (this, "Domain Name should have a period at the end!", "Error:", JOptionPane.ERROR_MESSAGE);
                //                    return;
            }
            else if (rbMail.isSelected()) {
                type = "in mx";
                if (notAnInt(tfPriority)) {
                    JOptionPane.showMessageDialog (this, "Mail server priority should be an number!", "Error:", JOptionPane.ERROR_MESSAGE);
                    return;
                }
            }
            else if (rbAddress.isSelected()) {
                type = "in a";
            }
            else if (rbAlias.isSelected()) {
                type = "in cname";
            }
            else if (rbPoint.isSelected()) {
                type = "in ptr";
            }
            if ((LastClicked > -1) && (!tmp.equals(lDomains.getItem(LastClicked))))
                LastClicked = -1;        // u have created a new entry.  overwrite/add?

            if (LastClicked == -1) {
                found = mainDetails.findItem(tmp);
                if ((found >-1) && (found != LastClicked)) {
                    int result = JOptionPane.showConfirmDialog(null, "Another such entry found.\nOverwrite?", "Warning:", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.WARNING_MESSAGE);
                    if (result==0)
                        LastClicked = found;
                    else if (result == 2)
                        return;
                }
            }
            if (LastClicked == -1) {
                lDomains.add (tmp);
                LastClicked = mainDetails.addItem();
            } else
                lDomains.replaceItem(tmp, LastClicked);

            mainDetails.setItem(LastClicked, 0, tmp);
            mainDetails.setItem(LastClicked, 1, type);
            mainDetails.setItem(LastClicked, 2, tfPriority.getText());
            mainDetails.setItem(LastClicked, 3, tfServerName.getText());
            mainDetails.setItem(LastClicked, 4, tfComment.getText());
            lDomains.select(LastClicked);
            lCount.setText(String.valueOf(mainDetails.getItemCount()));
        }
    }

    void bDelete_ActionPerformed(java.awt.event.ActionEvent event) {
        if ((LastClicked>-1) && (LastClicked<lDomains.getItemCount())) {
            lDomains.remove(LastClicked);
            mainDetails.delItem(LastClicked);
            lCount.setText(String.valueOf(mainDetails.getItemCount()));
        }
        LastClicked = -1;
    }

    void bSort_ActionPerformed(java.awt.event.ActionEvent event) {
        tfDomainName.setText(" ");
    }

    void bRevert_ActionPerformed(java.awt.event.ActionEvent event) {
        LoadDetailsFile();
    }

    void bWrite_ActionPerformed(java.awt.event.ActionEvent event) {
        if (hasAnAt(tfEmail)) {
            JOptionPane.showMessageDialog (this, "Replace @ with a '.'!", "Error:", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (notAnInt(tfSerial)) {
            JOptionPane.showMessageDialog (this, "Serial Number must be a number!", "Error:", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (notAnInt(tfRefresh)) {
            JOptionPane.showMessageDialog (this, "Refresh Period must be a number!", "Error:", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (notAnInt(tfRetry)) {
            JOptionPane.showMessageDialog (this, "Time b/w Retries must be a number!", "Error:", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (notAnInt(tfExpire)) {
            JOptionPane.showMessageDialog (this, "Time till Expiration must be a number!", "Error:", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (notAnInt(tfTTL)) {
            JOptionPane.showMessageDialog (this, "Time to Live must be a number!", "Error:", JOptionPane.ERROR_MESSAGE);
            return;
        }
        mainDetails.setDomain(tfDomain.getText());
        mainDetails.setPrimaryNameServer(tfPNS.getText());
        mainDetails.setAdminEmailAddress(tfEmail.getText());
        mainDetails.setSerial(tfSerial.getText());
        mainDetails.setRefresh(tfRefresh.getText());
        mainDetails.setRetry(tfRetry.getText());
        mainDetails.setExpire(tfExpire.getText());
        mainDetails.setMinimumTTL(tfTTL.getText());
        //              mainDetails.set(.getText());

        if (mainDetails.writeOut(DetailsFile))
            bRevert.setEnabled(true);
        else
            JOptionPane.showMessageDialog (this, "Could not write the file!", "Error:", JOptionPane.ERROR_MESSAGE);
    }
}


