/*

 Copyright (c) 1998, Alex Rass.
 This software may be used and distributed according to the terms
 of the GNU Public License, incorporated herein by reference.
 Read the file COPYING, distributed with this package, for the full
 details of the GNU Public License.

 FrameMain is the main class for the DNS Administrator


 Please send all the bug fixes and additions to the code to: utils@cybercreek.com
 This way we can incorporate the changes and everyone will benefit from each
 other's additions in the new versions.  If you do not do this, you will have
 to make all the changes over and over, as new versions get released.

 */

import java.io.*;
import java.util.*;

public class Domain {
    protected String ActualFilePath;
    protected String domain;
    private String directory, service, sortlist;
    private String cache[] = new String [3];
    protected String entries[];
    protected int fieldCount = 0;
    protected List db = new ArrayList(20);
    protected boolean fileOpened=false;

    public Domain(){
        fieldCount = 4;
    }

    public Domain(String FilePath) {
        this();
        String comment=new String("");
        ActualFilePath = new String(FilePath);
        directory = "/etc";
        FileReader fr;
        try {
            fr = new FileReader( FilePath );
        }
        catch( IOException ioe ) {
            //                      lstOutput.addItem( "Error opening: " + FilePath );
            return;
        }
        fileOpened = true;
        try {
            BufferedReader dis = new BufferedReader( fr );

            String str;
            int index = 0;

            do {
                str = dis.readLine();
                if( str != null ) {
                    // separate out the declarations
                    str.trim();
                    if (str.equals("")) {
                        // save on processing
                    }
                    else if (str.startsWith(";")) {
                        comment = (comment.equals("")?"":comment + "\n") + str.substring(1).trim();
                    }
                    else if (str.startsWith("domain")) {
                        domain = str.substring(7).trim();
                    }
                    else if (str.startsWith("directory")) {
                        directory = str.substring(10).trim();
                    }
                    else if (str.startsWith("service")) {
                        service = str.substring(8).trim();
                    }
                    else if (str.startsWith("sortlist")) {
                        sortlist = str.substring(9).trim();
                    }
                    else if (str.startsWith("cache")) {
                        str = str.substring(6).replace('\t', ' ').trim();
                        index = str.indexOf(' ');
                        if (index > 0) {
                            // IP
                            cache[0] = str.substring(0, index);
                            // filename
                            cache[1] = str.substring(index).trim();
                        }
                        else {
                            // IP
                            cache[0] = str;
                            // filename
                            cache[1] = "";
                        }
                        // fill arrays with the rest
                        // comment
                        cache[2] = comment;
                        comment = "";
                    }
                    else if (str.startsWith("primary") | str.startsWith("secondary")) {
                        index = 8;
                        entries = new String[fieldCount];
                        entries[3] = "primary";
                        if (str.startsWith("secondary")) {
                            index = 10;
                            entries[3] = "secondary";
                        }
                        str =  str.substring(index).trim().replace('\t', ' ');
                        index = str.indexOf(' ');
                        if (index > 0) {
                            // IP
                            entries[0] = str.substring(0, index);
                            // filename
                            entries[1] = str.substring(index).trim();
                        }
                        else {
                            // IP
                            entries[0] = str;
                            // filename
                            entries[1] = "";
                        }
                        // fill arrays with the rest
                        // comment
                        entries[2] = comment;
                        db.add(entries);
                        comment = "";
                    }
                }
                else {
                    // Do whatever needs to be done afterwards
                }
            }
            while ( str != null);
            //                      done
        }
        catch( IOException ioe ) {
            //                  lstOutput.addItem( "Error reading file: " + ioe );
        }
    }

    boolean fileOk()                {        return fileOpened;}
    String getDomain ()             {        return domain;    }
    String getDirectory()           {        return directory; }
    String getService()             {        return service;   }
    String getSortlist()            {        return sortlist;  }
    String getCache1 ()             {        return cache[0];  }
    String getCache2 ()             {        return cache[1];  }
    void setDomain (String in)      {        domain = in;      }
    void setDirectory(String in)    {        directory = in;   }
    void setService(String in)      {        service = in;     }
    void setSortlist(String in)     {        sortlist = in;    }
    void setCache1 (String in)      {        cache[0] = in;    }
    void setCache2 (String in)      {        cache[1] = in;    }
    int getStatus (int index) {
        try {
            entries = (String[])db.get(index);
            return entries[3].equals("secondary")?1:0;
        }
        catch (Exception e) {
            return -1;
        }
        finally {
            entries = null;
        }
    }

    void setStatus (int index, int status) {
        entries = (String[])db.get(index);
        if (status==0)
            entries[3]="primary";
        else
            entries[3]="secondary";
        db.set(index, entries);
        entries = null;
    }

    int getItemCount ()                 {
        return db.size();
    }

    String getItem (int index, int field) {
        if ((field>=0) & (field < fieldCount)) {
            entries = (String[])db.get(index);
            return entries[field];
        }
        else {
            System.err.println("Field value out of bounds: "+field);
            return null;
        }

    }
    void setItem (int index, int field, String value) {
        if ((field>=0) & (field < fieldCount)) {
            entries = (String[])db.get(index);
            entries[field] = value;
            db.set(index, entries);
            entries = null;
        }
    }
    int addItem () {
        db.add(new String[fieldCount]);
        return db.size()-1;
    }
    void delItem(int index) {
        db.remove(index);
    }
    int findItem(String srch) {
        for (int index = 0; index<db.size(); index++) {
            entries = (String[])db.get(index);
            if (entries[0].equals(srch)) {
                entries = null;
                return index;
            }
        }
        entries = null;
        return -1;
    }
    protected  void writeLn(DataOutputStream dos, String tmp, String value) throws IOException {
        if ((value!=null) && !value.equals("")) {
            String ws = tmp+value+'\n';
            dos.writeBytes(ws);          //.toCharArray(), 0, ws.length()
        }
    }

    boolean writeOut(String FilePath) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream( FilePath+".txt" );
        }
        catch( IOException ioe ) {
            return false;
        }
        try {
            DataOutputStream dos = new DataOutputStream( fos );

            writeLn(dos, "domain ", domain);
            writeLn(dos, "directory ", directory);
            writeLn(dos, "service ", service);
            writeLn(dos, "sortlist ", sortlist);
            writeLn(dos, "; ", cache[2]);
            if (((cache[0]!=null) && !cache[0].equals("")) ||
                ((cache[1]!=null) && !cache[1].equals("")) )
                writeLn(dos, "cache ", cache[0]+'\t'+cache[1]);
            //          System.err.println("here 12");
            Iterator iter = db.iterator();
            while (iter.hasNext()) {
                entries = (String[])iter.next();
                writeLn(dos, "; ", entries[2]);
                writeLn(dos, entries[3]+'\t', entries[0]+'\t'+entries[1]);
            }
            entries = null;
            dos.flush();
        }
        catch( IOException ioe ) {
            return false;
        }
        return true;
    }
}
