/*


 Copyright (c) 1998, Alex Rass.
 This software may be used and distributed according to the terms
 of the GNU Public License, incorporated herein by reference.
 Read the file COPYING, distributed with this package, for the full
 details of the GNU Public License.

 FrameMain is the main class for the DNS Administrator
 The class in this files inherits from another class in the program.

 Please send all the bug fixes and additions to the code to: utils@cybercreek.com
 This way we can incorporate the changes and everyone will benefit from each
 other's additions in the new versions.  If you do not do this, you will have
 to make all the changes over and over, as new versions get released.

 */

import java.io.*;
import java.util.*;


public class Details extends Domain {
    private String primarynameserver, adminemailaddress; // domain already exists
    private String serial, refresh, retry, expire, minimumttl;
    public Details() {
        fieldCount = 5;
    }
    public Details(String FilePath) {
        this();
        String comment=new String("");
        String temp = null;
        ActualFilePath = FilePath;
        FileReader fr;
        try {
            fr = new FileReader( FilePath );
        }
        catch( IOException ioe ) {
            //                      lstOutput.addItem( "Error opening: " + FilePath );
            serial = "1";
            refresh = "10800";           // 3 hours
            retry = "3600";              // 1 hour
            expire = "604800";           // 1 week
            minimumttl = "86400";        // 1 day
            domain = "@";
            return;
        }
        fileOpened = true;
        try {
            BufferedReader dis = new BufferedReader( fr );

            String str;
            //                      int index = 0;
            boolean start = true;
            boolean goon = true;         // the goon system is in place just in case the str gets set to null
            do {
                str = dis.readLine();
                if (str == null)
                    goon = false;
                else {
                    // separate out the declarations
                    str.trim();
                    if (str.equals("")) {
                        // save on processing - disregard
                    }
                    else if (str.startsWith(";")) {
                        comment = (comment.equals("")?"":comment + "\n") + str.substring(1).trim();
                    }                    // beginning of the file
                    else if (start) {
                        str = str.replace('\t', ' ').trim();

                        if (domain == null) {
                            domain = getNextWord(str);
                            str = str.substring(domain.length()).trim();

                            /*                                if ( domain.toLowerCase().endsWith(".in-addr.arpa") )
                             domain =  domain.substring(0,domain.length()-13);
                             if ( domain.toLowerCase().endsWith(".in-addr.arpa.") )
                             domain =  domain.substring(0,domain.length()-14); */
                            // IN
                            primarynameserver  = getNextWord(str);
                            str = str.substring(primarynameserver.length()).trim();
                            // SOA
                            primarynameserver  = getNextWord(str);
                            str = str.substring(primarynameserver.length()).trim();
                            primarynameserver = getNextWord(str);
                            str = str.substring(primarynameserver.length()).trim();
                            adminemailaddress = getNextWord(str);
                            if ( adminemailaddress.endsWith("(") )
                                adminemailaddress =  adminemailaddress.substring(0,minimumttl.length()-1);
                        }
                        else if (serial == null)
                            serial = getNextWord(str);
                        else if (refresh == null)
                            refresh = getNextWord(str);
                        else if (retry == null)
                            retry = getNextWord(str);
                        else if (expire == null)
                            expire = getNextWord(str);
                        else if (minimumttl == null) {
                            minimumttl = getNextWord(str);
                            if ( minimumttl.endsWith(")") )
                                minimumttl =  minimumttl.substring(0,minimumttl.length()-1);
                            start = false;
                        }
                    }                    // entries.
                    else {
                        str = str.replace('\t', ' ').trim();
                        entries = new String[fieldCount];
                        entries[0] = getNextWord(str);
                        temp = entries[0];
                        str = str.substring(entries[0].length()).trim();
                        // make up for empty ones
                        if (entries[0].toLowerCase().equals("in")) {
                            if (temp!=null)
                                entries[0] = temp;
                            else
                                entries[0] = "ERROR.";
                            str = "in "+ str;
                        }
                        // in
                        entries[1] = getNextWord(str).toLowerCase();
                        str = str.substring(entries[1].length()).trim();
                        // second part
                        entries[1] = "in "+getNextWord(str).toLowerCase();
                        str = str.substring(entries[1].length()-3).trim();
                        if (entries[1].equals("in mx")) {
                            // Priority
                            entries[2] = getNextWord(str).toLowerCase();
                            str = str.substring(entries[2].length()).trim();
                        }
                        entries[3] = getNextWord(str);
                        str = str.substring(entries[3].length()).trim();
                        entries[4] = comment;
                        // end stuff:
                        db.add(entries);
                        comment = "";
                    }
                }
            }
            while ( goon );
            //                      done
        }
        catch( IOException ioe ) {
            //                  lstOutput.addItem( "Error reading file: " + ioe );
        }
    }

    String getPrimaryNameServer()   {        return primarynameserver;    }
    String getAdminEmailAddress()   {        return adminemailaddress;    }
    String getSerial()              {        return serial;    }
    String getRefresh()             {        return refresh;    }
    String getRetry()               {        return retry;    }
    String getExpire()              {        return expire;    }
    String getMinimumTTL()          {        return minimumttl;    }
    void setPrimaryNameServer(String in)   {        primarynameserver = in;    }
    void setAdminEmailAddress(String in)   {        adminemailaddress = in;    }
    void setSerial(String in)              {        serial = in;    }
    void setRefresh(String in)             {        refresh = in;    }
    void setRetry(String in)               {        retry = in;    }
    void setExpire(String in)              {        expire = in;    }
    void setMinimumTTL(String in)          {        minimumttl = in;    }

    boolean writeOut(String FilePath) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream( FilePath+".txt" );
        }
        catch( IOException ioe ) {
            return false;
        }
        try {
            DataOutputStream dos = new DataOutputStream( fos );

            dos.writeBytes(domain+" IN SOA "+primarynameserver+" "+adminemailaddress+" (\n");
            dos.writeBytes("\t"+serial+"\t;Serial\n");
            dos.writeBytes("\t"+refresh+"\t;Refresh\n");
            dos.writeBytes("\t"+retry+"\t;Retry\n");
            dos.writeBytes("\t"+expire+"\t;Expire\n");
            dos.writeBytes("\t"+minimumttl+" )\t;Minimum TTL\n");
            Iterator iter = db.iterator();
            while (iter.hasNext()) {
                entries = (String[])iter.next();
                writeLn(dos, "; ", entries[4]);
                dos.writeBytes(entries[0]+'\t'+entries[1]+'\t'+((entries[2]==null)?"":entries[2]+'\t')+entries[3]+'\n');
            }

            dos.flush();
        }
        catch( IOException ioe ) {
            return false;
        }
        return true;
    }

    String getNextWord (String line) {
        // should speed things up
        if ((line == null) | line.equals("")) return line;
        line.trim();
        int fs = line.indexOf(' ');
        if (fs > 0) {
            return line.substring(0,fs);
        }
        return line;
    }
}


