#ifndef ___UTMPDATA_H___
#define ___UTMPDATA_H___

#pragma interface 

#include <utmp.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <stdio.h>

#include "template.h" /* it is for the sake of some our object mechanisms */

#define MAXDEVICELEN 15

/*******************************************************************
          Let us think here  what structures shall we need 
                  for wtmp accounting ..... 
  1. probably we shall need per-tty summary of time usage 
     for particular user both for today and overall.
  2. probably we shall need overall site activity accounting...    
********************************************************************/

// Flags for TtyUsageInfo.UsageProps
#define TUI_LOGGED_NOW (1u)
#define TUI_HAS_CRASHES (1u << 1) /* if system had crashes while user was logged on */
// the following is for RecheckUtmp in admind
#define TUI_LOGGED_RECENTLY ( 1u << 2 )

struct TtyUsageInfo : public listItem < TtyUsageInfo > 
{
  char 	          Line [ UT_LINESIZE+ 1];
  char            AbbrevLine [ 3 ]; /* abbreviated tty name */
  time_t          Usage;
  time_t          LastLog;
  time_t          LastLogout;
  unsigned        UsageProps;
  pid_t           LastPid;
  
  TtyUsageInfo () 
  { 
    Usage = 0; 
    LastLog = LastLogout =0; 
    UsageProps = 0;
    LastPid = 0;
    Line [0 ] = 0; 
  };
  TtyUsageInfo ( char* Lin ) 
  { 
    strncpy ( Line, Lin, UT_LINESIZE );
    Line [ UT_LINESIZE ] = 0;
    Usage = 0;
    LastLog = LastLogout =0;
    UsageProps = 0;
    LastPid = 0;
  };
};	

// the following is for nacctd -- per-device statistics
struct DeviceUsageInfo : public listItem < DeviceUsageInfo >
{
  char   DeviceName [ MAXDEVICELEN + 1 ];
  unsigned long   InTraffic;
  unsigned long   OutTraffic;
  
  DeviceUsageInfo(char* device ) 
  {
    strncpy ( DeviceName, device, MAXDEVICELEN );
    DeviceName [ MAXDEVICELEN ] = 0; // make sure to fix it
    InTraffic = OutTraffic = 0;
  };
};

struct UserLimitInfo : public listItem < UserLimitInfo >
{
  char UserName [ UT_NAMESIZE + 1] ;
//  unsigned Props; // properties
  
  // this field is for nacctd accounting:
  unsigned long InTraffic; // accumulated traffic from nacctd 
  unsigned long OutTraffic; // Output traffic 
  time_t  TotalUsage; // total time usage for all ttys
  
  listBaseAutoDel < TtyUsageInfo > TtyBase ;
  listBaseAutoDel < DeviceUsageInfo > DeviceBase;
  
  UserLimitInfo ( ) { UserName [ 0 ] = 0;  };
  UserLimitInfo ( char* uname_pr ) 
  { 
    strncpy ( UserName, uname_pr, UT_NAMESIZE );
    UserName[ UT_NAMESIZE ] = 0; // fix it
//    Props=0;
    InTraffic = OutTraffic = 0;
  };
  
  TtyUsageInfo* AddTtyUsageInfo ( char* Line );
  TtyUsageInfo* FindTtyUsageInfo ( char* Line );
  DeviceUsageInfo* AddDeviceUsageInfo ( char* device );
  DeviceUsageInfo* FindDeviceUsageInfo ( char* device );
};
  
  
class RootWtmp : public listBaseAutoDel < UserLimitInfo >
{
public:
  UserLimitInfo* FindUserLimitInfo ( char* UserName );
  UserLimitInfo* AddUserLimitInfo ( char* UserName );
  TtyUsageInfo*  FindUserTtyUsageInfo ( char* UserName, char* Line );
  
  int SendToStream ( FILE* file );
  int ReadFromStream ( FILE* file );
};


#endif /* ___UTMPDATA_H___ */