#pragma implementation

#include "utmpdata.h"
#include "memdata.h"
#include "common.h"

/****************************************************************
  explicit template generation
*****************************************************************/
template class listItem < TtyUsageInfo >;
template class listBase < TtyUsageInfo >;
template class listBaseAutoDel < TtyUsageInfo >;

template class listItem < UserLimitInfo >;
template class listBase < UserLimitInfo >;
template class listBaseAutoDel < UserLimitInfo >;

template class listItem < DeviceUsageInfo >;
template class listBase < DeviceUsageInfo >;
template class listBaseAutoDel < DeviceUsageInfo >;

/***************************************************************
          going to implementation of methods 
****************************************************************/

TtyUsageInfo* UserLimitInfo ::
AddTtyUsageInfo ( char* Line )
{
  TtyUsageInfo* tui_pr = new TtyUsageInfo ( Line );
  TtyBase . Add ( tui_pr );
#ifndef NO_DEBUG
  Log2 (5, "UserLimitInfo::AddTtyUsageInfo:Added tty %s for user %s usage %ld Props %d\n", 
    tui_pr -> Line,
    UserName, tui_pr -> Usage, tui_pr -> UsageProps );
#endif

  
  return tui_pr ; 
}

TtyUsageInfo* UserLimitInfo ::
FindTtyUsageInfo ( char* Line )
{
  TtyUsageInfo* tui_pr;
  for ( 
    tui_pr = TtyBase . base ;
    tui_pr; 
    tui_pr = tui_pr -> next
  )
    if ( !strcmp ( Line, tui_pr ->Line ) ) break;
  return tui_pr ;
}

DeviceUsageInfo* UserLimitInfo::
FindDeviceUsageInfo ( char* device ) return dui_pr
{
  for ( dui_pr = DeviceBase . base;
    dui_pr;
    dui_pr = dui_pr -> next
  )
    if ( !strcmp ( dui_pr -> DeviceName, device ) ) break;
  return dui_pr;
}

DeviceUsageInfo* UserLimitInfo::
AddDeviceUsageInfo ( char* device ) return dui_pr
{
  dui_pr = new DeviceUsageInfo ( device );
  DeviceBase . Add ( dui_pr );
  return dui_pr;
}
    

UserLimitInfo* RootWtmp:: 
FindUserLimitInfo ( char* UserName )
{
  UserLimitInfo* uli_pr;
  for ( 
    uli_pr = base;
    uli_pr;
    uli_pr = uli_pr -> next 
  )
    if ( ! strcmp ( UserName, uli_pr -> UserName ) ) break;
  return uli_pr;
};

UserLimitInfo* RootWtmp::
AddUserLimitInfo ( char* UserName )
{
  UserLimitInfo* uli_pr = new UserLimitInfo;
  strncpy ( uli_pr -> UserName, UserName,UT_NAMESIZE );
  uli_pr -> UserName [ UT_NAMESIZE ] = 0;
  Add (uli_pr );
  return uli_pr;
};

TtyUsageInfo* RootWtmp::
FindUserTtyUsageInfo ( char* UserName, char* Line )
{
  UserLimitInfo* uli_pr = FindUserLimitInfo ( UserName );
  if ( uli_pr == NULL ) return NULL;
  TtyUsageInfo* tui_pr = uli_pr -> FindTtyUsageInfo ( Line);
  return tui_pr;
}

/*****************************************************************
       COMMUNICATING SERVICES
******************************************************************/
int RootWtmp::
SendToStream ( FILE* file)
{
  unsigned size = Size ();

  if ( 1 != fwrite ( (void*) &size, sizeof ( size ), 1, file ))
    return -1;
  
  UserLimitInfo* uli_pr;
  for ( 
    uli_pr = base;
    uli_pr;
    uli_pr = uli_pr -> next 
  )
  {
    // sendign UserName
    if ( 1 != fwrite ( (void*) uli_pr -> UserName, UT_NAMESIZE+1,1,file))
      return -1;
//    if ( 1 != fwrite ( (void* ) &uli_pr -> Props, 
//      sizeof ( uli_pr -> Props ), 1, file ))
//      return -1;
    if ( 1!= fwrite  ( (void* ) &uli_pr -> TotalUsage,
      sizeof ( uli_pr -> TotalUsage ),1, file ))
      return -1;

#ifdef NACCTD_SUPPORT
    if ( 1 != fwrite ( (void* )& uli_pr -> InTraffic, 
      sizeof ( uli_pr -> InTraffic ), 1, file ) ||
      1 != fwrite ( (void* ) &uli_pr -> OutTraffic,
      sizeof ( uli_pr -> OutTraffic ), 1, file ))
      return -1;
      
#ifndef NO_DEBUG
    Log2 (5, "RootWtmp::SendToStream:Send InTraffic=%lu,OutTraffic=%lu\n", 
      uli_pr -> InTraffic, uli_pr -> OutTraffic );
#endif
#endif      
    
    // sending TtyUsageInfos
    size  = uli_pr -> TtyBase . Size ();
    if ( 1 != fwrite ( (void* ) &size , sizeof ( size ), 1, file ))
      return -1;
    
    TtyUsageInfo* tui_pr;
    
    for (
      tui_pr = uli_pr -> TtyBase. base;
      tui_pr;
      tui_pr = tui_pr -> next
    )
    {
      // sending Line
      if ( 1 != fwrite ( (void* ) tui_pr -> Line, UT_LINESIZE +1, 1, file))
        return -1;
      if ( 1 != fwrite ( (void* ) tui_pr -> AbbrevLine, 3, 1, file ))
        return -1;
      if ( 1 != fwrite ( (void* ) &tui_pr -> Usage, 
        sizeof ( tui_pr -> Usage ), 1, file ))
        return -1;
      if ( 1 != fwrite ( (void* ) &tui_pr -> LastLog,
        sizeof ( tui_pr -> LastLog ), 1, file ) ||
        1 != fwrite ( (void* ) &tui_pr -> LastLogout,
        sizeof ( tui_pr -> LastLogout ), 1, file ))
        return -1;
      if ( 1 != fwrite ( ( void* ) &tui_pr -> UsageProps,
        sizeof ( tui_pr -> UsageProps ), 1, file ))
        return -1;
      if ( 1 != fwrite ( ( void * ) &tui_pr -> LastPid, 
        sizeof ( tui_pr -> LastPid ), 1, file ))
        return -1;
      // seemingly, dat's all
    }
    // sending device infos
    size = uli_pr -> DeviceBase . Size();
    if  ( 1 != fwrite ( (void* )&size, sizeof ( size ), 1, file ))
      return -1;
    DeviceUsageInfo* dui_pr;
    for ( 
      dui_pr = uli_pr -> DeviceBase . base;
      dui_pr;
      dui_pr = dui_pr -> next 
    )
    {
      if ( 1 != fwrite ( (void*) dui_pr -> DeviceName, 
        sizeof ( dui_pr -> DeviceName ), 1, file ) ||
        1 != fwrite ( (void* )&dui_pr -> InTraffic,
        sizeof ( dui_pr -> InTraffic ), 1, file ) ||
        1 != fwrite ( (void*) &dui_pr -> OutTraffic,
        sizeof ( dui_pr -> OutTraffic ), 1, file ))
      return -1;
    }
      

  }

  return 0;
}

int RootWtmp::
ReadFromStream ( FILE* file )
{

  // clean current wtmp
  while ( tail ) delete tail;

  // reading the no of users
  unsigned users, i;
  UserLimitInfo* uli_pr;
  
  if ( 1 != fread ( (void* ) &users, sizeof ( users ),1 , file ))
    return -1;
    
#ifndef NO_DEBUG      
  sprintf ( LogBuff, "RootWtmp::ReadFromStream: got %u users\n", users );
  Log ( 4 );
#endif  


  for ( i = 0; i < users; i++ )
  {
    char tmp [ UT_NAMESIZE + 1 ];
    if ( 1 != fread ( (void*) tmp, UT_NAMESIZE + 1, 1, file ))
      return -1;
     
    uli_pr = AddUserLimitInfo ( tmp );
    
//    if ( 1 != fread ( (void* )&uli_pr -> Props, 
//      sizeof ( Props ),1, file ))
//      return -1;
    if ( 1 != fread ( (void* ) &uli_pr -> TotalUsage,
      sizeof ( uli_pr -> TotalUsage ), 1, file ))
      return -1;
      
#ifdef NACCTD_SUPPORT
    if ( 1 != fread ( (void* )& uli_pr -> InTraffic, 
      sizeof ( uli_pr -> InTraffic ), 1, file ) ||
      1 != fread ( (void* )& uli_pr -> OutTraffic,
      sizeof ( uli_pr -> OutTraffic ), 1, file ))
      return -1;
      
#ifndef NO_DEBUG
    Log2 (5, "RootWtmp::SendToStream:Send InTraffic=%lu,OutTraffic=%lu\n", 
      uli_pr -> InTraffic, uli_pr -> OutTraffic );
#endif
#endif      
  
    unsigned ttys, k;
    TtyUsageInfo* tui_pr;
    
    
    if ( 1 != fread ( (void*) &ttys, sizeof ( ttys ), 1, file ))
      return -1;
      
    for ( k =0; k< ttys; k++ )
    {
      char line_tmp [ UT_LINESIZE + 1];
      if ( 1 != fread ( (void* ) line_tmp, UT_LINESIZE + 1, 1, file ))
        return -1;
      tui_pr = uli_pr -> AddTtyUsageInfo ( line_tmp);
      
      if ( 1 != fread ( (void* ) tui_pr -> AbbrevLine, 3, 1, file ))
        return -1;
      if ( 1 != fread ( (void*) &tui_pr -> Usage, 
        sizeof ( tui_pr -> Usage ), 1, file ))
        return -1;
      if ( 1 != fread ( (void* ) &tui_pr -> LastLog, 
        sizeof ( tui_pr -> LastLog ), 1, file )||
        1 != fread ( (void* ) &tui_pr -> LastLogout,
        sizeof ( tui_pr -> LastLogout ), 1, file ))
        return -1;
      if ( 1 != fread ( (void* ) &tui_pr -> UsageProps,
        sizeof ( tui_pr -> UsageProps ), 1, file ))
        return -1;
        
      if ( 1 != fread ( (void* ) &tui_pr -> LastPid,
        sizeof ( tui_pr -> LastPid ), 1, file ))
        return -1;
    }
    
    // reading device infos
    unsigned devices;
    if ( 1 != fread ( (void* ) &devices, sizeof ( devices ), 1, file ))
      return -1;

#ifndef NO_DEBUG
    Log2 ( 3, "RootWtmp:: ReadFromStream: got %d nacctd devices \n",
      devices );
#endif

    for ( k = 0; k < devices; k++ )
    {
      DeviceUsageInfo* dui_pr;
      char devname_tmp [ MAXDEVICELEN + 1 ];
      
      if ( 1 != fread ( (void* ) devname_tmp, sizeof ( devname_tmp ),
        1, file ))
        return -1;
      dui_pr = uli_pr -> AddDeviceUsageInfo ( devname_tmp );
      
      if ( 1 != fread ( (void* ) &dui_pr -> InTraffic, 
        sizeof ( dui_pr -> InTraffic ), 1, file ) ||
        1 != fread ( (void* ) &dui_pr -> OutTraffic,
        sizeof ( dui_pr -> OutTraffic ), 1, file ))
        return -1;
    }
      
  }
  return 0;
}

