#ifndef ___TEMPLATE_H___
#define ___TEMPLATE_H___

#pragma interface

/*****************************************listBase impl.********************/
template <class ListItem>
class listBase
{
public :
  ListItem *base, *tail;
  unsigned size;

  listBase ( void ) { base = tail = NULL;  size = 0;};
  virtual ~listBase ( void );

  ListItem& operator[] ( unsigned index );

  void Add ( ListItem* item );
  void Insert ( ListItem* after, ListItem* item );
  void Remove ( ListItem* item );
  unsigned Size ( void );
};


// this class is implemented _WITHOUT_ autodeletion on destruction. 
// you need either explicitly delete your list items in you destructor 
// for ex: 
//   class SomeWhat : public listBase < SomeItem > 
//   {
//        ~SomeWhat () { while ( tail) delete tail; }   
//   } 
///      or you need listBaseAutoDel <> . 

template <class ListItem>
void listBase<ListItem> ::
Add ( ListItem* Item )
{
	if ( Item -> base )
	  Item -> base -> Remove ( Item );

	if ( base == NULL )
	{
	  base = tail =  Item;
	  Item -> prev = Item -> next = 0;
	  Item -> base = this;
	  size = 1;

	}
	else
	{
		tail -> next = Item;
		Item -> prev = tail;
		tail = Item;
		Item -> next = NULL;
		Item -> base = this;
		size ++;
	}
	return;
}

template <class ListItem>
void listBase <ListItem> ::
Insert ( ListItem* after, ListItem* item )
{
	if ( item -> base )
	  item -> base -> Remove ( item );

	if ( after -> base != this ) return;

	item -> next = after -> next;
	after -> next = item;
	item -> prev = after;

	if ( tail == after ) tail = item;
	size ++;

	return;
}

template <class ListItem>
ListItem& listBase<ListItem> ::
operator [] ( unsigned index )
{
	unsigned i;
	ListItem* item = base;

	for ( i = 0; i < index; i++ )
	  item = item -> next;

	return *item;
}

template < class ListItem >
listBase<ListItem> ::
~listBase ( void )
{
  while ( tail != NULL )
	 Remove ( tail );

}

template < class ListItem >
void listBase<ListItem> ::
Remove ( ListItem* item )
{
	if ( item -> next )
	  item -> next -> prev = item -> prev;
	if ( item -> prev )
	  item -> prev -> next = item -> next;

	if ( base == item ) base = item -> next;
	if ( tail == item ) tail = item -> prev;

	item -> next = item -> prev  = NULL;
	item -> base = NULL;

	size --;
}

template < class ListItem >
unsigned listBase <ListItem > ::
Size ( void )
{
   ListItem* item_pr;
   unsigned count;
   
   for ( 
     count = 0, item_pr = base;
     item_pr;
     item_pr = item_pr -> next, count++ )
   ;
   
   return count;
}

/***********************listBaseAutoDel***************************/
template <class ListItem > 
class listBaseAutoDel : public listBase <ListItem>
{
public :
  virtual ~listBaseAutoDel ( void ) 
  {
    while ( tail ) delete tail;
  };
};

/********************listItem*************************************/
template <class ListItem >
class listItem
{
public:

  ListItem *prev, *next;
  listBase<ListItem> *base;

  listItem ( void ) { prev = next = NULL; base = NULL; };
  listItem ( ListItem* prev, ListItem* next )
  {
	listItem :: prev = prev;
	listItem :: next = next ;
	base = NULL;
  };
  virtual ~listItem ( void );

};

template <class ListItem>
listItem<ListItem> ::
~listItem ( void )
{
	if ( base != NULL )
		base -> Remove ( (ListItem*) this );
}




#endif /* ___TEMPLATE_H___ */