#ifndef ___PARSE_H___
#define ___PARSE_H___

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

//#pragma hdrstop


#include "template.h"

#pragma interface

#define MAXSEPLEN 3 /* separator maximum length, not including final 0 */
#define MAXKEYWORDLEN 32 /* maximum word len for keyword */
#define COMSEP " \t\n\r" /* Common separator symbols */
#define COMMENT_START_SYMBOL '#'
#define COMMENT_END_SYMBOL '\n'

#define MAXDAYOFWEEKLEN 3
#define MONDAY "MON"
#define TUESDAY "TUE"
#define WEDNESDAY "WED"
#define THURSDAY "THU"
#define FRIDAY "FRI"
#define SATURDAY "SAT"
#define SUNDAY "SUN"

#define MONDAY_VAL 1
#define TUESDAY_VAL 2
#define WEDNESDAY_VAL 3
#define THURSDAY_VAL 4
#define FRIDAY_VAL 5
#define SATURDAY_VAL 6
#define SUNDAY_VAL 0 /* common misunderstanding is when I assume it being 7:) */

/********************** some service here ******************************/
extern int is_alpha ( int symbol );
extern int is_digit ( int symbol ) ;
extern int is_alphdig ( int symbol );

/************************************************************************
	 The following is self-made soft for type safe runtime downcasting
	 for unix compatibility. Under intellectual compilers you'd surely
	 use their standard mechanisms, for ex., in Borland C++
	 you would rather use RTTL extensions library and their
	 very useful DECLARE_CASTABLE, IMPLEMENT_CASTABLE and
	 TYPESAFE_DOWNCAST macros and also dynamic_cast function;
	 but my primary aim was g++, and so far i dont know
	 whether it supports RTTL and what class library it has.
		This guarantee the source will go under any ANSI C++ compiler
		( difficulties with templates though may be run in...)
	2 aug 1996 : changed macros for runtime downcasting -both 
	declaring and implementation ( function body was transferred to 
	implementation )
*************************************************************************/
#define DECLARE_CLASSTAG \
public:                 \
	static char ClassTag[]
	
#define DECLARE_CAST     \
public:						\
  DECLARE_CLASSTAG;				\
  virtual void* IsMostDerived ( char* cl );	\
  virtual void* FindBase ( char* cl )		

#define IMPLEMENT_MOSTDERIVED(cls)                   \
void* cls::    \
  IsMostDerived ( char* cl )    \
{                                             \
		if ( !strcmp ( cls::ClassTag, cl ) )        \
			return ( void* ) this;                    \
		return NULL;                                \
}

#define IMPLEMENT_CLASSTAG(cls) \
char cls::ClassTag[] = #cls

#define IMPLEMENT_CAST1(cls,base1)             \
	IMPLEMENT_CLASSTAG(cls);                            \
	IMPLEMENT_MOSTDERIVED(cls);                    \
void* cls:: \
FindBase( char* cl )        \
{                                         \
	if ( !strcmp ( cls::ClassTag, cl ) )   \
		return (void*) this;                 \
	return base1::FindBase ( cl);          \
}

#define IMPLEMENT_CAST2(cls,base1,base2)       \
IMPLEMENT_CLASSTAG;                            \
IMPLEMENT_MOSTDERIVED(cls);                  \
void* cls::	\
FindBase( char* cl )        \
{                                         \
	void* result;                          \
	if ( !strcmp ( cls::ClassTag,cl  ) )   \
		return (void*) this;                 \
	if ( result = base1::FindBase ( cl ) != NULL )       \
		return result;                  \
	return base2::FindBase ( cl);     \
}

#define IMPLEMENT_CAST3(cls,base1,base2,base3)   \
IMPLEMENT_CLASSTAG;                              \
IMPLEMENT_MOSTDERIVED(cls);                     \
void* cls::				\
FindBase( char* cl )           \
{                                            \
	void* result;                              \
	if ( !strcmp ( cls::ClassTag, cl ) )       \
		return (void*) this;                     \
	if ( result = base1::FindBase( cl) != NULL  )  \
		return result;                               \
	if ( result = base2::FindBase(cl) != NULL )    \
		return result;            \
	return base3::FindBase (cl);     \
}

#define DOWNCAST(obj_pr,cast_to)              \
	(obj_pr?(cast_to*) (obj_pr) -> FindBase ( cast_to::ClassTag ):NULL)

#define DOWNCAST_MOSTDERIVED(obj_pr,cast_to)                                  \
	(obj_pr?(cast_to*) ( obj_pr ) -> IsMostDerived ( cast_to::ClassTag ) : NULL)

/* this would not work with object created from templates. Use
	this runtime castable mechanism with object derived from template
	instead.
	i.e. you cannot use DOWNCAST ( stem_pr, MonoList<Word> )
	thus, this is not a strong restriction though.. tip: jump over
	template bases as the following :

	class DayList : public MonoList <DayOfWeek>
	{
		DECLARE_CAST;
		...
	};

	that is, skip MonoList and pose "stem" as "base1", for "stem" is base for
	"MonoList"... But most important, you can use it
	with template arguments :

	template <class TStemObject>
	void TemplateClass<TStemObject>::TemplateMember(void )
	{
		stem* stem_pr;
		...
		TStemObject* StemObject_pr = DOWNCAST ( stem_pr, TStemObject );
		if ( StemObject_pr == NULL )
			...
	}

	DOWNCAST_MOSTDERIVED works the same way DOWNCAST does except
	the former returns valid pointer only if the most derived
	object is exactly of type submitted. It returns NULL
	even though the submitted type exists but not most derived in the object.

	DOWNCAST_MOSTDERIVED would be more preferable in cases when
	it is known in advance that if object has an instance of
	submitted base then this is the most derived instance 'cause
	DOWNCAST_MOSTDERIVED works a bit quicker, especially with
	large-scale hierarchical structures.


	*/



// ohter useful hickeys
#define MAX(x,y) ( (x) > (y)? (x) : (y) )
#define MIN(x,y) ( (x) < (y)? (x) : (y) )

class TCastableBase
{
public:
	virtual void* FindBase ( char* cl );/* { return NULL; }; */
};

/************************************************************************
	 supplementary classes
*************************************************************************/

/**************************************************************************

						simple stems ( primitives )
**************************************************************************/

class stem : public TCastableBase
{
	DECLARE_CAST;
public:

	unsigned  sp, np; /* start position, next position; np-sp = len */

	stem ( void ) { sp = np = NULL; };
	stem ( unsigned s, unsigned n ) { sp = s; np = n; };

	virtual int LocateLtoR ( char* str, unsigned s, unsigned n ) { return -1; };
	virtual int LocateRtoL ( char* str, unsigned s, unsigned n ) { return -1; };

	virtual ~stem ( void ) { };

};

class stemListItem :
	public stem, public listItem < stemListItem>
{ };

/****************** Stem pseudo-stream *******************************/
class stemStream
{
public :
	char* str;
	unsigned stream_sp, stream_np;

	stemStream ( void ) { str = NULL; stream_sp = stream_np = 0; };
	stemStream ( char* strng, unsigned s, unsigned n )
	{
		str = strng;
		stream_sp = s; stream_np = n;
	};

	virtual stemStream operator>> ( stem* stem_pr );
	virtual stemStream operator<< ( stem* stem_pr );
	virtual int operator== ( int l ) { return ( stream_np - stream_sp == l); };
	virtual int operator== ( stem* stem_pr )
	{
		return ( stream_sp == stem_pr -> sp && stream_np == stem_pr -> np );
	};
	virtual int operator== ( stemStream* stemStream_pr )
	{
		return ( stream_sp == stemStream_pr -> stream_sp &&
		  stream_np == stemStream_pr -> stream_np );
	};

	virtual stemStream& operator= ( stemStream& strm )
	{
		str = strm . str;
		stream_sp = strm. stream_sp;
		stream_np = strm. stream_np;

		return *this;
	};
	virtual int is_valid ( void ) { return  ( str != NULL ); };

};

/******************************** other primitives ***************************************/
class Word : public stemListItem
{
	DECLARE_CAST;
public:
	int LocateLtoR ( char* str, unsigned s, unsigned n );
 /*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

class Keyword : public Word
{
	DECLARE_CAST;
public:
	char value [ MAXKEYWORDLEN + 1];
	Keyword ( char* Key ) { strcpy ( value, Key ); };
	Keyword ( ) { value [ 0 ] = 0; };

	int LocateLtoR ( char* str, unsigned s, unsigned n )
	{
		if ( Word :: LocateLtoR ( str, s, n ) )
			return -1;
		if ( np-sp != strlen ( value ) )
			return -1;

		if ( memcmp ( &str[ sp ], value, np-sp))
			return -1;

		return 0;
	};
  /* int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

class Uns: public stemListItem
{
	DECLARE_CAST;
public :

	unsigned value;

	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */

};

class UnsLong:public stemListItem
{
  DECLARE_CAST;
public:
  unsigned long value;
  
  int LocateLtoR ( char* str, unsigned s, unsigned n );
/* int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

class UnsBytes:public UnsLong
{
  DECLARE_CAST;
public:
  int LocateLtoR ( char* str, unsigned s, unsigned n );
/* int LocateRtoL ( char* str, unsigned s, unsigned n );*/
};

class Quotas:public stemListItem
{
  DECLARE_CAST;
public :
  char QuotaSymbol;
  Quotas ( ) { QuotaSymbol='"'; };
  Quotas ( char quota_symbol ) { QuotaSymbol=quota_symbol; };
  
  int LocateLtoR ( char* str, unsigned s, unsigned n );
/* int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};  

class Separator : public stemListItem
{
	DECLARE_CAST;
public :
	char Sep [ MAXSEPLEN + 1 ];

	Separator ( char* sep_string ) { strcpy (  Sep, sep_string ); };
	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

class ComSep : public Separator
{
	DECLARE_CAST;
public:

	ComSep ( void ) : Separator ( "" ) { };

	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

class UnsHour : public Uns
{
	DECLARE_CAST;
public :
	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

class UnsMin : public Uns
{
	DECLARE_CAST;
public :
	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

class DayOfWeek : public Word
{
	DECLARE_CAST;
public:
	unsigned value;

	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

/******************************************************************************
		Complex classes
*******************************************************************************/

/* NOTE: class StemItem should contain an instance of listItem <StemItem> */
/* NOTE: classes StemItem, RVal and LVal should have default constructor */
/* NOTE: all StemItem, RVal and LVal should have an instance of stem inside */
/* NOTE: template objects dont participate in DOWNCAST mechanism */
/* see also notes for MonoList2 */
template < class StemItem >
class MonoArray : public stemListItem
{
public:
	listBase <stemListItem> base;

	MonoArray () : stemListItem(), base() {};
	virtual ~MonoArray ()
	{
		while ( base.tail ) delete base.tail;
	};

	int LocateLtoR ( char* str, unsigned s, unsigned n );
  /* int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

template < class StemItem >
class MonoList : public stemListItem
{
public:
	listBase <stemListItem> base;
	Separator* sep;
	int AutoSepDelete;

	MonoList ( Separator* s, int adel = 1 /* TRUE */ )
		: stemListItem (), base (), sep ( s )
	{
		AutoSepDelete = adel;
	};
	virtual ~MonoList ( void )
	{
		while ( base . tail ) delete base . tail; /* destroy items, if any */
		if ( AutoSepDelete && sep ) delete sep;
	};

	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

/* this is for non-equisubstantial list that admits items of two
	different stems, at any order

	ESSENTIAL NOTE: when parsing, first <StemItem1> is parsed,
	then, if fails, <StemItem2> is tried on, etc.

	ESSENTIAL NOTE: StemItemXXX should be,at least
		desired for further usage,
		except for MonoList<>, castable classes, that is,
	among other, they should not be nested templates.
	ESSENTIAL NOTE: they also should have virtual destructors.
*/
template < class StemItem1, class StemItem2 >
class MonoList2 : public stemListItem
{
public:
	listBase <stemListItem> base;
	Separator* sep;
	int AutoSepDelete;

	MonoList2 ( Separator* s, int adel =1 /*TRUE*/ )
		: stemListItem(), base(), sep ( s)
	{
		AutoSepDelete = adel;
	}
	virtual ~MonoList2 (void)
	{
		while ( base .tail ) delete base . tail;
		if ( AutoSepDelete && sep ) delete sep;
	}

	int LocateLtoR ( char* str, unsigned s, unsigned n);
	/* int LocateRtoL ( char* str, unsigned s, unsigned n); */
};

// Special note for class StemPair.
// You may pre-create any of LVal or RVal objects, unlike for other
// complex classes, where template type objects are created 
// ONLY WHILE LOCATING LTOR OR RTOL.
// The most common case is like that :

// class MyUnsTag: public StemPair < Keyword, Uns > 
// {
// ...
// public:
//   MyUnsTag():StemPair<Keyword,Uns>(new Separator("="))
//     {Lvalue=new Keyword("MyUnsTag");};
//  ...
// };

// this can also reduce template code generation
// (that is, you need not generate additional templates 
// such as 'template class StemPair<MyKeyword1, Uns>; 
// template class StemPair<MyKeyword2,Uns>;...'

template < class LVal, class RVal >
class StemPair : public stemListItem
{
public :
	LVal* Lvalue;
	RVal* Rvalue;
	Separator* sep;
	int AutoSepDelete;

	StemPair ( Separator* s, int adel = 1 /* TRUE */ )
		: stemListItem ()
	{
		Lvalue = NULL;
		Rvalue = NULL;
		sep  = s;
		AutoSepDelete = adel;
	};
	virtual ~StemPair ( void  )
	{
		if ( Lvalue ) delete Lvalue;
		if ( Rvalue ) delete Rvalue;
		if ( AutoSepDelete && sep ) delete sep;
	};

	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */

};

/* for "|" parse rule implementation. */
/* see note for Monolist2 above. Apply all requirements to Either and Or */
/* SPECIAL NOTE: You could use nested implementation , for ex.
	 for the followin' parse formula

		<EitherOrTrice> = <stem1> | <stem2> | <stem3>

		You could use

		class EitherOrTrice : public EitherOr < stem1, EitherOr < stem2, stem3> >

		but preferred implementation still would be (because of the reasions
			of value retreiving, 'cause EitherOr is not castable ):

		class Stem2OrStem3 : public EitherOr < stem2, stem3>
		{
		DECLARE_CASTABLE( Stem2OrStem3, stem );
		public:
			....

		};

		class EitherOrTrice : public EitherOr < stem1, Stem2OrStem3 >
		{
		...
			stemListItem* GetValue ( void )
			{
				stem1* stem1_pr = DOWNCAST_MOSTDERIVED ( value, stem1 );
				Stem2OrStem3* stem23_pr = DOWNCAST_MOSTDERIVED ( value, Stem2OrStem3)
				stem2* stem2_pr = stem23_pr ? DOWNCAST_MOSTDERIVED
					( stem23_pr -> value, stem2 );
				stem3* stem3_pr = stem23_pr ? DOWNCAST_MOSTDERIVED
					( stem23_pr -> value, stem3 );

				if ( stem1_pr ) return stem1_pr;
				else if ( stem2_pr ) return stem2_pr;
				else return stem3_pr;
			}
		};


*/

template < class Either, class Or >
class EitherOr : public stemListItem
{
public:
	stemListItem* value;
	EitherOr ( ) : value ( NULL ) { };
	virtual ~EitherOr () { if ( value ) delete value; };

	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

/****************** some useful classes that use templates above **************/
class TimeOfDay : public StemPair < UnsHour, UnsMin >
{
	DECLARE_CAST;

public :
	TimeOfDay ( void ) : StemPair < UnsHour, UnsMin > ( new Separator ( ":" ) ) { };
};

class TimeOfDayInterval :
	public StemPair < TimeOfDay, TimeOfDay >
{
	DECLARE_CAST;
public :
	TimeOfDayInterval () : StemPair <TimeOfDay, TimeOfDay>
		( new Separator ("-") ) { };
};

class TimeOfDayIntervalList : public MonoList < TimeOfDayInterval >
{
	DECLARE_CAST;
public:
	TimeOfDayIntervalList()
		:MonoList < TimeOfDayInterval > ( new Separator ( "," )) { };
};



/******************************************************************************
		template functions for complex classes
*******************************************************************************/

/* simple array of StemItems seprated by ComSep */
template <class StemItem >
int MonoArray <StemItem> ::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
	stemStream ss ( str, s, n ), curr_ss;
	StemItem* item_pr =  NULL;
	for ( curr_ss = ss; curr_ss . is_valid(); )
	{
		item_pr = new StemItem;
		curr_ss = curr_ss >> item_pr >> &ComSep();
		if ( curr_ss . is_valid () )
			base . Add ( ( stemListItem* )item_pr );
	}

	delete item_pr;

	if ( base. base == NULL ) /* no fetched */
		return -1;



	sp = s;
	np = base . tail -> np;

	return 0;
}


template < class StemItem >
int MonoList <StemItem> ::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
	stemStream ss ( str, s, n );

	StemItem* currItem = new StemItem;
	for ( ;; )
	{
		ss =ss >> currItem;
		if ( !ss . is_valid () )
		{
			/* it is not a list */
			/* destroying list */
			while ( base .tail ) delete base.tail;
			delete currItem;
			return -1;
		}
		/*stem located ok */
		/* appending it to list */
		base . Add ( (stemListItem*)currItem );

		ss = ss >> &ComSep () >> sep >> &ComSep();
		if ( ! ss . is_valid () )
			break;
		currItem = new StemItem;
	};
	sp = s;
	np = currItem -> np;

	return 0;
}

template < class StemItem1, class StemItem2 >
int MonoList2 < StemItem1, StemItem2>::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
	stemStream ss ( str, s, n), curr_ss ( str, s, n);

	stemListItem* item_pr;

	for (;; )
	{
		item_pr = new StemItem1;
		ss=ss >> item_pr;
		if ( ! ss. is_valid() )
		{
			delete item_pr;
			ss = curr_ss;
			item_pr = new StemItem2;
			ss = ss >> item_pr;
		}

		if ( ! ss.is_valid ())
		{
			delete item_pr;
			while ( base. tail ) delete base . tail;
			return -1;
		}

		/* ok, one of them found */
		base . Add ( item_pr );

		/* try out for separator */
		curr_ss = ss;
		ss =ss >> &ComSep() >> sep >> &ComSep();
		if ( !ss. is_valid() )
		{
			ss = curr_ss;
			break;
		}
		curr_ss = ss;
	}

	sp = s;
	np = item_pr -> np;

	return 0;
}


template < class LVal, class RVal >
int StemPair < LVal, RVal> ::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
	stemStream ss ( str, s, n );
	int KeepLVal=0, KeepRVal =0;
 	

	if ( Lvalue ==NULL) Lvalue = new LVal; else KeepLVal=1;
	if ( Rvalue ==NULL) Rvalue = new RVal; else KeepRVal=1;

	ss = ss >> Lvalue >> &ComSep() >> sep >> &ComSep() >> Rvalue;

	if ( ! ss . is_valid () )
	{
		if  ( KeepLVal == 0 )
		{
		  delete Lvalue; 
		  Lvalue = NULL;
		}
		if ( KeepRVal == 0 )
		{
		  Rvalue = NULL;
		  delete Rvalue;
		}
		return -1;
	}

	sp = s; np = ss . stream_sp;

	return 0;
}

template < class Either, class Or >
int EitherOr<Either,Or>::
LocateLtoR ( char* str, unsigned s, unsigned n)
{
	stemStream ss ( str, s, n );

	value = new Either;
	ss=ss >> value;
	if ( ss. is_valid() )
	{
		sp = s;
		np = ss . stream_sp;
		return 0;
	}

	delete value;
	ss = stemStream ( str, s, n );
	value = new Or;
	ss = ss >> value;
	if ( ss. is_valid () )
	{
		sp = s;
		np = ss.stream_sp;
		return 0;
	}
	delete value;
	value = NULL;
	return -1;
}

#endif /* ___PARSE_H___ */