// #pragma hdrstop

#pragma implementation "template.h"
#pragma implementation

#include "parse.h"

/*******************************************************************************************
		Common services
*****************************************************************************************/

int is_alpha ( int symbol )
{
	return ( (symbol >= 'A' && symbol <= 'Z' ) || ( symbol >= 'a' && symbol <= 'z' ) );
}

int is_digit ( int symbol )
{
	return ( symbol >= '0' && symbol <= '9' );
}

int is_alphdig ( int symbol )
{
	return ( is_alpha ( symbol ) || is_digit ( symbol ) );
}

/********************************************************************************************
	  Parse classes implementation
*********************************************************************************************/

/* template implementation ( when compiled with -f-no-implicitit-templates ) */

template class listItem < stemListItem >;// for all
template class listBase < stemListItem>; // ---;---
template class StemPair < UnsHour,UnsMin >; // for TimeOfDay
template class StemPair < TimeOfDay, TimeOfDay>; // for TimeOfDayInterval
template class MonoList < TimeOfDayInterval >; // for 


/********************************************************************************************
		Primitives
********************************************************************************************/
/* Castables */
void* TCastableBase :: FindBase ( char* cl ) { return NULL ; };
IMPLEMENT_CAST1(stem, TCastableBase);
IMPLEMENT_CAST1(Word, stem);
IMPLEMENT_CAST1(Keyword, Word );
IMPLEMENT_CAST1(Uns, stem);
IMPLEMENT_CAST1(UnsLong, stem );
IMPLEMENT_CAST1(UnsBytes, UnsLong);
IMPLEMENT_CAST1(Quotas,stem);
IMPLEMENT_CAST1(UnsHour, Uns);
IMPLEMENT_CAST1(UnsMin, Uns);
IMPLEMENT_CAST1(Separator, stem);
IMPLEMENT_CAST1(ComSep, Separator);
IMPLEMENT_CAST1(DayOfWeek,Word);
IMPLEMENT_CAST1(TimeOfDay,stem);
IMPLEMENT_CAST1(TimeOfDayInterval,stem);
IMPLEMENT_CAST1(TimeOfDayIntervalList,stem);



stemStream stemStream::
operator>> ( stem* stem_pr )
{
	/* if there was an error while previous parsing procedure return mistake */
	if ( !str ) return stemStream ( 0, 0, 0 );

	if ( -1 == stem_pr -> LocateLtoR ( str, stream_sp, stream_np ) )
		return stemStream ( 0, 0, 0 ); /* return an error if error while parsing */

	/* else construct next stemstream */

	return stemStream ( str, stem_pr -> np, stream_np );
}

stemStream stemStream::
operator<< ( stem* stem_pr )
{
	if ( !str )
	  return stemStream ( 0, 0, 0 );

	if ( -1 == stem_pr -> LocateRtoL ( str, stream_sp, stream_np ) )
	  return stemStream ( 0, 0, 0 );

	return stemStream ( str, stream_sp, stem_pr -> sp );
}

/****************** locate functions ***************************/
int ComSep :: LocateLtoR ( char* str, unsigned s, unsigned n )
{
	int comment = 0; /* true if comment mode is on */
	unsigned i;

	for ( i = s; i < n; i++ )
		if ( comment && str [ i ] == COMMENT_END_SYMBOL )
			comment = 0;
		else if ( comment ) continue;
		else if ( !comment && str [ i ] == COMMENT_START_SYMBOL )
			comment =1 ;
		else if ( !strchr ( COMSEP, str [ i ] ) ) break;

	sp = s; np =i; return 0; /* common sep always returns success even if
										it fails to locate common separator symbols */
}

int Word :: LocateLtoR ( char* str, unsigned s, unsigned n )
{
	unsigned i;

	for ( i = s; i < n; i++ )
		if ( ! is_alphdig ( str [ i ] ) ) break;

	if ( i == s ) return -1; /* not located */

	sp = s;
	np = i;

	return 0;
}

int Uns:: LocateLtoR ( char* str, unsigned s, unsigned n )
{
	unsigned i;
	char valstr [ 6 ];

	for ( i = s; i < n; i++ )
		if ( !is_digit ( str [i ] ) ) break;

	if (  i == s ) return -1; /* not located */
	if ( i -s > 5 ) return -1; /* out of range */

	sp = s;
	np = i;

	memcpy ( valstr, &str [ s ], np - sp );
	valstr [ np -sp ] = 0;

	value = atoi ( valstr );

	return 0;
}

int UnsLong:: LocateLtoR ( char* str, unsigned s, unsigned n )
{
  unsigned i;
  char valstr [25 ];
  
  for ( i = s; i < n; i++ )
    if ( !is_digit ( str [ i ] ) ) break;
  if ( i==s ) return -1;
  if ( i-s >24 ) return -1; /* string is too long */
  sp = s;
  np = i;
  memcpy ( valstr, &str [s], np-sp );
  valstr [ np-sp ] = 0;
  value = atol ( valstr );
  return 0;
  
}

int UnsBytes:: LocateLtoR ( char* str, unsigned s, unsigned n )
{
  int result = UnsLong::LocateLtoR ( str, s, n);
  if ( result ) return result;
  /* check for M or K suffixes */
  if ( np >= n ) return;
  if ( str [ np ] == 'K' )
  {
    value *= 1024;
    np++;
    return 0;
  }
  
  if ( str [np ] == 'M' )
  {
    value *= 1024*1024; // value is given in megabytes now
    np ++;
    return 0;
  }
  return 0;
}

int Quotas:: LocateLtoR ( char* str, unsigned s, unsigned n )
{
  if ( str [s] != QuotaSymbol ) return -1; // not a qouted string 
  unsigned i;
  for ( i = s+1; i < n; i++ )
    if ( str [ i ] == QuotaSymbol ) break;
  if ( i == n ) return -1;
  sp = s;
  np = i + 1;
  return 0;
}

int Separator:: LocateLtoR ( char* str, unsigned s, unsigned n )
{
	char sample [ MAXSEPLEN + 1];

	int seplen = strlen ( Sep );

	if ( n -s < seplen ) return -1;
	memcpy ( sample, &str [ s ], seplen );
	sample [ seplen ] = 0;

	if ( strcmp ( sample, Sep ) ) return -1;

	sp = s;
	np = s + seplen;

	return 0;
}

int UnsHour:: LocateLtoR ( char* str, unsigned s, unsigned n )
{
	if ( Uns:: LocateLtoR ( str, s, n ) )
		return -1;
	if ( value >24 ) return -1; /* out of range */
	return 0;
}

int UnsMin :: LocateLtoR ( char* str, unsigned s, unsigned n )
{
	if ( Uns:: LocateLtoR ( str, s, n ) )
		return -1;
	if ( value > 60 ) return -1 ; /* min out of range */
	return 0;
}

int DayOfWeek:: LocateLtoR ( char* str, unsigned s, unsigned n )
{
	char Token [ MAXDAYOFWEEKLEN +1 ];

	if ( Word:: LocateLtoR ( str, s, n ) ) return -1;

	if ( np -sp > MAXDAYOFWEEKLEN ) return -1; /* out of range */
	memcpy ( Token, &str [ sp ], np - sp );
	Token [ np-sp ] = 0; /* fix it */

	if ( !strcmp ( Token, MONDAY ) )
		value = MONDAY_VAL;
	else if ( !strcmp ( Token, TUESDAY ) )
		value = TUESDAY_VAL;
	else if ( !strcmp ( Token, WEDNESDAY ))
		value = WEDNESDAY_VAL;
	else if ( !strcmp ( Token, THURSDAY ) )
		value = THURSDAY_VAL;
	else if ( !strcmp ( Token, FRIDAY ) )
		value = FRIDAY_VAL;
	else if ( !strcmp ( Token, SATURDAY ) )
		value = SATURDAY_VAL;
	else if ( !strcmp ( Token, SUNDAY ) )
		value = SUNDAY_VAL;
	else return -1; /* not a weekday */

	return 0;
}


