/*************************************************************************
         (C) by LD 
         14 Jul 1996: Created
         3  Aug 1996: Added TtyTags and UserTags representation

**************************************************************************/

#ifndef ___MEMDATA_H___
#define ___MEMDATA_H___


#include "custom.h"
// #include "utmp.h"
#include <utmp.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#pragma interface

#define US_UNLIMITED 	(1u)         /* unlimited time qouta user mask */
#define US_ANYDAY       (1u<< 1)     /* anyday login allowed */
#define US_SU 		(1u<< 2)     /* if superuser tag given */
//#define US_ANYTTY	(1u<< 3)     /* if any terminal is allowed */
#define US_SOFT_TIME_EXPIRED (1u << 4 ) /* if soft time limit is reached */
#define US_HARD_TIME_EXPIRED (1u << 5) /* if hard time limit is reached */
#define US_SOFT_TRAFFIC_EXPIRED (1u<<6)
#define US_HARD_TRAFFIC_EXPIRED (1u<<7)
#define US_NOTVALID_INTERVAL  (1u<<8) /* not a valid time of day for the user */

// These are some additional codes being sent in LoginResponse by admind 
// (see handshakes.h)

// tty is not valid for user 
#define US_NOTVALID_TTY ( 1u<<9 )
// user is unknown to admind (is sent only if tty requested is subjected to 
// draconian rules as stated in configuration file 
#define US_UNKNOWN (1u<< 10)

#define SOFT_TIME_KOEFF 0.90f        /* multiplier for calculating soft limit value */
#define SOFT_TRAFFIC_KOEFF 0.90f

#define DAY_ANYTIME 1u
#define DAY_UNLIMITED (1u <<1 )
#define DAY_ANYTTY ( 1u <<2 )
#define DAY_TRAFFIC_UNLIMITED ( 1u <<3 )

#define TTY_ISLOGGED 	(1u)		/* if currently logged in */

// this is for tag_st
#define MAXTAGNAMELEN UT_NAMESIZE 
#define MAXTAGVALUELEN 40

struct User_st;
struct Day_st;

struct Tty_st : public listItem < Tty_st >
{
	 Day_st* 	day_pr; // feedback to Day_st user header
	 char 		Line [ UT_LINESIZE+1 ]; // "/dev/..." tty name
	 time_t		LoginTime;
	 pid_t 		pid; // pid of root process if logged from wtmp or utmp
	 unsigned 		TtyProps; // properties for the tty

	 Tty_st ( char* name)
	 {
			strncpy ( Line, name, UT_LINESIZE + 1);
			Line [ UT_LINESIZE ] = 0;

			day_pr = NULL;
			LoginTime=0;
			pid =0 ;
			TtyProps = 0;
		};
};

struct Interval_st : public listItem < Interval_st >
{
	Day_st* day_pr; // feedback to Day_st
	time_t start, end; // in time-of-day system ( from the start of the current day )

	Interval_st ( ) { day_pr = NULL; };
  Interval_st ( time_t st, time_t en ) { day_pr = NULL; start = st; end = en; };
};

struct Day_st : public listItem < Day_st >
{
	int 			Day; // day tag
	time_t 		DayLimit; // daily limit for that day
	unsigned  HourLimit; // hour part of daily limit
        unsigned  MinLimit ; // minute part of daily limit 
  	unsigned long TrafficLimit;
	listBase<Tty_st>	TtyBase;
	listBase<Interval_st> IntervalBase;
	User_st*		user_pr; // feedback for user_st
	unsigned 		DayProps;

	Day_st ( int daytag ) : listItem < Day_st >(), TtyBase (),IntervalBase()
	{
		Day = daytag;
		user_pr = NULL;
		DayProps = 0;
		DayLimit = 0;
		TrafficLimit = 0;
	};
	~Day_st ( void ) 
	{ 
	  while (TtyBase . tail) delete TtyBase . tail ; 
	  while (IntervalBase . tail ) delete IntervalBase .tail;
	};

	Tty_st* FindTty ( char* ttyname );
	Tty_st*	AddTty ( char* ttyname );

  Interval_st* AddInterval ( time_t st, time_t end );

};

struct User_st : public listItem < User_st >
{
	char 			UserName [ UT_NAMESIZE +1 ];
	char* 			UserTag; // user's definition from /etc/passwd
	listBase<Day_st>	DayBase;
	time_t 		LeftToday; // the time that is left for today
	unsigned 		UserProps; // byte for US_XXX properties

	User_st ( char* usr_name) : listItem < User_st >(), DayBase ()
	{
		strncpy ( UserName, usr_name, UT_NAMESIZE );
		UserName [ UT_NAMESIZE ] = 0;
		time_t LeftToday = 0;
		UserProps = 0;
		UserTag = NULL;
	};
	~User_st () 
	{ 
	  while (DayBase . tail) delete DayBase. tail; 
	  if ( UserTag ) delete UserTag; // free mem allocated for UT if any
	};

	Day_st* FindDay ( int daytag );
	Day_st* AddDay ( int daytag );

};

/*******************************************************************
  this is for 'draconian rules' ( added  15 aug )
********************************************************************/
struct DraconianTty : public listItem < DraconianTty >
{
  char Line [ UT_LINESIZE + 1 ];
  DraconianTty ( char* line ) 
  { 
    strncpy ( Line, line, UT_LINESIZE );
    Line [ UT_LINESIZE ] = 0; 
  };
};

/*********************************************************************
     this is for QueryAllow (added 16 aug )
**********************************************************************/
struct QueryAllowAddr : public listItem < QueryAllowAddr >
{
  unsigned long addr;
  QueryAllowAddr ( unsigned long adr ) { addr =adr; };
}     ;
/*******************************************************************
        Root of all configuration 
********************************************************************/        
class RootBase : public listBaseAutoDel < User_st>
{
public :
        listBaseAutoDel < DraconianTty > DraconianBase;
        listBaseAutoDel < QueryAllowAddr > AllowBase;
        
	User_st* FindUser ( char* name);
	User_st* AddUser ( char* name );
	
	DraconianTty* FindDraconianTty ( char* line );
	DraconianTty* AddDraconianTty ( char* line );
	
	QueryAllowAddr* FindAllow ( unsigned long addr );
	QueryAllowAddr* AddAllow  ( unsigned long addr );
	

	int SendToStream ( FILE*  stream );
	int ReadFromStream ( FILE* stream );
};


/*******************************************************************
    3 Aug 1996: Added UserTags and TtyTags representation structures
      (By LD)
********************************************************************/

struct Tag_st : public listItem < Tag_st >
{
  char name [ MAXTAGNAMELEN + 1 ];
  char value [ MAXTAGVALUELEN + 1 ];
}  ;

struct TagBase : public listBaseAutoDel < Tag_st >
{
  int SendToStream ( FILE* file );
  int ReadFromStream ( FILE* file );
  Tag_st* FindTag ( char* name ) 
  {
    Tag_st* tag_pr;
    for ( tag_pr = base; tag_pr; tag_pr = tag_pr -> next )
      if ( !strcmp ( name, tag_pr -> name ) ) return tag_pr;
    return NULL;
  }
    
};


/*******************************************************************
********************************************************************/

/*******************************************************************
********************************************************************/


/*******************************************************************
********************************************************************/

/*******************************************************************
********************************************************************/

/*******************************************************************
********************************************************************/


/*******************************************************************
********************************************************************/

/*******************************************************************
********************************************************************/

/*******************************************************************
********************************************************************/

#endif /* ___MEMDATA_H___ */