/***************************************************************************
    memdata.cpp
    14 Jul 1996 Created by LD
    3  Aug 1996 Added TagBase::SendToStream, TagBase::ReadFromStream
****************************************************************************/

#include <utmp.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#pragma implementation
#include "memdata.h"


// template implementations :

template class listItem <Tty_st>;
template class listBase <Tty_st>;

template class listItem <Interval_st>;
template class listBase < Interval_st>;

template class listItem <Day_st>;
template class listBase <Day_st>;
template class listItem < User_st>;
template class listBase <User_st>;
template class listBaseAutoDel <User_st>;

template class listItem <Tag_st >;
template class listBase <Tag_st >;
template class listBaseAutoDel <Tag_st>;

template class listItem <DraconianTty>;
template class listBase <DraconianTty>;
template class listBaseAutoDel <DraconianTty>;

template class listItem <QueryAllowAddr>;
template class listBase <QueryAllowAddr>;
template class listBaseAutoDel <QueryAllowAddr>;

// ----------------------- Day_st

Tty_st* Day_st :: 
FindTty  ( char* ttyname )
{
  Tty_st* tty_pr;
	for ( tty_pr = TtyBase . base;
    tty_pr !=NULL; 
    tty_pr = tty_pr -> next )
  
    if ( !strcmp ( tty_pr ->  Line, ttyname ) ) 
      break;

  return tty_pr;
}

// WARNING! in this function i'm trying to apply purely gcc extensions!
// and in some adduced below too :)
Tty_st* Day_st ::
AddTty  ( char* ttyname ) return tty_pr
{
	/* Tty_st* */ tty_pr = new Tty_st ( ttyname );
	TtyBase . Add ( tty_pr );
	tty_pr -> day_pr = this;
}

Interval_st* Day_st ::
AddInterval ( time_t st, time_t end ) return interval_pr
{
	/* Interval_st* */ interval_pr = new Interval_st ( st, end );
	IntervalBase . Add ( interval_pr );
	interval_pr -> day_pr = this;
	return interval_pr;
}





// ---------------------------- User_st
Day_st* User_st ::
FindDay ( int daytag )
{
	Day_st* day_pr;

	for ( day_pr = DayBase . base ; day_pr != NULL; day_pr = day_pr -> next )
		if ( day_pr -> Day == daytag ) break;

	return day_pr;
}
Day_st* User_st ::
AddDay ( int daytag )
{
	Day_st* day_pr = new Day_st ( daytag );
	DayBase . Add ( day_pr );
	day_pr -> user_pr = this;
  return day_pr;
}


User_st* RootBase ::
FindUser ( char* name )
{
	User_st* user_pr;
	for ( user_pr = base; user_pr; user_pr = user_pr -> next )
		if ( !strcmp( name, user_pr -> UserName ) ) break;

	return user_pr ;
}

User_st* RootBase ::
AddUser ( char* name )
{
	User_st* user_pr = new User_st ( name ) ;
	Add ( user_pr );
	return user_pr;
}

/*********************
  this was added 15 aug -- for draconian ttys implementation
**********************/

DraconianTty* RootBase::
FindDraconianTty ( char* line )
{
   DraconianTty* dt_pr;
   for ( dt_pr = DraconianBase . base;
     dt_pr;
     dt_pr = dt_pr -> next 
   )
     if ( ! strcmp ( line, dt_pr -> Line )) break;
   return dt_pr;
}
DraconianTty* RootBase ::
  AddDraconianTty ( char* line )
{
  DraconianTty* dt_pr = new DraconianTty( line );
  DraconianBase . Add ( dt_pr );
  return dt_pr;
}

QueryAllowAddr* RootBase:: FindAllow ( unsigned long adr )
{
  QueryAllowAddr* qaa_pr;
  for ( qaa_pr = AllowBase . base; qaa_pr; qaa_pr = qaa_pr -> next )
    if  ( qaa_pr -> addr == adr ) break;
  return qaa_pr;
}
QueryAllowAddr* RootBase:: AddAllow ( unsigned long adr )
{
  QueryAllowAddr* qaa_pr = new QueryAllowAddr ( adr );
  AllowBase . Add ( qaa_pr );
  return qaa_pr;
}
  

/**********************************************************************
           1.08.96 Added stream i/o capability 
                       by LD 
           3 aug 96 added UserTag streaming
**********************************************************************/

int RootBase :: SendToStream ( FILE* file )
{
  User_st * usr_pr;
  DraconianTty* dt_pr;
  QueryAllowAddr* qaa_pr;
  unsigned size;

  // draconiana continues:)
  
  size = DraconianBase .Size();
  if ( 1 != fwrite ( (void* )&size, sizeof ( size ), 1, file ))
    return -1;
  
  for ( dt_pr = DraconianBase . base;
    dt_pr;
    dt_pr = dt_pr -> next
  )
    if ( 1 != fwrite ( (void* ) dt_pr -> Line, 
      UT_LINESIZE +1, 1, file ))
      return -1;
  
  size = AllowBase .Size();
  if ( 1!= fwrite ( (void*)&size, sizeof ( size ), 1, file ))
    return -1;
  for ( qaa_pr = AllowBase .base;
    qaa_pr;
    qaa_pr = qaa_pr -> next 
  )
    if ( 1 != fwrite ((void* )& qaa_pr -> addr,
      sizeof ( qaa_pr -> addr ), 1, file ))
      return -1;

  size = Size ( );
  if ( 1 != fwrite ( (void* ) &size, sizeof ( size ), 1, file ) )
    return -1;
  
  for ( usr_pr = base;
    usr_pr ;
    usr_pr = usr_pr -> next
  )
  {
    // writing User_st item
    // 1. writing UserName 
    if ( 1 != fwrite ( (void* ) usr_pr ->UserName, UT_NAMESIZE+1, 1, file ) )
      return -1;
    
    // sending UserTag:
    if ( usr_pr -> UserTag )
    {
      size = strlen ( usr_pr-> UserTag );
      if ( 1 != fwrite ( ( void* ) &size, sizeof ( size ), 1, file ) ||
        1!= fwrite ( ( void* ) usr_pr-> UserTag, size, 1, file ))
        return -1;
    } else {
      size = 0;
      if ( 1 != fwrite ( (void* ) &size, sizeof ( size ), 1, file ) )
        return -1;
    }
    
    // 2. writing LeftToday 
    if ( 1 != fwrite ( ( void* ) &usr_pr ->LeftToday, 
      sizeof ( usr_pr -> LeftToday),1, file ))
      return -1;
    // 3. writing UserProps 
    if ( 1 != fwrite ( ( void* ) &usr_pr ->UserProps, 
      sizeof ( usr_pr -> UserProps ), 1, file ))
      return -1;
      
    // 4. writing Day_st items 
    // 4.1 writing the number or days 
    size = usr_pr -> DayBase . Size();
    if ( 1 != fwrite ( (void* ) &size, sizeof ( size ), 1, file )) 
      return -1;
      
    Day_st* day_pr ;
    for ( day_pr = usr_pr -> DayBase . base; 
      day_pr;
      day_pr = day_pr -> next 
    )
    {
      // 4.2.1 writing day tag
      if ( 1 != fwrite ( (void* ) & day_pr -> Day, 
        sizeof ( day_pr -> Day ), 1, file ))
        return -1;
        
      // 2.2.2. writing DayLimit
      if ( 1 != fwrite ( ( void* ) &day_pr -> DayLimit,
        sizeof ( day_pr -> DayLimit ), 1, file ))
        return -1;

#ifdef NACCTD_SUPPORT
      // 2.2.2.1. writing TrafficLimit
      if ( 1 != fwrite ( (void*) &day_pr -> TrafficLimit,
        sizeof ( day_pr -> DayLimit ),1 , file ))
        return -1;

#ifndef NO_DEBUG
      Log2 (4, "RootBase::SendToStream: send traffic limit %lu\n",
        day_pr -> TrafficLimit );
#endif        
#endif
        
      // 2. 2. 3. writing HourLimit
      if ( 1 != fwrite ( (void* )&day_pr -> HourLimit,
        sizeof ( day_pr -> HourLimit ), 1, file ))
        return -1;
        
      // 2.2.4. writing MinLimit
      if ( 1 != fwrite ( (void* ) &day_pr -> MinLimit,
        sizeof ( day_pr -> MinLimit ), 1, file ))
        return -1;
        
      // 2.2.5. writing DayProps
      if ( 1 != fwrite ( (void* ) &day_pr -> DayProps,
        sizeof ( day_pr -> DayProps ), 1, file ))
        return -1;
        
      // writing intervals 
      size = day_pr -> IntervalBase  . Size ();
      if ( 1 != fwrite ( (void* ) &size, sizeof ( size ), 1, file ))
        return -1;
        
      Interval_st* Interval_pr;
      for ( Interval_pr = day_pr -> IntervalBase . base;
        Interval_pr;
        Interval_pr = Interval_pr -> next 
      )
      {
        // writing start, end
        if ( 1 != fwrite ( (void* ) &Interval_pr -> start,
          sizeof ( Interval_pr -> start ), 1, file ))
        return -1;
        if ( 1 != fwrite ( (void* ) &Interval_pr -> end,
          sizeof ( Interval_pr -> end ), 1, file ))
        return -1;
      }
      
      size = day_pr -> TtyBase . Size ();
      
      if ( 1 != fwrite ( (void* ) &size, sizeof ( size ), 1, file ))
        return -1;
      
      Tty_st* tty_pr;
      for ( tty_pr = day_pr -> TtyBase .base;
        tty_pr;
        tty_pr = tty_pr -> next
      )
      {
        // writing tty name
        if ( 1 != fwrite ( (void* ) tty_pr -> Line, UT_LINESIZE +1,
          1, file ) )
          return -1;
        // writing LoginTime
        if ( 1 != fwrite ( (void* ) &tty_pr -> LoginTime, 
          sizeof ( tty_pr -> LoginTime ), 1, file ))
          return -1;
        // writing pid 
        if ( 1 != fwrite ( (void*) &tty_pr -> pid, 
          sizeof ( tty_pr -> pid ), 1,file ) )
          return -1;
        // writing TtyProps
        if ( 1 != fwrite ( (void* )& tty_pr -> TtyProps,
          sizeof ( tty_pr -> TtyProps ), 1, file ))
          return -1;
      }
    }
    
  }
  return 0;    
}

int RootBase :: ReadFromStream ( FILE* file )
{
  // 0.0 first clear the object 
  while ( tail ) delete tail ;
  while ( DraconianBase . tail ) delete DraconianBase . tail;
  while ( AllowBase . tail ) delete AllowBase . tail;

  User_st* usr_pr;
  unsigned size, i;

  // draconiana
  if ( 1 != fread ((void* ) &size, sizeof ( size ),1, file ))
    return -1;

#ifndef NO_DEBUG
  Log2 ( 4, "RootBase::ReadFromStream(): total draconians %u\n", size );
#endif  
    
  for ( i = 0; i< size ; i++ )
  {
    char tmp [ UT_LINESIZE + 1 ];
    
    if ( 1 != fread ( (void* ) tmp, UT_LINESIZE + 1, 1, file ))
      return -1;
    AddDraconianTty ( tmp );
#ifndef NO_DEBUG
    Log2 ( 4, "RootBase :: ReadFromStream(): read draconian tty %s\n",
      tmp );    
#endif      
  }
  
  // QueryAllow
  if ( 1 != fread ((void* ) &size, sizeof ( size ),1, file ))
    return -1;
#ifndef NO_DEBUG
  Log2 ( 3, "RootBase::ReadFromStream():total Allows %u\n", size );
#endif
  for (i=0; i < size; i++ )
  {
    struct in_addr addr;
    
    if ( 1 != fread ( (void*) &addr.s_addr, sizeof ( addr.s_addr ),1,file))
      return -1;
    AddAllow ( addr . s_addr );
#ifndef NO_DEBUG 
    Log2 ( 3,"RootBase::ReadFromStream(): read QueryAllow %s\n",
      inet_ntoa ( addr) ); 
#endif
  }
      
  
  // 1. reading the number of User_st items
  if ( 1!= fread ( (void* ) &size, sizeof ( size ), 1, file ) ) 
    return -1;

#ifndef NO_DEBUG
  sprintf ( LogBuff, "RootBase::ReadFromStream: got %d users\n", size );
  Log ( 4 );
#endif

  for ( i = 0; i < size; i++ ) 
  {

#ifndef NO_DEBUG
    sprintf ( LogBuff, "RootBase::ReadFromStream: starting to read user %d\n",
      i );
    Log ( 4 );
#endif

    char u_name [ UT_NAMESIZE + 1 ];
    // reading UserName
    if ( 1 != fread ( (void*) u_name, UT_NAMESIZE + 1, 1,file ) )
      return -1;
    usr_pr = AddUser ( u_name );
    
    // reading UserTag
    {
      unsigned tagsize;
      if ( 1 != fread ( (void* ) &tagsize, sizeof ( tagsize ), 1, file ))
        return -1;
      if ( tagsize )
      { 
        usr_pr -> UserTag = new char [ tagsize + 1 ];
        if ( 1 != fread ( (void* ) usr_pr -> UserTag, tagsize, 1, file ))
          return -1;
        usr_pr -> UserTag [ tagsize ] = 0;
      }
        
    }
    
    // reading LeftToday
    if ( 1 != fread ( ( void* ) &usr_pr -> LeftToday,
      sizeof ( usr_pr -> LeftToday), 1, file ))
      return -1;
    // reading UserProps
    if ( 1 != fread ( (void* )&usr_pr -> UserProps,
      sizeof ( usr_pr -> UserProps ), 1, file ))
      return -1;
    // reading Day_st items 
    unsigned day_no, k;
    Day_st* day_pr;
    if ( 1 != fread ( ( void* ) &day_no, sizeof ( day_no ),1 ,
      file ))
      return -1;
    for ( k = 0; k < day_no; k++ )
    {
      // reading Day Tag 
      int day_tag;
      if ( 1 != fread ( (void* ) &day_tag, sizeof ( day_tag ), 1,
        file ))
        return -1;
      day_pr = usr_pr -> AddDay ( day_tag );
      
      // DayLimit
      if ( 1 != fread ( (void* ) & day_pr -> DayLimit, 
        sizeof ( day_pr -> DayLimit), 1, file ))
        return -1;
#ifdef NACCTD_SUPPORT
      // TrafficLimit
      if ( 1 != fread ( (void* ) &day_pr -> TrafficLimit,
        sizeof ( day_pr -> TrafficLimit ),1 , file ))
        return -1;
#endif
#ifndef NO_DEBUG
      Log2 ( 4, "RootBase::ReadFromStream: read TrafficLimit %lu\n",
        day_pr -> TrafficLimit );
#endif                
        
      // HourLimit 
      if ( 1 != fread ( (void* ) & day_pr -> HourLimit, 
        sizeof ( day_pr -> HourLimit ), 1, file ))
        return -1;
      
      // MinLimit
      if ( 1 != fread ( ( void* ) & day_pr -> MinLimit,
        sizeof ( day_pr -> DayLimit ), 1, file ))
        return -1;
        
      // dayProps
      if ( 1 != fread ( (void* ) &day_pr -> DayProps,
        sizeof ( day_pr -> DayProps ), 1, file ))
        return -1;
        
      // reading intervals;
      unsigned int_no,l;
      Interval_st* Interval_pr;
      
      if ( 1 != fread ( (void* )& int_no, sizeof ( int_no ), 1, file ))
        return -1;
        
      for ( l = 0; l < int_no; l++ )
      {
        // reading start, end
        
        time_t _start, _end;
        if ( 1 != fread ( (void* )& _start, sizeof ( _start) ,1 ,file))
          return -1;
        if ( 1 != fread ( ( void* ) &_end, sizeof ( _end ), 1, file ))
          return -1;
        
        Interval_pr = day_pr -> AddInterval ( _start, _end );
      }
      
      // Tty items 
      unsigned tty_no;
      Tty_st* tty_pr;
      
      if ( 1 != fread ( (void* ) &tty_no, sizeof ( tty_no ), 1, file ))
        return -1;
        
      for ( l = 0; l < tty_no ; l++ )
      {
        // reading ttyname
        char tty_name [ UT_LINESIZE + 1];
        if ( 1!= fread ( (void* ) tty_name, UT_LINESIZE + 1, 1, file ))
          return -1;
        tty_pr = day_pr -> AddTty ( tty_name );
        // reading LoginTime
        if ( 1!= fread ( (void* ) &tty_pr -> LoginTime,
          sizeof ( tty_pr -> LoginTime ), 1, file ))
          return -1;
        // reading pid
        if ( 1!= fread ((void* )&tty_pr -> pid, 
          sizeof ( tty_pr -> pid ), 1, file ))
          return -1;
        // ttyProps
        if ( 1 != fread ( (void* ) &tty_pr -> TtyProps, 
          sizeof ( tty_pr -> TtyProps ), 1, file ))
          return -1;
      }
    }  
      
  }  
      
  return 0;
}   
    
    

/**********************************************************************
       TagBase implementation, added by LD 3 Aug 1996
**********************************************************************/
int TagBase:: 
SendToStream ( FILE* file )
{
  unsigned size = Size();
  // sending size 
  if ( 1 != fwrite ( (void*) &size, sizeof ( size ), 1, file ))
    return -1;
  
  Tag_st* tag_pr;
  for ( tag_pr = base;
    tag_pr;
    tag_pr = tag_pr ->next 
  )
  {
    if ( 1 != fwrite ( (void*) tag_pr -> name,
      sizeof ( tag_pr -> name ), 1, file ) ||
      1 != fwrite ( (void* ) tag_pr -> value,
      sizeof ( tag_pr -> value ), 1, file ) )
      return -1;
  }
  return 0;
}

int TagBase::
ReadFromStream ( FILE* file )
{
  unsigned size;
  Tag_st* tag_pr;
  
  // cleaning the current tag storage
  while ( tail ) delete tail;
  
  // reading size 
  if ( 1 != fread ( (void*) &size, sizeof ( size ),1 , file ))
    return -1;
  unsigned i;
  for ( i =0; i < size; i++ )
  {
    tag_pr = new Tag_st;
    Add ( tag_pr );
    
    if ( 1 != fread ( (void* ) tag_pr -> name, 
      sizeof ( tag_pr -> name ), 1, file ) ||
      1 != fread ( (void* ) tag_pr -> value,
      sizeof ( tag_pr -> value ), 1,file ))
      return -1;
  }
  return 0;
}
      
    


/**********************************************************************
**********************************************************************/

/**********************************************************************
**********************************************************************/


/**********************************************************************
**********************************************************************/

/**********************************************************************
**********************************************************************/

/**********************************************************************
**********************************************************************/

/**********************************************************************
**********************************************************************/

/**********************************************************************
**********************************************************************/

/**********************************************************************
**********************************************************************/
