/*************************************************************************
     Some supplementary Handshakes here
     Created on 1st Aug 96 by LD 
**************************************************************************/

#ifndef ___HANDSHAKE_H___
#define ___HANDSHAKE_H___
#include <time.h>
#include <utmp.h>
#pragma interface


/*************************************************************************
          General Handshake parse 
**************************************************************************/

struct Handshake_st
{
  char ModuleSig [ 2 ]; // module signature
  unsigned version;       // module version, for ex . 0x0010 stands for 0.1
};


/*************************************************************************
    Module signatures definitions
**************************************************************************/

#define APARSER_SIG "PR"
#define ADMIND_SIG "AD"
#define AWREADER_SIG "WR"
#define CGI_SIG "CG"
#define LOGIN_SIG "LG"

/*************************************************************************
        current package version
**************************************************************************/

#define VERSION (0x0010) /*0.1*/


/*************************************************************************
    AWReader request
**************************************************************************/
// ---------------- communicating with AWReader --------------
#define OC_STAT 1 /* just collecting statistic for period mentioned */
#define OC_TODAY 2 /* collecting for today */

// the following operation codes are for cgi utilities
#define OC_USER_ROOT 3 /* request for UserRoot confs */
// #define OC_CONF_CHANGE 4 /* high - priveleged request for change UserRoot confs */
// #define OC_LOGIN_REQUEST 5 /* check whether login is allowed for the user */

struct AWReaderRequest
{
   int OpCode; // OC defines
   time_t Start, End; // start and end moment for OC_STAT
   int SendOverall; // send WtmpOverall too ( if == 1 )
};
         
         
/*************************************************************************
                      this  is for communicatin with 
                      login checker 
**************************************************************************/
// May I (UserName ) log in on the Line now?
struct LoginRequest 
{
  char UserName [ UT_NAMESIZE + 1 ];
  char Line [ UT_LINESIZE + 1 ];
}  ;
struct LoginResponse // admind repsonses with it
{
  unsigned 	UserProps; // Properties for user as defined in memdata.h
};

/*************************************************************************

**************************************************************************/

#endif /* ___HANDSHAKE_H___ */