#ifndef ___CUSTOM_H___
#define ___CUSTOM_H___


#include "parse.h"
#include "common.h"
#include <utmp.h>

#pragma interface

#define MAXLOGINLEN 32
#define USERSTIMETABLEKEY "UsersTimeTable"
#define TTY_TAG_KEYWORD "TtyTags"
#define PORT_KEYWORD "Port"
#define MAX_CHILDREN "MaxChildren"
#define CHECKGRAN "CheckGran"
#define REREADGRAN "RereadGran"
#define DRACONIAN_KEYWORD "DraconianTtys"

#define MAXTAGNAMELEN UT_NAMESIZE
#define MAXTAGVALUELEN 40

/****************************************************************************
				Other application-cpecific definitions
****************************************************************************/

/*
	the following classes realise the next formula:

	<DaysList> = <DayOfWeekInterval> | <DayOfWeek>
		[, <DayOfWeekInterval> | <DayOfWeek> ...]

	( it demonstrate the usage for StemPair, and esp. for  MonoList2 )
*/

class DayOfWeekInterval :
	public StemPair < DayOfWeek, DayOfWeek >
{
	DECLARE_CAST; /* -- skipping StemPair
																 and stemListItem */
public :
	DayOfWeekInterval ( void )
		: StemPair <DayOfWeek,DayOfWeek>( new Separator ("-") )
	{};
	int LocateLtoR ( char* str, unsigned s, unsigned n);
/*	int LocateRtoL  ( char* str, unsigned s, unsigned n); */

};

class DaysList :
	public MonoList2 < DayOfWeekInterval, DayOfWeek >
{
	DECLARE_CAST;
public:
	DaysList ( void )
		: MonoList2<DayOfWeekInterval,DayOfWeek> ( new Separator ("," ) ) {};

/* we also may need something like that for post-parsing stage */

	/* returns day value [MONDAY_VAL..SUNDAY_VAL] configured
		or -1 when the end is reached */
private:
	stemListItem* sli_pr; /* currently processed item for GetNextDay iterator */
	int CurrDay;          /* ---'--- value of day while interval iterating */
public:
	int GetFirstDay();
	int GetNextDay();
};

/*************************************************************************
	The following all implements users timetable

	the following syntax formula in timtable is expected:

	<UsersTimeTable> =
		<UserNameList> <DaysList> ( <TimeOfDayIntervalList> | <AnyStem> )
		<DayLimit> <TtyAllowedList> [ <SuperUserStem> ]

	where:

	<UserNameList> = <*> | (<UserName> [,<UserName> ...])
	(<*> stands for: copy users list from previous record, if any)

	<DayList> = see above, already implemented

	<TimeOfDayIntervalList> = <TimeOfDay> <-> <TimeOfDay>
		[, <TimeOfDay> <-> <TimeOfDay> ... ]
	already implemented in parse.h as a standart stem

	<DayLimit>=<TimeOfDay> | <UnlimitedStem> --- also implemented in parse.h

	<AllowedTtyList> = <AnyStem> | ( <tty> [ ,<tty> ] )

	Note that as separator is used ComSep!

******************************************************************************/
class UserName : public Word
{
	DECLARE_CAST;

public :

	char value [ MAXLOGINLEN + 1 ];

	int LocateLtoR ( char* str, unsigned s, unsigned n )
	{
		if ( Word:: LocateLtoR ( str, s, n) )
			return -1;
		if ( np - sp > MAXLOGINLEN ) return -1;
		memcpy ( value, &str[ sp ], np - sp );
		value [ np - sp ] = 0;
		return 0;
	};
};

class UserNameList : public MonoList < UserName >
{
	DECLARE_CAST;
public:

	UserNameList() : MonoList < UserName>(new Separator(",")) { };
};

class TtyList : public MonoList < Word >
{
	DECLARE_CAST;
public :

	TtyList () : MonoList < Word > ( new Separator ( ",")) { };
};

class Star : public Separator
{
	DECLARE_CAST;
public:
	Star() : Separator ( "*" ) { };
};

class AnyStem : public Keyword
{
	DECLARE_CAST;
public :
	AnyStem() : Keyword ( "ANY" ) { };
};

class UnlStem : public Keyword
{
	DECLARE_CAST;
public:
	UnlStem() : Keyword ( "UNLIMITED" ) { };
};

/* ------------- fields ------------------------*/
class UserField : public EitherOr < Star, UserNameList >
{
	DECLARE_CAST;
};


class DaysField : public EitherOr < AnyStem, DaysList >
{
	DECLARE_CAST;
};

class IntervalsField: public EitherOr < AnyStem, TimeOfDayIntervalList >
{
	DECLARE_CAST;
};

class DailyLimitField : public EitherOr < UnlStem, TimeOfDay >
{
	DECLARE_CAST;
};

class TrafficLimitField:public EitherOr < UnlStem, UnsBytes >
{
  DECLARE_CAST;
};

/* --- if anybody has an idea how to validate possible ttys, insert here */
class TtyListField : public EitherOr < AnyStem, TtyList >
{
	DECLARE_CAST;
};

class SuField : public Keyword
{
	DECLARE_CAST;
public:
	SuField() : Keyword ( "SU" ){};
};

/****************************************************************************

			 UsersTimeTableItem generic class !
*****************************************************************************/

class UsersTimeTableItem : public stemListItem
{
	DECLARE_CAST;
public :

	UserField* uf_pr;
	DaysField* df_pr;
	IntervalsField* if_pr;
	DailyLimitField* dlf_pr;
	TrafficLimitField* tl_pr;
	TtyListField* tlf_pr;
	SuField* sf_pr;

	int LocateLtoR ( char* str, unsigned s, unsigned n);
/* int LocateRtoL ( char*  str, unsigned s, unsigned n ); */

	UsersTimeTableItem () :
		uf_pr ( NULL ),
		df_pr ( NULL ),
		if_pr ( NULL ),
		dlf_pr ( NULL ),
		tl_pr ( NULL ),
		tlf_pr ( NULL ),
		sf_pr ( NULL )
	{};

	virtual ~UsersTimeTableItem ()
	{
		if ( uf_pr ) delete uf_pr;
		if ( df_pr ) delete df_pr;
		if ( if_pr ) delete if_pr;
		if ( dlf_pr ) delete dlf_pr;
		if ( tl_pr ) delete tl_pr;
		if ( tlf_pr ) delete tlf_pr;
		if ( sf_pr ) delete sf_pr ;
	};

};

class UsersTimeTableBody : public MonoArray < UsersTimeTableItem >
{
	DECLARE_CAST;
public :

};

class UsersTimeTable : public stemListItem
{
	DECLARE_CAST;
public:

	UsersTimeTableBody* body;

	UsersTimeTable () : body ( NULL ) { };
	virtual ~UsersTimeTable() { if ( body ) delete body; };

	int LocateLtoR ( char* str, unsigned s, unsigned n );
/*	int LocateRtoL ( char* str, unsigned s, unsigned n ); */
};

class UsersTimeTableKeyword : public Keyword
{
	DECLARE_CAST;

public :

	UsersTimeTableKeyword () : Keyword ( USERSTIMETABLEKEY ){};
};

/*****************************************************************************/

class UsersTimeTablePair : public StemPair < UsersTimeTableKeyword, UsersTimeTable>
{
	DECLARE_CAST;
public :

	UsersTimeTablePair () : StemPair < UsersTimeTableKeyword, UsersTimeTable>
		( new Separator ( "=" ) ) { };
};

/****************************************************************************
       Tag structures in conf implementation
       Added by LD 3 aug 96
*****************************************************************************/       

class TagItem : public StemPair <Word,Quotas>
{
  DECLARE_CAST;
public:
  char name [ MAXTAGNAMELEN + 1 ];
  char value [ MAXTAGVALUELEN + 1 ];
 
  TagItem (void ) : StemPair <Word,Quotas> ( new Separator ("=" )) { };
  
  int LocateLtoR (char* str, unsigned s, unsigned n);
};

class TagBody : public MonoArray <TagItem>
{
  DECLARE_CAST;
public:
  int LocateLtoR (char* str, unsigned s, unsigned n );
};  

class TtyTagKeyword : public Keyword 
{
  DECLARE_CAST;
public:
  TtyTagKeyword () : Keyword ( TTY_TAG_KEYWORD ) { };
};

class TtyTags : public StemPair < TtyTagKeyword, TagBody >
{
  DECLARE_CAST;
public: 
  TtyTags () : StemPair < TtyTagKeyword, TagBody>( new Separator ("=")) { };
};

/**********************************************************************
              Finetuning Parameters
***********************************************************************/

class PortParam: public StemPair < Keyword, Uns > 
{ 
public:
  PortParam() : StemPair < Keyword,Uns> ( new Separator("=" )) 
  { Lvalue =new Keyword(PORT_KEYWORD);  };
};

class CheckGranParam: public StemPair <Keyword, Uns>
{
public:
  CheckGranParam():StemPair <Keyword,Uns> ( new Separator ("="))
  { Lvalue=new Keyword( CHECKGRAN ); };
};

class RereadGranParam: public StemPair <Keyword, Uns>
{
public:
  RereadGranParam():StemPair <Keyword,Uns> ( new Separator ("=" ))
  { Lvalue= new Keyword ( REREADGRAN);};
};

class MaxChildrenParam : public StemPair <Keyword, Uns>
{
public:
  MaxChildrenParam():StemPair < Keyword,Uns> ( new Separator ("="))
  { Lvalue = new Keyword ( MAX_CHILDREN );};
};

/******************************************************************
            this is for draconian ttys 
********************************************************************/

class DraconianTtyParam : public stemListItem
{
public:
  Keyword* key;
  TtyList* ttylist;
  
  DraconianTtyParam ( void ) : ttylist ( NULL )
  {
    key = new Keyword ( DRACONIAN_KEYWORD );
  };
  ~DraconianTtyParam  (void ) 
  {
    delete key;
    if ( ttylist ) delete ttylist ;
  };
  
  int LocateLtoR ( char* str, unsigned s, unsigned n )
  {
    stemStream ss ( str, s, n);
    if ( ttylist == NULL ) ttylist = new TtyList ;
    ss = ss >> key >> &ComSep() >> &Separator ("=") >> &ComSep() >> 
    &Separator ( "{" ) >>  &ComSep() >> ttylist >> &ComSep() >> 
    &Separator ( "}" );
    if ( ! ss. is_valid () ) return -1;
    
    sp = s; np = ss.stream_sp;
    return 0;
  }
}; 
    
#endif /* ___CUSTOM_H___ */