// #include <windows.h>
#pragma hdrstop

#pragma implementation
#include "custom.h"
#include "aparser.h"

/******************************************************************
   for template implementation
*******************************************************************/

template class StemPair < DayOfWeek,DayOfWeek >;
template class MonoList2 < DayOfWeekInterval, DayOfWeek >;
template class MonoList < UserName >;
template class MonoList < Word >;
template class EitherOr < Star, UserNameList >;
template class EitherOr < AnyStem, DaysList >;
template class EitherOr < AnyStem, TimeOfDayIntervalList >;
template class EitherOr < UnlStem, TimeOfDay >;
template class EitherOr < UnlStem, UnsBytes >;
template class EitherOr < AnyStem, TtyList >;
template class MonoArray < UsersTimeTableItem >;
template class StemPair < UsersTimeTableKeyword, UsersTimeTable >;

template class StemPair < Word, Quotas>;
template class MonoArray < TagItem >;
template class StemPair < TtyTagKeyword,TagBody>;

template class StemPair < Keyword, Uns >;


/********************************************************************
		 DaysList && DaysOfWeekInterval implementation
********************************************************************/

IMPLEMENT_CAST1(DayOfWeekInterval,stem);
IMPLEMENT_CAST1(DaysList,stem);
IMPLEMENT_CAST1(UserName,Word);
IMPLEMENT_CAST1(UserNameList,stem);
IMPLEMENT_CAST1(Star,Separator);
IMPLEMENT_CAST1(AnyStem,Keyword);
IMPLEMENT_CAST1(UnlStem,Keyword);
IMPLEMENT_CAST1(UserField,stem);
IMPLEMENT_CAST1(DaysField,stem);
IMPLEMENT_CAST1(IntervalsField,stem);
IMPLEMENT_CAST1(DailyLimitField,stem);
IMPLEMENT_CAST1(TrafficLimitField, stem);
IMPLEMENT_CAST1(TtyList,stem);
IMPLEMENT_CAST1(TtyListField,stem);
IMPLEMENT_CAST1(SuField,Keyword);
IMPLEMENT_CAST1(UsersTimeTableItem,stem);
IMPLEMENT_CAST1 ( UsersTimeTableBody,stem);
IMPLEMENT_CAST1(UsersTimeTable,stem);
IMPLEMENT_CAST1(UsersTimeTableKeyword,Keyword);
IMPLEMENT_CAST1(UsersTimeTablePair,stem);

IMPLEMENT_CAST1(TagItem,stem);
IMPLEMENT_CAST1(TagBody,stem);
IMPLEMENT_CAST1(TtyTagKeyword,Keyword);
IMPLEMENT_CAST1(TtyTags,stem);


/* for DaysOfWeek we should submit interval validation
	( between MONDAY_VAL and SUNDAY_VAL , and that
	Lvalue < Rvalue */
int DayOfWeekInterval::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
	if ( StemPair < DayOfWeek,DayOfWeek > :: LocateLtoR ( str, s, n) )
		return -1; /* generic parse failed */
	/* ok, continue with validation */
	/* 1. range validation */
	if ( Lvalue -> value > SATURDAY_VAL || Rvalue -> value > SATURDAY_VAL )
	{
		return -1;
	}
	if ( Lvalue -> value < SUNDAY_VAL || Rvalue -> value < SUNDAY_VAL )
		return -1;
	/* 2. relationship validation */
	if ( Lvalue -> value >= Rvalue -> value )
	{
#ifdef ERROR_REPORTING
		Oops ( &str [ s ],
			"warning--DayOfWeekInterval:Invalid day interval (:-\n" );
#endif
		return -1;
	}
	/* all is ok */
	return 0;
}

/* all we need to do for DaysList is implement our custom data output iterators*/
int DaysList::
GetFirstDay (void )
{
	sli_pr = base. base; /* get first item in list */
	DayOfWeek* dow_pr;
	DayOfWeekInterval* dowi_pr;

	dow_pr = DOWNCAST_MOSTDERIVED ( sli_pr, DayOfWeek );
	dowi_pr = DOWNCAST_MOSTDERIVED ( sli_pr, DayOfWeekInterval );

	if ( dow_pr )
		/* it is a single day definition */
		return dow_pr -> value;
	else if ( dowi_pr )
	{
		CurrDay = dowi_pr -> Lvalue -> value;
		return CurrDay;
	}
	else
		return -1; /*something strange!, or empty object */

}

int DaysList::
GetNextDay ( void )
{
	DayOfWeek* dow_pr;
	DayOfWeekInterval* dowi_pr;

	dow_pr = DOWNCAST_MOSTDERIVED ( sli_pr, DayOfWeek );
	dowi_pr = DOWNCAST_MOSTDERIVED ( sli_pr, DayOfWeekInterval );

	if ( dowi_pr && dowi_pr -> Rvalue -> value > CurrDay )
		return ++CurrDay;
	/* else goto next item */

	sli_pr = sli_pr -> next;
	if ( sli_pr == NULL ) return -1; /* end of data is reached */

	dow_pr = DOWNCAST_MOSTDERIVED ( sli_pr, DayOfWeek );
	dowi_pr = DOWNCAST_MOSTDERIVED ( sli_pr, DayOfWeekInterval );
	if ( dow_pr )
		return dow_pr -> value;
	else if ( dowi_pr )
	{
		CurrDay = dowi_pr -> Lvalue -> value;
		return CurrDay;
	}
	else
		return -1; /* definitely is something wrong! */

}

/****************************************************************************/
int UsersTimeTableItem ::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
	uf_pr = new UserField;
	df_pr = new DaysField;
	if_pr = new IntervalsField;
	dlf_pr = new DailyLimitField;
	tl_pr = new TrafficLimitField;
	tlf_pr = new TtyListField;
	sf_pr = new SuField;

	stemStream ss ( str, s, n ),curr_ss;

	ss =ss >> uf_pr >> &ComSep() >> df_pr >> &ComSep() >>
		if_pr >> &ComSep() >> dlf_pr>> &ComSep() >> 
		tl_pr >> &ComSep() >> tlf_pr >> &ComSep();
	if ( ! ss. is_valid() )
	{
		delete uf_pr; uf_pr = NULL;
		delete df_pr; df_pr = NULL;
		delete if_pr; if_pr = NULL;
		delete dlf_pr; dlf_pr = NULL;
		delete tl_pr; tl_pr = NULL;
		delete tlf_pr; tlf_pr = NULL;
		delete sf_pr; sf_pr = NULL;

// #ifdef ERROR_REPORTING
		Oops ( &str [ s ],
			"warning--UsersTimeTableItem: Invalid Users Time Table Item structure (:-\n" );
// #endif

		return -1;
	}

	curr_ss=ss;
	/* try out for final ;*/
	ss = ss>> &Separator ( ";" );
	if ( ss. is_valid () )
	{
		delete sf_pr; sf_pr = NULL;

		sp = s;
		np = ss . stream_sp;

		return 0;
	}

	/* else try for su field and ; */
	ss = curr_ss >>  sf_pr >> &ComSep() >> &Separator ( ";" );

	if ( ! ss . is_valid() )
	{
		delete uf_pr; uf_pr = NULL;
		delete df_pr; df_pr = NULL;
		delete if_pr; if_pr = NULL;
		delete dlf_pr; dlf_pr = NULL;
		delete tl_pr; tl_pr = NULL;
		delete tlf_pr; tlf_pr = NULL;
		
		delete sf_pr; sf_pr = NULL;
#ifdef ERROR_REPORTING
		Oops( &str [ s],
			"warning--UsersTimeTableItem: SU field expected (:-\n" );
#endif

		return -1;
	}
	/* else all is okay, optional su field is present */

	sp = s;
	np = ss . stream_sp;
	return 0;


};

/*************************************************************************/

int UsersTimeTable ::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
	stemStream ss ( str, s, n );

	body = new UsersTimeTableBody;

	ss=ss >> &Separator ( "{") >> &ComSep() >> body >> &ComSep() >> &Separator ("}");
	if ( ! ss. is_valid () )
	{
		delete body;
		body = NULL;
#ifdef ERROR_REPORTING
		Oops ( &str [s],
			"--Fatal syntax:while parsing body for UsersTimeTable (see hints above,if any) (:-\n" );
#endif

		return -1;
	}
	sp  =s;
	np = ss. stream_sp;
	return 0;
}

/*************************************************************************
      UserTags and TtyTags, added 3 aug 1996
      6 aug 1996 : UserTags support removed as obsolete
                   Now Ttytags only
**************************************************************************/

int TagItem::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
  int result = StemPair <Word,Quotas>::LocateLtoR( str,s,n);
  if ( result ) return result;

  stemStream ss ( str, np, n );
  ss = ss >>&ComSep()>> &Separator (";");
  if ( ! ss. is_valid() ) return -1;

  // located here okay
  // correcting np
  np = ss. stream_sp;
   
  // reading values 
  if ( Lvalue -> np - Lvalue -> sp > MAXTAGNAMELEN )
    return -1; // tag name len exceeds the storage
  memcpy ( (void* )name, &str [ Lvalue -> sp ], Lvalue -> np - Lvalue ->sp );
    name [ Lvalue -> np - Lvalue-> sp ] = 0; // fix it;

  if ( Rvalue -> np - Rvalue -> sp  > MAXTAGVALUELEN ) 
    return -1;
  memcpy ( (void* )value, &str [ Rvalue-> sp ], Rvalue -> np - Rvalue -> sp );
    value [ Rvalue -> np - Rvalue -> sp ] = 0;// fix it ;
 
  //all is okay   
  return 0;
}

int TagBody:: 
LocateLtoR ( char* str, unsigned s, unsigned n )
{
  stemStream ss ( str,s,n);
  ss = ss >> &Separator ( "{") >> &ComSep();
  if ( ! ss . is_valid() ) return -1;
  
  if ( MonoArray < TagItem >::LocateLtoR ( str, ss.stream_sp,n))
    return -1;
  
  ss = stemStream ( str, np, n );
  ss = ss>> &ComSep() >> &Separator  ("}" );
  if ( ! ss. is_valid() ) return -1;
  
  // correcting values 
  sp = s;
  np = ss . stream_sp;
  
  return 0;
}