//#include <owl/owlpch.h>
//#pragma hdrstop

#include "common.h"
#include <stdio.h>
#include <stdarg.h>
#include <syslog.h>

/* static void PrintUtmp ( RootWtmp* rw_pr ); */
/*
static void PrintUtmp ( RootWtmp* rw_pr )
{

	// print out all statistic 
	UserLimitInfo* uli_pr;
	for ( uli_pr = rw_pr -> base;
	  uli_pr;
	  uli_pr = uli_pr -> next
	)
	{
	  printf ( "---> Statistic for user %s <---\n", uli_pr -> UserName );
	  TtyUsageInfo* tui_pr;
	  for ( tui_pr = uli_pr -> TtyBase .base;
	    tui_pr;
	    tui_pr = tui_pr -> next
	  )
	  {
	    printf ( "Tty Name: %s, Abbreviated name :%s\n",
	      tui_pr -> Line, tui_pr -> AbbrevLine );
	    printf ( "   -- Usage :%d days %d hours %d minutes %d seconds (%lu seconds overall)\n",
	      tui_pr -> Usage / (24 * 60 * 60 ),
	      (unsigned )( tui_pr -> Usage % ( 24 * 60 * 60 )) / 3600,
	      (unsigned )( tui_pr -> Usage % ( 60 * 60 )) / 60,
	      (unsigned )( tui_pr -> Usage % 60 ),
	      tui_pr -> Usage
	    );
	    if ( tui_pr -> UsageProps & TUI_LOGGED_NOW )
	    {
	      printf ( "   -- Still Logged in");
	      printf ( " with Pid = %u at %s\n", tui_pr -> LastPid,
	        ctime ( &tui_pr -> LastLog ) );
	    }
	    if ( tui_pr -> UsageProps & TUI_HAS_CRASHES )
	    {
	      printf ( "   -- wtmp inconsistence detected for this user&tty\n" );
	    }
	  }
	}
}
*/
/************************************************************************
         Some common service here 
*************************************************************************/

char LogBuff [ 256 ];

void Log ( int DebugLevel )
{
  if ( DebugLevel > DEBUG_LEVEL )
    return;
  FILE* debug_file;
#ifdef LOG_TO_SCREEN
  debug_file = stderr;
#else 
  debug_file = fopen ( LOG_FILE, "a" );
#endif

  if ( debug_file == NULL )
  {
    printf ( "Fatal! unable to open log file!\n " );
    exit(1);
  } 
  
  fprintf ( debug_file, LogBuff );
#ifdef LOG_TO_SYSLOG
  openlog ( ModuleName, LOG_PID, LOG_USER );
  syslog ( LOG_INFO, LogBuff);
  closelog ( );
#endif

#ifndef LOG_TO_SCREEN  
  fclose ( debug_file );
#endif  
  return;
}

void Log2 ( int DebugLevel, char* fmt, ... )
{
  va_list ap;
  va_start ( ap,fmt );
  vsprintf ( LogBuff, fmt, ap );
  Log ( DebugLevel );
  va_end ( ap );
}