
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <time.h>
#include <utmp.h>

#include "post-query.h"
#include "handshakes.h"
#include "memdata.h"
#include "utmpdata.h"


extern char MainForm[];
extern char UsTraffStart[];
extern char UsTraffEnd[];
extern char UsTimeStart [];
extern char UsSchedStart [];
extern char UsSchedEnd[];
extern char UsTraffStatHead [];
extern char UsStatTail [];
extern char UsAllStat[];
extern char UsOverallStatHead[];

RootBase UserRoot;
RootWtmp StatWtmp;
TagBase TtyTagsBase;
time_t  LastWtmpCheck;

static struct sockaddr_in sa;
static int sock;
static FILE* fsock;
static struct Handshake_st ModuleSig = { CGI_SIG, VERSION };
static struct Handshake_st RespSig;
static time_t start_time, end_time;
static char u_name [ UT_NAMESIZE + 1];

// returns index of the post entry found or -1 if not found
static int ConnectToAdmind();
static int ReadUserRoot();
static int ReadStatWtmp(time_t Start, time_t End);
static void UserTimeOrTraffic ( int Action );
static void UserSched ( void );
static void OneUserStat ( int );
static int UserTimeOrTrafficStat ( void );
static void PrintOutUserStat (char* u_name );
static void PrintOutAllStat ( void);
static void OverallStat ();
static void AllUsersStat();

static const char ErrorMess [] =
  "<P>Inconsistent POST request. Data cannot be handled in "
  "proper way. <P>Contact your administrator.\n";

static const char ConErrMess [] =
  "<P>Error occured while trying to connect to admind resources. "
  "<P>Make a report about this to your network administrator.";

// placeholders for log utilites from memdata.o, etc.
// no logging in cgi's
char LogBuff [ 128 ];
void Log ( int )   { printf ( LogBuff ); };
void Log2 ( int, char* log, ... ) 
{ 
  va_list ap;
  va_start(ap,log);
  vprintf (log,ap ); 
};

int main ( char**, int )
{
  int id;

  printf ( "Content-type: text/html\n\n" );

  int PostResult=TreatPostQuery ( stdin );
  if ( PostResult == TPQ_NOT_A_POST )
  {
    
//    fprintf ( stderr, "about pr\n" );
    fputs ( MainForm, stdout );
    return 0;
  }
  if ( PostResult == 0 )
  {
    if ( -1 == ( id = FindEntry ( "ID" ) ) )
    { printf ( ErrorMess ); exit ( 0 ); }
  }
  if ( !strcmp ( Entries [ id ] .val, "main" ) )
  {
    // it is the request from FormMain 
    int Action = FindEntry ( "Action" );
    if ( Action == -1 ) 
    { printf ( ErrorMess ); exit ( 0 ); }
    
    // what action ?
    if ( !strcmp ( Entries [ Action ] . val, "USER_TIME" ) || 
      !strcmp ( Entries [ Action ] . val,"USER_TRAFFIC" )) 
    {
      // Particular user traffic or time request  
      UserTimeOrTraffic ( Action );
      exit ( 0  );
    }
    else if ( !strcmp (Entries [ Action ].val, "USER_SCHED" ) )
    {
      UserSched();
      exit ( 0 );
    }
    else if ( !strcmp ( Entries [Action].val, "OVERALL_TIME" ) ||
      !strcmp ( Entries [ Action ].val, "OVERALL_TRAFFIC" ))
    {
      OverallStat ();
      exit ( 0 );
    }

  } 
  else if ( !strcmp( Entries [id ] . val, "user_traffic" ) ||
    !strcmp( Entries [ id ].val, "user_time" ))
  {
    OneUserStat (id );
    exit ( 0 );
  }
  else if ( !strcmp ( Entries [ id ] .val, "all_stat" ) )
  {
    AllUsersStat (); exit (0);
  }
  else 
  {
    // unknown error
    printf ( ErrorMess );
  }
  
  return 0;
  

}



/**************************************************************************
                       Handlers for id=main
**************************************************************************/                       

static void OverallStat ( void )
{
  puts ( UsAllStat );
  return;
}

static void AllUsersStat ( void )
{

  if ( UserTimeOrTrafficStat() )
    return;
    
  // wtmp read okay.
    
  puts ( UsOverallStatHead );
  
  printf ( "<table width=100% valign=center align=center border>\n" );
  printf ( "<tr><td><center>-- User %s statistics is as follows: -- \n", u_name);
  printf ( "<BR>Start Date:%s, ", ctime ( &start_time));
  printf ( "End Date:%s\n", ctime ( &end_time ));
  printf ( "<BR>Check for this report was done on %s", ctime (&LastWtmpCheck));
  printf ( "</table>\n" );
  
    
  // printing stat table header
  
  printf ( "<table width=100% align=center border>\n<tr>\n" );
  printf ( "<th> User Description \n<th> User login \n<th> Line\n" );
  printf ( "<th> Time Usage \n<th> Notes \n<th> Device \n<th> Traffic \n" );
  
  PrintOutAllStat ( );
  
  // printing table tail
  printf ("</table>" );
  
  // some notes .
  printf ( "<BR><H5><B> *)</B> The time from last login till the present is not counted "
    "in that statistic for those cases. To obtain the real time user has been "
    "on till present moment, add interval from last login to present for these "
    "lines(ttys)\n" );

  printf ( "<BR><B> **)</B> These users were on on those terminals when "
    " crash had occured. Their time usage counted may or may not "
    "include those intervals, according to compilation-time settings."
    " In either case, their real time usages may differ from real matters."
    " Last logout field contains last distinct (valid) logout of the user "
    "unless crash time accounting is enabled; in the latter case it may be set "
    "to the last system recovery time.</H5>" );
    
  puts ( UsStatTail );
   
  return;
}      


static void OneUserStat ( int id )
{
  int u_index = FindEntry ( "User" );
  if ( u_index <0 || strlen ( Entries [ u_index ] . val ) > UT_NAMESIZE) 
  { printf ( ErrorMess ); return -1 ; }
  
  strcpy ( u_name, Entries [ u_index] .val );

  if ( UserTimeOrTrafficStat() )
    return;
    
  // wtmp read okay.
    
  puts ( UsTraffStatHead );
  
  printf ( "<table width=100% valign=center align=center border>\n" );
  printf ( "<tr><td><center>-- User %s statistics is as follows: -- \n", u_name);
  printf ( "<BR>Start Date:%s, ", ctime ( &start_time));
  printf ( "End Date:%s\n", ctime ( &end_time ));
  printf ( "<BR>Check for this report was done on %s", ctime (&LastWtmpCheck));
  printf ( "</table>\n" );
  
    
  // printing stat table header
  
  printf ( "<table width=100% align=center border>\n<tr>\n" );
  printf ( "<th> User Description \n<th> User login \n<th> Line\n" );
  printf ( "<th> Time Usage \n<th> Notes \n<th> Device \n<th> Traffic \n" );
  
  PrintOutUserStat ( u_name );
  
  // printing table tail
  printf ("</table>" );
  
  // some notes .
  printf ( "<BR><H5><B> *)</B> The time from last login till the present is not counted "
    "in that statistic for those cases. To obtain the real time user has been "
    "on till present moment, add interval from last login to present for these "
    "lines(ttys)\n" );
    
  printf ( "<BR><B> **)</B> These users were on on those terminals when "
    " crash had occured. Their time usage counted may or may not "
    "include those intervals, according to compilation-time settings."
    " In either case, their real time usages may differ from real matters."
    " Last logout field contains last distinct (valid) logout of the user "
    "unless crash time accounting is enabled; in the latter case it may be set "
    "to the last system recovery time.</H5>" );
  
  puts ( UsStatTail );
   
  return;
}      
      
static void UserSched ( void )
{

  if ( ReadUserRoot() ) return;
  // communicating is done okay 
  puts (UsSchedStart );
  // 7-column table is open here 
  
  User_st* usr_pr;
  for ( usr_pr = UserRoot . base; usr_pr; usr_pr = usr_pr -> next )
  {
    int usr_rowspan = 0;
    Tty_st* tty_pr;
    Interval_st* interval_pr;
    Day_st* day_pr;
    
    // counting rowspan
    for ( day_pr = usr_pr-> DayBase . base; day_pr; day_pr = day_pr -> next)
    {
      int inc = MAX( day_pr -> TtyBase . Size(), 
        day_pr -> IntervalBase . Size() );
      inc = inc?inc:1;
      usr_rowspan+=inc;
    }
    if ( usr_rowspan == 0 ) usr_rowspan = 1;
   
    printf ( "<tr>\n<td rowspan=%d><center>", usr_rowspan );
    if ( usr_pr -> UserTag == NULL ) 
      printf ( "None defined" );
    else printf  ( "%s", usr_pr -> UserTag );
    printf ( "\n<td rowspan=%d><center>%s\n", usr_rowspan, usr_pr -> UserName );
    
    for ( day_pr = usr_pr -> DayBase .base; day_pr; day_pr = day_pr -> next )
    {
      int tty_rowspan = day_pr -> TtyBase. Size();
      int interval_rowspan = day_pr -> IntervalBase.Size();
      if ( !tty_rowspan ) tty_rowspan =1;
      if ( !interval_rowspan) interval_rowspan=1;
     
      int day_rowspan = MAX ( tty_rowspan, interval_rowspan );
      int lasttty_span, lastinterval_span;
      
      lasttty_span = day_rowspan % tty_rowspan;
      lastinterval_span = day_rowspan %interval_rowspan;
      
      tty_rowspan = day_rowspan / tty_rowspan;
      interval_rowspan = day_rowspan / interval_rowspan;
      lasttty_span+= tty_rowspan;
      lastinterval_span+=interval_rowspan;
        
      if ( day_rowspan == 0) day_rowspan =1;
      printf ( "<td rowspan = %d><center>", day_rowspan );
      switch ( day_pr -> Day )
      {
        case SUNDAY_VAL:printf ( "Sunday" ); break;
        case MONDAY_VAL:printf ( "Monday" ); break;
        case TUESDAY_VAL:printf ( "Tuesday" ); break;
        case WEDNESDAY_VAL:printf ("Wednesday" ); break;
        case THURSDAY_VAL:printf ( "Thursday" ); break;
        case FRIDAY_VAL: printf ( "Friday" ); break;
        case SATURDAY_VAL:printf ( "Saturday" ); break;
        default:printf ("unknown" );
      }
      if ( day_pr -> DayProps & DAY_UNLIMITED )
        printf ( "<td rowspan=%d><center>UNLIMITED", day_rowspan);
      else 
        printf ( "<td rowspan=%d><center>%dh : %dm : %ds\n", day_rowspan, 
          (int)( day_pr -> DayLimit/3600),
          (int)(( day_pr -> DayLimit %3600)/60 ),
          (int)(day_pr -> DayLimit % 60 ));
      if ( day_pr -> DayProps & DAY_TRAFFIC_UNLIMITED )
        printf ( "<td rowspan=%d><center> UNLIMITED",day_rowspan );
      else
      {
        printf ( "<td rowspan=%d><center>",day_rowspan);
        if ( day_pr -> TrafficLimit >= 1024*1024 ) /* print in Megabytes */
          printf ( "%.2fM (%lu bytes)", (float)day_pr -> TrafficLimit / (1024*1024),
            day_pr -> TrafficLimit );
        else if ( day_pr -> TrafficLimit >= 1024 ) /* print in kbytes */
          printf ( "%.2fK (%lu bytes)", (float)day_pr -> TrafficLimit /1024,
            day_pr -> TrafficLimit );
        else /* print in bytes */
          printf ( "%lu bytes\n", day_pr -> TrafficLimit );
      }
      
      int i;
      tty_pr = day_pr -> TtyBase . base;
      interval_pr = day_pr -> IntervalBase .base;
      
      for ( i = 0; i < day_rowspan; i++ )
      {
        if ( i== 0 && day_pr -> DayProps & DAY_ANYTIME )
          printf ( "<TD ROWSPAN=%d><center>Any time\n", interval_rowspan );
          

        if ( interval_pr && ( i % interval_rowspan == 0) )
        {
          printf ( "<TD rowspan=%d><center>%dh : %dm : %ds -<br>%dh : %dm : %ds\n",
            (interval_pr->next==NULL)?lastinterval_span:interval_rowspan,
            
            (int)(interval_pr->start/3600), 
            (int)((interval_pr -> start %3600)/60),
            (int)(interval_pr -> start % 60),
            
            (int)(interval_pr -> end /3600),
            (int)((interval_pr -> end %3600)/60),
            (int)(interval_pr -> end %60));
            
          interval_pr = interval_pr -> next;
        }
        if ( i==0 && day_pr -> DayProps & DAY_ANYTTY )
          printf ( "<TD ROWSPAN=%d><center>Any\n", tty_rowspan );
        if ( tty_pr && ( i % tty_rowspan  == 0) )
        { 
          printf ( "<TD ROWSPAN=%d><center>", (tty_pr->next==NULL)?
            lasttty_span:tty_rowspan );
          Tag_st* tty_tag = TtyTagsBase . FindTag ( tty_pr -> Line );
          if ( tty_tag == NULL )
            printf ( "%s\n", tty_pr -> Line );
          else 
            printf ( "%s\n", tty_tag -> value );
	  tty_pr = tty_pr -> next;
        }
        printf ( "<tr>\n" );
      }
    }
  }  
  puts ( UsSchedEnd );
  return;  
    
  
}
 
static void UserTimeOrTraffic ( int Action )
{
  if ( ReadUserRoot() ) return;
  
  if ( ! strcmp( "USER_TIME", Entries [ Action ] .val ) )
    puts ( UsTimeStart );
  else 
    puts ( UsTraffStart );
    
    
  User_st* usr_pr;
  for ( usr_pr = UserRoot . base; usr_pr; usr_pr=usr_pr -> next )
  {
    printf ( "<OPTION VALUE=%s>", usr_pr -> UserName );
    if ( usr_pr -> UserTag == NULL )
      printf ( "%s\n", usr_pr -> UserName );
    else 
      printf ( "%s\n", usr_pr -> UserTag );
  }
  
  puts ( UsTraffEnd );
  
  return;
}

/************************************************************************
              Services
*************************************************************************/
  
static int ConnectToAdmind()
{
#ifndef NO_DEBUG
   Log2 ( 4, "entered ConnectToAdmind\n" );
#endif
   struct hostent* h_pr = gethostbyname ( CGI_ADDR );
   if ( h_pr == NULL ) 
   { printf ( ConErrMess ); return -1; }

#ifndef NO_DEBUG
   Log2 ( 4, "got hostent okay\n" );
#endif
   
   memset ( (void* )&sa, 0, sizeof ( sa ) );
   
   sa.sin_family = AF_INET;
   memcpy ( (void*) &sa.sin_addr, (void*) h_pr -> h_addr, h_pr -> h_length);
   
   sa.sin_port = htons( CGI_PORT );
   sock = socket ( AF_INET, SOCK_STREAM, 0 );

#ifndef NO_DEBUG
   Log2 (4, "about calling connect()\n" );
#endif   
   if ( -1 == connect ( sock, (struct sockaddr*)&sa, sizeof (sa )) )
   { printf ( ConErrMess ); return -1; }
#ifndef NO_DEBUG
   Log2 ( 4, "<P>connected okay\n" );
#endif
   
   // connected . 
   if  (NULL == (fsock= fdopen ( sock, "r+" ) ) )
   { printf (ConErrMess ); return -1; }

#ifndef NO_DEBUG
   Log2 ( 4, "<P> fdopen() passed okay.\n" );
#endif
   
   //     
   return 0;
 }
     
static int ReadUserRoot ( void )
{
  if ( ConnectToAdmind() ) return -1;
  // we are connected.
  if ( 1!= fwrite  ( (void* ) &ModuleSig, sizeof ( ModuleSig), 1, fsock ))
  { printf ( ConErrMess ); return -1; }
  fflush ( fsock );
  
  // waiting for signature reply
  if  ( 1 != fread ( ( void* ) &RespSig, sizeof  ( RespSig ), 1, fsock ))
  { printf ( ConErrMess ); return -1 ;  }

  // waiting for acknowledge signature
  { 
    char AcknowledgeSig [ 2 ];
    if ( 1 != fread ( ( void* ) AcknowledgeSig, 2, 1, fsock ))
    { printf ( ConErrMess ); return -1; }
    if ( memcmp ( (void* ) AcknowledgeSig, (void* )"OK", 2 ) )
    {
      printf ( "<P><H2> Admind reported an error </H2> "
        "<P>Admind was not ready to serve your request because the daemon "
        "has reached its limit. Please try later.\n" );
      exit ( 1 );
    }
  }
  
  // sending request 
  AWReaderRequest request=  { OC_USER_ROOT, 0, 0, 0 };
  
  if ( 1 != fwrite ( (void* )& request, sizeof ( request),1, fsock ))
  { printf ( ConErrMess ); return -1; }
  
  fflush ( fsock );
  
  // now waiting for reply
  if ( UserRoot . ReadFromStream ( fsock  )||
    TtyTagsBase . ReadFromStream ( fsock ))
  { printf ( ConErrMess ); return -1; }
  
  fclose ( fsock ); // communicating session is done okay 

#ifdef HIDE_SU_STAT // eliminate any statistics for SU users
  User_st* usr_pr, *next_pr;
  for (usr_pr = UserRoot . base;
    usr_pr ;
  )
    if ( usr_pr -> UserProps & US_SU ) // superuser detected 
    {
      next_pr = usr_pr -> next ;
      delete usr_pr;
      usr_pr = next_pr;
    } else usr_pr = usr_pr -> next;
#endif

  return 0;
}
   
static int ReadStatWtmp ( time_t Start, time_t End )
{
  if ( ConnectToAdmind() ) return -1;
  // we are connected.
  if ( 1!= fwrite  ( (void* ) &ModuleSig, sizeof ( ModuleSig), 1, fsock ))
  { printf ( ConErrMess ); return -1; }
  fflush ( fsock );
  
  // waiting for signature reply
  if  ( 1 != fread ( ( void* ) &RespSig, sizeof  ( RespSig ), 1, fsock ))
  { printf ( ConErrMess ); return -1 ;  }

  // waiting for acknowledge signature
  { 
    char AcknowledgeSig [ 2 ];
    if ( 1 != fread ( ( void* ) AcknowledgeSig, 2, 1, fsock ))
    { printf ( ConErrMess ); return -1; }
    if ( memcmp ( (void* ) AcknowledgeSig, (void* )"OK", 2 ) )
    {
      printf ( "<P><H2> Admind reported an error </H2> "
        "<P>Admind was not ready to serve your request because the daemon "
        "has reached its limit. Please try later.\n" );
      exit ( 1 );
    }
  }

  
  // sending request 
  AWReaderRequest request=  { OC_STAT, Start, End, 0 };
  
  if ( 1 != fwrite ((void*)&request, sizeof ( request ), 1, fsock ))
  { printf ( ConErrMess ); return -1; }
  fflush ( fsock );
  
  // reading the answer
  if ( StatWtmp . ReadFromStream ( fsock ) ||
    1 != fread ( (void*) &LastWtmpCheck, 
    sizeof ( LastWtmpCheck ), 1, fsock ) ||
    TtyTagsBase . ReadFromStream ( fsock ) ||
    UserRoot. ReadFromStream ( fsock ) )
  { printf ( ConErrMess ); return -1; }
  
  fclose ( fsock );

#ifdef HIDE_SU_STAT        // hide su statistics 
  User_st* usr_pr, *next_pr;
  UserLimitInfo* uli_pr;
  for ( usr_pr = UserRoot. base;
    usr_pr;
  )
  {
    if ( ( usr_pr -> UserProps & US_SU ) == 0 )
    {
      usr_pr = usr_pr -> next; 
      continue;
    }
    uli_pr = StatWtmp . FindUserLimitInfo ( usr_pr -> UserName );
    if ( uli_pr ) delete uli_pr;
    next_pr = usr_pr -> next;
    delete usr_pr;
    usr_pr = next_pr;
  }
#endif
  
  return 0;
}

static int UserTimeOrTrafficStat ( void )
{
  
  
  
  int st_date_index = FindEntry ( "START_DATE" );
  int st_month_index = FindEntry  ("START_MONTH" );
  int st_year_index = FindEntry ( "START_YEAR" );
  int en_date_index = FindEntry ( "END_DATE" );
  int en_month_index = FindEntry ( "END_MONTH" );
  int en_year_index = FindEntry ( "END_YEAR" );
  
  
  if ( -1 == st_date_index || -1 == st_month_index ||
    -1 == st_year_index || -1 == en_date_index ||
    -1 == en_month_index || -1 == en_year_index )
  { printf ( ErrorMess ); exit ( 0 ); }
  
  int st_date = atoi ( Entries [ st_date_index ] .val );
  int en_date = atoi ( Entries [ en_date_index ] .val );
  int st_year = atoi  ( Entries [ st_year_index ] . val ) - 1900;
  int en_year = atoi ( Entries [ en_year_index ] . val ) - 1900;
  
  if (st_date < 1 || st_date > 31 || en_date < 1 || en_date > 31 ||
    en_year < 0 || st_year < 0 )
  { printf ( ErrorMess ); exit ( 0 ); }
  
  struct tm start, end;
  memset ( (void* ) &start, 0, sizeof ( start ));
  memset ( (void* ) &end, 0, sizeof ( end ));
  
  start . tm_mday = st_date;
  end . tm_mday = en_date;
  
  start . tm_year = st_year;
  end . tm_year = en_year;
  
  if ( ! strcmp ( Entries [ st_month_index ].val, "Jan" ))
    start . tm_mon = 0;
  else if ( ! strcmp (Entries [ st_month_index ].val, "Feb" ))
    start .tm_mon = 1;
  else if ( ! strcmp ( Entries [ st_month_index ].val, "Mar" ))
    start . tm_mon = 2;
  else if ( ! strcmp (Entries [ st_month_index ].val, "Apr" ))
    start .tm_mon = 3;
  else if ( ! strcmp ( Entries [ st_month_index ].val, "May" ))
    start . tm_mon = 4;
  else if ( ! strcmp (Entries [ st_month_index ].val, "Jun" ))
    start .tm_mon = 5;
  else if ( ! strcmp ( Entries [ st_month_index ].val, "Jul" ))
    start . tm_mon = 6;
  else if ( ! strcmp (Entries [ st_month_index ].val, "Aug" ))
    start .tm_mon = 7;
  else if ( ! strcmp ( Entries [ st_month_index ].val, "Sep" ))
    start . tm_mon = 8;
  else if ( ! strcmp (Entries [ st_month_index ].val, "Oct" ))
    start .tm_mon = 9;
  else if ( ! strcmp ( Entries [ st_month_index ].val, "Nov" ))
    start . tm_mon = 10;
  else if ( ! strcmp (Entries [ st_month_index ].val, "Dec" ))
    start .tm_mon = 11;
  else { printf ( ErrorMess ); exit ( 0 ); }
  
  if ( ! strcmp ( Entries [ en_month_index ].val, "Jan" ))
    end . tm_mon = 0;
  else if ( ! strcmp (Entries [ en_month_index ].val, "Feb" ))
    end .tm_mon = 1;
  else if ( ! strcmp ( Entries [ en_month_index ].val, "Mar" ))
    end . tm_mon = 2;
  else if ( ! strcmp (Entries [ en_month_index ].val, "Apr" ))
    end .tm_mon = 3;
  else if ( ! strcmp ( Entries [ en_month_index ].val, "May" ))
    end . tm_mon = 4;
  else if ( ! strcmp (Entries [ en_month_index ].val, "Jun" ))
    end .tm_mon = 5;
  else if ( ! strcmp ( Entries [ en_month_index ].val, "Jul" ))
    end . tm_mon = 6;
  else if ( ! strcmp (Entries [ en_month_index ].val, "Aug" ))
    end .tm_mon = 7;
  else if ( ! strcmp ( Entries [ en_month_index ].val, "Sep" ))
    end . tm_mon = 8;
  else if ( ! strcmp (Entries [ en_month_index ].val, "Oct" ))
    end .tm_mon = 9;
  else if ( ! strcmp ( Entries [ en_month_index ].val, "Nov" ))
    end . tm_mon = 10;
  else if ( ! strcmp (Entries [ en_month_index ].val, "Dec" ))
    end .tm_mon = 11;
  else { printf ( ErrorMess ); exit ( 0 ); } 
  

  // uh! my poor fingers was nearly got stiff as hell!

#ifndef NO_DEBUG
  Log2 (4,"<BR>time composed:start:tm_mday=%d;tm_mon=%d;tm_year=%d"
  ";tm_hour=%d;tm_min=%d;tm_sec=%d\n",
    start.tm_mday, start.tm_mon, start.tm_year, start.tm_hour,
    start.tm_min, start.tm_sec );
  Log2 (4,"<BR>time composed:end:tm_mday=%d;tm_mon=%d;tm_year=%d"
  ";tm_hour=%d;tm_min=%d;tm_sec=%d\n",
    end.tm_mday, end.tm_mon, end.tm_year, end.tm_hour,
    end.tm_min, end.tm_sec );
#endif    
  
  start_time = mktime ( &start );
  end_time = mktime ( &end );
#ifndef NO_DEBUG
  Log2 (4, "<BR>mktime returned start time %s", ctime( &start_time) );
  Log2 (4, "<BR>mktime returned end time %s", ctime( &end_time) );
#endif    

  if ( end_time < start_time )
  { printf ( ErrorMess ); return -1; }
 
  // making the request to admind 
  
  if ( ReadStatWtmp ( start_time, end_time ) )
  { printf ( ConErrMess ); return; }
  
  // request succeeded. proceed.
  
//  puts ( UsTraffStatHead );
  
//  if ( ! strcmp ( Entries [ id ] .val, "user_traffic" ) )
//    PrintOutTraffic();
//  else PrintOutTime();
  
//  puts ( UsStatTail );
  
  return 0;
}

static void PrintOutAllStat ( void )
{
  User_st* usr_pr;
  for ( usr_pr = UserRoot . base; usr_pr; usr_pr = usr_pr -> next )
    PrintOutUserStat ( usr_pr -> UserName );
  return;
}
  
static void PrintOutUserStat ( char* u_name )
{
  
  User_st* usr_pr = UserRoot . FindUser ( u_name );
  if  ( usr_pr == NULL )
  { printf ( ErrorMess ); return; }

  printf ("<tr><tr>\n" );

  UserLimitInfo* uli_pr = StatWtmp.FindUserLimitInfo ( u_name );
  if ( uli_pr == NULL ) 
  { 
    printf ( "<td colspan=2><Center>No statistic found for the user %s\n", u_name );
    return;
  }
  
  int uli_rowspan ;
  int Devices = uli_pr -> DeviceBase . Size ();
  int Ttys = uli_pr -> TtyBase  . Size ();
  
  uli_rowspan = MAX ( Devices, Ttys ) ;
  if ( uli_rowspan == 0 ) uli_rowspan = 1;
  
  int Tty_rowspan = Ttys? uli_rowspan / Ttys :1 ;
  int Tty_last_rowspan = Ttys? Tty_rowspan + uli_rowspan % Ttys :uli_rowspan;
  int Device_rowspan = Devices? uli_rowspan / Devices : 1; 
  int Device_last_rowspan = Devices? Device_rowspan + uli_rowspan %Devices:uli_rowspan;
  
  // print first row
  printf ( "<td rowspan=%d><center>",uli_rowspan );
  if ( usr_pr -> UserTag != NULL )
    printf ( "%s\n", usr_pr -> UserTag );
  else
    printf ( "not defined\n" );
  
  printf ( "<td rowspan=%d><center>%s\n",uli_rowspan, usr_pr -> UserName );
  
  
  TtyUsageInfo* tui_pr = uli_pr -> TtyBase . base;
  DeviceUsageInfo* dui_pr = uli_pr -> DeviceBase . base;
  
  unsigned long OverallTraffic = 0, OverallUsage =0;
  int i;

  
  for ( i =0; i < uli_rowspan; i++ )
  { 
    if ( i==0 && tui_pr == NULL ) 
      printf ( "<td rowspan=%d colspan=3><center>No information\n", Tty_last_rowspan );
    if ( tui_pr )
    {
      if ( (i % Tty_rowspan) == 0)
      {
        Tag_st* tag_pr = TtyTagsBase. FindTag ( tui_pr -> Line );
        int rs = ( tui_pr -> next == NULL)?Tty_last_rowspan:Tty_rowspan;
      
        if ( tag_pr ) 
          printf ( "<td rowspan=%d><center>%s\n", rs, tag_pr -> value );
        else 
          printf ( "<td rowspan=%d><center>%s\n", rs, tui_pr -> Line );
      
        printf ( "<td rowspan=%d><center>", rs );
       // unsigned long days = tui_pr -> Usage / ( 3600 * 24);
        unsigned long hours = ( tui_pr -> Usage / 3600 ); // % 24;
        unsigned long minutes = ( tui_pr -> Usage / 60 ) % 60;
        unsigned long seconds = ( tui_pr -> Usage %60);
       
        //if ( days )
        //  printf ( "%lu days ", days );
        if ( hours )
          printf ("%lu hours ", hours );
        if ( minutes ) 
          printf ("%lu min ", minutes );
        printf ( "%lu sec (%lu sec overall)\n", seconds, tui_pr -> Usage );
      
        printf ( "<td rowspan=%d><center>",rs );
        printf ("-- Last login:%s", ctime (&tui_pr -> LastLog ));
        if ( tui_pr -> UsageProps & TUI_LOGGED_NOW )
          printf ( "<br>-- Still logged on *)\n" );
        else 
          printf ( "<br>-- Last logout:%s", ctime ( &tui_pr -> LastLogout ));
        if ( tui_pr -> UsageProps & TUI_HAS_CRASHES )
          printf ( "<br><I><B>-- WARNING! Has crashes at the period.</I></B>**)" );
        
        
        OverallUsage += tui_pr -> Usage;
      
        tui_pr = tui_pr -> next ;
      }
    }
    
    // printing out of traffic starts here
    
    if ( i==0 && dui_pr == NULL )
      printf ( "<td rowspan=%d colspan=2><center>No information\n", Device_last_rowspan );
      
    if ( dui_pr )
    {
      if ( (i%Device_rowspan)==0)
      {
      
        int rs = (dui_pr -> next == NULL) ? Device_last_rowspan :Device_rowspan;
      
        printf ( "<td rowspan=%d><center>%s\n", rs, dui_pr -> DeviceName );
      
        printf ( "<td rowspan=%d><center>", rs );
        
        if ( dui_pr -> InTraffic > (1024*1024 )) // print in Mbytes 
          printf ( "%.2fM ( %lu bytes )\n", 
            (float ) dui_pr -> InTraffic / (1024*1024),
            dui_pr -> InTraffic );
        else if ( dui_pr -> InTraffic > 1024 ) // print in kbytes 
          printf ( "%.2fK ( %lu bytes )\n" ,
            (float) dui_pr -> InTraffic / 1024,
            dui_pr -> InTraffic );
        else // print in bytes
          printf ( "%lu bytes\n", dui_pr -> InTraffic );
        
        OverallTraffic += dui_pr -> InTraffic;
        dui_pr = dui_pr -> next;
      }
    }
     
    printf ( "<tr>\n" );
  }
       
  printf ( "<td colspan=2><center>Total for the user:\n" );
  printf ( "<td colspan=3><center>" );

//  unsigned long days = OverallUsage / ( 3600 * 24);
  unsigned long hours = ( OverallUsage / 3600 ); // % 24;
  unsigned long minutes = ( OverallUsage / 60 ) % 60;
  unsigned long seconds = ( OverallUsage %60);

//  if ( days )
//    printf ( "%lu days ", days );
  if ( hours )
    printf ("%lu hours ", hours );
  if ( minutes ) 
    printf ("%lu min ", minutes );
  printf ( "%lu sec ( %lu sec overall )\n", seconds, OverallUsage );
  
  printf ( "<td colspan=2><center>" );
      
  if ( OverallTraffic > (1024*1024 )) // print in Mbytes 
    printf ( "%.2fM ( %lu bytes )\n", 
      (float ) OverallTraffic / (1024*1024),
      OverallTraffic );
  else if ( OverallTraffic > 1024 ) // print in kbytes 
    printf ( "%.2fK ( %lu bytes )\n" ,
      (float) OverallTraffic / 1024,
      OverallTraffic );
  else // print in bytes
    printf ( "%lu bytes\n", OverallTraffic );
    
  return;
}
