#ifndef ___AWREADER_H___
#define ___AWREADER_H___

#pragma interface

#define MAXNACCTENTRYLEN 128

extern time_t LastWtmpCheck;
extern RootWtmp WtmpOverall;

/***********************************************************************

             Wtmp Accounting Tree
             
                        /----------------\
                        | RootWtmp       |
                        \________________/
                                |
               ...   --/--------+----------\--  ....
                       |        |          |
               /-------+------\
UserLimitInfo  | UserLimitInfo|          ...Other UserLimitInfos       
   List        \______________/
                       |
         ...  -/-------+---------\--------- ... Other TtyUsageInfos     
TtyUsageInfo  |                  |
   Lists                 /-------+---------\
                         |  TtyUsageInfo   |
                         +-----------------+
                         |  time_t Usage   |
                         |  time_t LastLog |
                         |  TUI_LOGGED_NOW |
                         |   ...           |
                         \_________________/

        CollectWtmpData

Builds RootWtmp tree, which root is given as rw_pr,
only for users currently encountered in UserRoot global tree
in period from StartTime to EndTime.
  Sets LastWtmpCheck global to current time(). 

In the following it is assumed that CurrMoment = moment of the most
recent WTMP base update by the system. 

  NOTE 1. if CurrMoment is somewhere between StartTime and EndTime,
and a given user was logged on at the moment, TtyUsage structures
will not be flushed, but will be left with flags TUI_LOGGED_NOW
and LastLog set to correct date ( >= StartTime ) correspondent to 
last user logging in ( or = StartTime if earlier ). This mentioned 
above period ( from LastLog till CurrMoment ) _will_not_ be added 
to the TtyUsageInfo.Usage in this case. If user was not logged in
at the CurrMoment, it's usage will be certainly flushed of course :) 
  This condition is typical when calculating, for example, today's 
or current month's usage, when CurrMoment is somewhere in the middle
of the period, and then maintaining it dynamically within the day.
  To Flush it explicitly to given moment is possible by calling 
FlushAll ( RootWtmp*, time_t CurrMoment ). 

  NOTE 2. if CurrMoment < StartTime, the call to that function is pointless :)
WtmpRoot tree will surely not contain a single entry :)

  NOTE 3. if CurrMoment > EndTime. In this case all usages for the period
will be certainly flushed, even if the user is logged in till the present
or till CurrMoment. Typically useful for calculating statistic for the 
month or day in the past. 

  NOTE 4. Global WtmpOverall is an instance of RootWtmp published in
utmpdata module. CollectWtmpData builds it so that it corresponds 
the period (0 .. StartTime). You'll (probably:) will receive the same 
result by CollectWtmpData ( rw_pr, 0l, sometime = StartTime above ).  

  WARNING 1: all RootWtmp tree given will be cleaned up first.
  WARNING 2: So far it is unable to process NEW_TIME or OLD_TIME entries,
    and if the time was being changed at the period checked, statistic could 
    differ from the real one with approximation error equal time correction 
    value, or even could lead to "memory fault" fatals. :) Though, i didnt 
    tried it yet:).  NEW_TIME and OLD_TIME entries are ignored now. :)
  NOTE to WARNING 2. today, with kernel 2.0.8, checked what traces  
  date changing leaves. it seems that mine date -s ... doesnt leave a single
  trace! How is on yours? :) So so far i'm unable to do anything with it..
  and it really does cause considerable errors in time statistics, mainly
  equal to value of time corrections... No segmentation faults, though:)
  WARNING 3: all users being logged in before and after border moment 
    ( e.g. StartTime for WtmpOverall or EndTime for requested period )
    are flushed immediately after border time is detected. Thus , 
    if they have crash point after border time, it will not be noticed 
    for the given accounting period and COUNT_CRASH_TIME will not have 
    any influence for their accumulated usage in expired period.
    But so far i do not think it is being so crucial:)
************************************************************************/

extern int CollectWtmpData ( 
  RootWtmp* rw_pr, // UserRoot-dependent structure to build 
  time_t StartTime, 
  time_t EndTime );

  
/***********************************************************************
    DetermineCurrentDay
    
  Determines the day's start time ( 00.00 am ) and end time (24.00 ) for 
the given CurrMoment. Sets also AbsoluteDayIndex from 1 jan 1970
( absolute index = CurrMoment / ( 24*3600 )  
  
***********************************************************************/      
extern void DetermineCurrentDay ( time_t CurrMoment, time_t& DayStart,
  time_t& DayEnd, long &AbsoluteDayIndex );
  
/***********************************************************************
     5 aug 1996 Added support for nacctd accounting by LD
     CollectNacctd ()  
     
     CollectNacctd acts the same way as CollectWtmpData
     except it accumulates traffic statistic associated
     with user as defined at the last nacctd's log field.
     
     Statistic is accumulated for users given in UserRoot 
     ( excatly as CollectWtmp does ). So far only overall
     statistic is accumulated, not on per-device basis.
************************************************************************/

#ifdef NACCTD_SUPPORT
extern int CollectNacctd ( RootWtmp* rw_pr, time_t StartTime, time_t EndTime);
#endif /*NACCTD_SUPPORT*/

#endif /* AWREADER_H */