#ifndef ___APARSER_H___
#define ___APARSER_H___

#include <netinet/in.h>
#include <arpa/inet.h>
#include "common.h"
#include "memdata.h"
#pragma interface 

#define ERROR_REPORTING /* compile with error hints reporting */

#define QUERYALLOW_KEY "QueryAllow"


extern char* ConfMem; 

// ------------------------------------- main extern pointer -------------------
extern RootBase UserRoot;

// ------------------------------------functions -------------------------------
extern int BuildTimeTable ( UsersTimeTableBody* body );
extern void Oops ( char*,char* );

/***************************************************************************
    this is for QueryAllow
****************************************************************************/

// address in dotted notation
class DottedQuad : public stemListItem
{
  DECLARE_CAST; // -- i guess we neednt this in most cases
public:
  struct in_addr value;

  DottedQuad () { value . s_addr = 0; };

  int LocateLtoR ( char* str, unsigned s, unsigned n );
};

class QueryAllowList : public MonoList < DottedQuad >
{
public:
  QueryAllowList ( ) : MonoList <DottedQuad> ( new Separator (",")) {};
};

class QueryAllowParam : public stemListItem
{
public:
  QueryAllowList AllowList;
  Keyword key;
  
  QueryAllowParam () : key ( QUERYALLOW_KEY ) { };
  
  int LocateLtoR ( char* str, unsigned s, unsigned n )
  { 
    stemStream ss ( str, s, n );
    ss = ss >> &key >> &ComSep() >> &Separator ( "=" ) >>
      &ComSep () >> &Separator ( "{" ) >> &ComSep() >>
      &AllowList >> &ComSep() >> &Separator ( "}" );
    if ( ! ss. is_valid () ) return -1;
    sp =s;
    np = ss . stream_sp;
    return 0;
  };
};
     

#endif /* ___APARSER_H___ */