/*****************************************************************************
        14 Jul 1996 Created by LD
        2  Aug 1996 Implemented as separate module (aparser)
        3  Aug 1996 Added TrafficLimit field implementation
        3  Aug 1996 Added Tty and User Tags 
        16 Aug 1996 Added QueryAllow
******************************************************************************/        
        
        

#pragma implementation
#include "aparser.h"
#include "memdata.h"
// #include "utmpdata.h"
#include "handshakes.h"

#include <unistd.h>
#include <pwd.h>


/***********************************************************************
    this is for QueryAllow
************************************************************************/
IMPLEMENT_CAST1(DottedQuad, stem);
template class MonoList <DottedQuad>;
/****************************************************************************
     DottedQuad locate
****************************************************************************/
int DottedQuad ::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
  stemStream ss ( str, s, n );
  Uns First,Second,Third,Forth;
  ss = ss >> &First >> &Separator ( "." ) >> &Second >>
    &Separator ( "." ) >> &Third >> &Separator ("." )
    >> &Forth;
  if ( ! ss. is_valid () )
  {
#ifndef NO_DEBUG
     Log2 ( 4, "DottedQuad LocateLtoR failed.\n" );
#endif
     return -1;
  }

  // check ranges
  if ( First . value > 255 || Second. value > 255 || Third . value > 255 ||
    Forth . value > 255 )
    return -1; // out of range..

  // read the value
  char tmp [ 17 ];
  if ( ss . stream_sp - s > 16 ) // hopefully, this would never happen
    return -1;

  memcpy ( tmp, &str [ s ], ss . stream_sp -s );
  tmp [ ss . stream_sp - s ] = 0; // fix it

  // reading now the real value
  value . s_addr = inet_addr ( tmp );

  // likely all is okay
  sp = s; np = ss. stream_sp;

  return 0;
}

/**************************************************************************/



char ModuleName [] = "aparser";


char* ConfMem;

struct Handshake_st ModuleSig = { APARSER_SIG, VERSION };  // module signature 
struct Handshake_st RespSig;

static int Parse ( stemStream& );
static int BuildTtyTags ( TtyTags&);
// static int BuildUserTags ( UserTags&);
static int BuildDraconian ( DraconianTtyParam* );
static int BuildQueryAllow ( QueryAllowParam* );


static TagBase TtyTagsBase;
static unsigned short Port;
static unsigned CheckGranularity;
static unsigned RereadGranularity;
static int MaxChildren;

/********************************************************************
	Generates an error message
	!Attention! relies upon extern variable ConfMem
********************************************************************/
#define NEW_STR "\n\r" /* what use to reset pos counter */
#define NEW_LINE '\n'
void Oops ( char* where, char* MessText )
{
	unsigned long errpos = where - ConfMem; // probably will fail for configs greater than 64k

	unsigned long line = 0, pos = 0, curpos, LineStartPos = 0;
	for ( curpos = 0; curpos <= errpos; curpos ++ )
	{
		if ( strchr ( NEW_STR, ConfMem [ curpos ] ) )
		{
			pos = 0;
			LineStartPos=curpos;
		}
		else pos ++;
		if ( ConfMem[ curpos ] == NEW_LINE )
			line ++;
	}
	
	int dl;
	if ( strstr ( MessText, "fatal" ) )
	  dl=1;
	else dl = 2;
	
	Log2 ( dl, "%ld,%ld:",pos, line +1 );
//	MessageBox ( NULL, tmp, "Error...", MB_OK );
//	MessageBox ( NULL, MessText, "Error Message", MB_OK );
	LOG(dl, MessText );

}


int /* OwlMain */ main ( int, char** )
{	
        // 1. First , trying out to establish contact with admind 
        FILE* PipeOut = stdout;
        FILE* PipeIn = stdin;

#ifndef NO_DEBUG
	LOG (4, "aparser: sending signature\n" );
#endif
	        
        if ( 1 != fwrite ( (void* )&ModuleSig, sizeof ( ModuleSig ), 1, 
          PipeOut  ) )
        {
          LOG ( 1, "aparser: broken pipe\n" );
          exit ( 1 );
        }

        fflush ( PipeOut );
        
#ifndef NO_DEBUG
	LOG (4, "aparser: signature is sent, waiting for admind's sig\n" );
#endif
	        
        // 2. waiting for response module sig 
        if ( 1 != fread ( (void* )&RespSig, sizeof ( RespSig ), 1,
         PipeIn ) )
        {
          LOG ( 1, "aparser: Fatal error while handshaking\n" );
          exit ( 1 );
        }
        
        // 3. analyze the response 
        if ( memcmp ( (void* )RespSig. ModuleSig, ADMIND_SIG, 2 ) )
        {
          LOG ( 1, "aparser: wrong module signature from admind\n" );
          exit ( 1 );
        }
        if ( RespSig . version != VERSION ) 
        {
          LOG ( 1, "aparser: wrong admind version\n" );
          exit ( 1 );
        }
        
#ifndef NO_DEBUG
	LOG(4, "aparser: signature is read and checked okay, proceeding..\n" );
#endif
	        
        // seemingly all is okay
     
	FILE* ConfFile ;
	unsigned ConfSize;

        if ( NULL == ( ConfFile = fopen ( CONF_FILE, "r" ) ) )
        { 
          LOG ( 1 , "aparser Fatal: Unable to open configuration file\n" );
          exit ( 1 );
        }

	fseek ( ConfFile, 0, SEEK_END );
	ConfSize = ftell ( ConfFile );
	fseek ( ConfFile, 0, SEEK_SET );

	if ( NULL ==  ( ConfMem = (char* )malloc ( ConfSize ) ) )
	{
		return -1;
	}

	if ( 1 != fread ( ConfMem, ConfSize, 1, ConfFile ) )
	{
		return -1;
	}

	fclose ( ConfFile );


	stemStream ss ( ConfMem, 0, ConfSize );
  	if ( Parse ( ss ) )
  	{
  	  Log2 (1, "aparser fatal:error while parsing conf or building in-mems.\n" );
  	  free ( ConfMem );
  	  exit  (1 );
  	}

#ifndef NO_DEBUG
	LOG ( 4, "aparser: Parse Okay\n");
#endif	 

#ifndef NO_DEBUG 
	LOG ( 4 , "aparser: Build Okay\n" );
#endif	
	
	if ( UserRoot . SendToStream ( PipeOut ) ||
//	  UserTagsBase . SendToStream ( PipeOut ) ||
	  TtyTagsBase . SendToStream ( PipeOut ) ||
	  1 != fwrite ( (void* ) &MaxChildren, sizeof ( MaxChildren ), 1, PipeOut)||
	  1 != fwrite ( (void* ) &Port, sizeof (Port),1,PipeOut ) ||
	  1 != fwrite ( (void* ) &CheckGranularity, sizeof ( CheckGranularity ),
	    1, PipeOut ) ||
	  1 != fwrite ( (void* ) &RereadGranularity, sizeof ( RereadGranularity),
	    1, PipeOut ))
	{
	  LOG (1, "aparser fatal:Error while writin' to admind!\n" );
	  exit ( 1 );
	}
        fflush ( PipeOut );
	fclose ( PipeIn );
	fclose ( PipeOut );
	return 0;
}	

#define USERTIMETABLE_DETECTED (1u)
// #define USERTAGS_DETECTED (1u<<1)
#define TTYTAGS_DETECTED ( 1u<<2)
#define PORT_DETECTED ( 1u<<3)
#define CHECKGRAN_DETECTED ( 1u <<4 )
#define REREADGRAN_DETECTED ( 1u<<5 )
#define DRACONIAN_DETECTED (1u<<6 )
#define QUERYALLOW_DETECTED (1u<<7)
#define MAXCHILDREN_DETECTED ( 1u<<8)

// 6.aug.96 UserTags support removed.

static int Parse ( stemStream& ss )
{

  stemStream curr_ss = ss;

  UsersTimeTablePair uttp;
  TtyTags tt;
  PortParam pp;
  MaxChildrenParam mcp;
  CheckGranParam cgp;
  RereadGranParam rgp;
  DraconianTtyParam dtp;
  QueryAllowParam qap;
  
  unsigned DetectionFlag = 0;
  
  // 1. strip Common separtor at the begining
  
   curr_ss=ss=ss>>&ComSep();
  
  do
  {
    // curr_ss= ss =ss >> &ComSep();
    // 1. trying out for usertimetable
#ifndef NO_DEBUG
    Log2 ( 5, "Parse():continuing with symbol %c\n", ss.str [ ss.stream_sp] );
#endif
    if ( (curr_ss=ss >> &uttp) . is_valid())
    {
      if ( DetectionFlag & USERTIMETABLE_DETECTED ) 
      {
        Oops ( &ss .str [ ss. stream_sp ], 
          "aparser fatal: Users time table is detected more than once.\n" );
        return -1;
      }
      DetectionFlag |= USERTIMETABLE_DETECTED;
      // uttp is detected okay
      if ( BuildTimeTable ( uttp.Rvalue -> body ) )
      {
        Log2 (2,"aparser fatal: Unable to build in-mem representation for user time table\n");
        return -1;
      }
#ifndef NO_DEBUG
      Log2 ( 4,"aparser:users time table is detected  and built okay\n" );
#endif
      ss = curr_ss;
      continue;
    } 
    else if ( (curr_ss=ss>>&tt).is_valid() )
    {
      if ( DetectionFlag & TTYTAGS_DETECTED )
      {
        Oops ( &ss. str [ ss.stream_sp ],
          "aparser fatal: Tty tags are detected more than once.\n" );
        return -1;
      }
      DetectionFlag |= TTYTAGS_DETECTED;
      // tty tags are detected
      if ( BuildTtyTags (tt))
      {
        Log2 ( 1, "aparser: unable to build tty tags\n" );
        return -1;
      }
#ifndef NO_DEBUG      
      Log2 ( 4, "aparser: tty tags are detected and built okay\n" );       
#endif 
      ss = curr_ss;
      continue;
    }
    else if ( (curr_ss=ss>>&mcp). is_valid() )
    {
      // MaxChildrenParam detected
      if ( DetectionFlag & MAXCHILDREN_DETECTED )
      {
        Oops ( &ss . str [ ss.stream_sp ], 
          "aparser fatal: MaxChildren parameter is detected more than once.\n");
        return -1;
      }
      MaxChildren = mcp . Rvalue -> value;
      if ( MaxChildren > 128 || MaxChildren < 1 )
      {
        Oops ( &ss . str [ ss.stream_sp ],
        "aparser fatal: unreal MaxChildren parameter value. Are you sure?\n" );
        return -1;
      }
      DetectionFlag |= MAXCHILDREN_DETECTED;
      ss=curr_ss;
    }
    else if ( (curr_ss=ss >> &pp ). is_valid() )
    {
      // port parameter detected
      
      if ( DetectionFlag & PORT_DETECTED )
      {
        Oops ( &ss .str [ ss.stream_sp ],
          "aparser fatal: port parameter is detected more than once.\n" );
        return -1;
      }
      Port = pp . Rvalue -> value;
      
      DetectionFlag |= PORT_DETECTED;
      ss = curr_ss;
    }
    else if ( (curr_ss=ss>>&cgp) . is_valid() )
    {
      // check granularity parameter detected. 
      if ( DetectionFlag & CHECKGRAN_DETECTED )
      {
        Oops ( & ss.str [ ss.stream_sp ],
          "aparser fatal: CheckGranularity parameter is detected more than once.\n" );
        return -1;
      }
      
      CheckGranularity = cgp. Rvalue -> value;
      DetectionFlag |= CHECKGRAN_DETECTED;
      ss = curr_ss;
    }
    else if ( (curr_ss=ss>>&rgp).is_valid() )
    {
      // reread granularity parameter is detected.
      if ( DetectionFlag & REREADGRAN_DETECTED )
      {
        Oops ( &ss.str [ ss.stream_sp ],
          "aparser fatal: RereadGranularity parameter is detected more than once.\n" );
        return -1;
      }
      
      RereadGranularity = rgp. Rvalue -> value;
      DetectionFlag |= REREADGRAN_DETECTED;
      ss= curr_ss;
    }
    else if ( (curr_ss=ss>>&dtp).is_valid () )
    {
      if ( DetectionFlag & DRACONIAN_DETECTED )
      {
        Oops ( &ss.str [ ss.stream_sp ],
          "aparser fatal: DraconianTtys record is detected more than once.\n" );
        return -1;
      }
      DetectionFlag |= DRACONIAN_DETECTED;
      BuildDraconian( &dtp );
      ss=curr_ss;
    }
    else if ( (curr_ss=ss>>&qap).is_valid())
    {
      if ( DetectionFlag & QUERYALLOW_DETECTED)
      {
        Oops  ( &ss.str [ ss.stream_sp ],
          "aparser fatal:QueryAllow is detected more than once.\n" );
        return -1;
      }
      DetectionFlag |= QUERYALLOW_DETECTED;
      BuildQueryAllow ( &qap );
      ss=curr_ss;
    }
    else        
    {
      Oops ( & ss .str [ ss .stream_sp ], 
        "aparser fatal: it's neither of definitions expected.\n" );
      return -1;
    }
  } while ( (curr_ss=ss=curr_ss >> &ComSep()),( ! ( ss == 0 ) ));

  // check if all elements are detected 
  if ( ! (DetectionFlag & USERTIMETABLE_DETECTED) )
  {
    Log2 ( 1, "aparser fatal: Users time table is an obligatory definition.\n");
    return -1;
  }
  if ( ! ( DetectionFlag & MAXCHILDREN_DETECTED ))
  {
    Log2 ( 1, "aparser fatal: MaxChilren is an obligatory definition.\n" );
    return -1;
  }
  if ( ! ( DetectionFlag & PORT_DETECTED ))
  {
    Log2 ( 1, "aparser fatal: Port parameter is an obligatory definition.\n" );
    return -1;
  }
  if ( ! ( DetectionFlag & CHECKGRAN_DETECTED))
  {
    Log2 ( 1, "aparser fatal:CheckGranularity parameter is an obligatory definition.\n" );
    return -1;
  }
  if ( ! ( DetectionFlag & REREADGRAN_DETECTED ))
  { 
    Log2 ( 1, "aparser fatal: RereadGranularity parameter is an obligatory definition.\n" );
    return -1;
  }
  if ( ! ( DetectionFlag & QUERYALLOW_DETECTED ))
  {
    Log2 ( 1, "aparser fatal: QueryAllow parameter is an obligatory definition.\n" );
    return -1;
  }  

    
  
  return 0;

}

	
/* ---------------------------------------------------------------------------- */

RootBase UserRoot;

static User_st* BuildUser( char* UserName, UsersTimeTableItem* );
static void BuildDay ( User_st* user_pr, int DayTag, UsersTimeTableItem* );

int BuildTimeTable ( UsersTimeTableBody* body )
{
	/* 1. check UserRoot, if it is not empty , empty it */
	while ( UserRoot . tail ) delete UserRoot.tail ;

	// get first first entry in table list , if any
	UsersTimeTableItem* TableItem_pr;
	User_st /* *User_pr,*/ *startUser_pr =  NULL;


 	for  (
		TableItem_pr =DOWNCAST_MOSTDERIVED ( body -> base.base, UsersTimeTableItem);
		TableItem_pr;
		TableItem_pr = DOWNCAST_MOSTDERIVED (TableItem_pr -> next, UsersTimeTableItem )
	)
	{
		UserNameList* unl_pr = DOWNCAST ( TableItem_pr -> uf_pr -> value, UserNameList );
		if ( unl_pr )
		{
			// it is a new user list here ..
			UserName* username_pr =
				DOWNCAST_MOSTDERIVED ( unl_pr -> base. base, UserName) ;
			// remember first user structure in this table item
			startUser_pr = BuildUser ( username_pr -> value, TableItem_pr );
			for (
				username_pr = DOWNCAST_MOSTDERIVED (username_pr -> next, UserName );
				username_pr;
				username_pr = DOWNCAST_MOSTDERIVED(username_pr -> next, UserName) )

				// builds memory instances according to user name
				BuildUser ( username_pr -> value, TableItem_pr );
		}
		Star* star_pr = DOWNCAST ( TableItem_pr -> uf_pr -> value, Star );
		if ( star_pr )
		{
			if ( startUser_pr == NULL )
			{
			  Log2 ( 1,"aparser: in users time-table:none users configured above to replace a '*'.\n" );
			  Log2 ( 1,"aparser: whole users time-table entry for '*' is ignored.\n" );
			  break;
			}
			User_st* currUser_pr;
			for ( currUser_pr = startUser_pr; currUser_pr;
				currUser_pr = currUser_pr -> next )

				BuildUser ( currUser_pr -> UserName, TableItem_pr );
		}
	}
	// 6 aug 1996 -- added UserTag field -- UserTags replacement
	// check whether users are really ones
	struct passwd* pe_pr;
	User_st* usr_pr;
	for ( usr_pr =  UserRoot . base;
	  usr_pr;
	)
	{
	  pe_pr = getpwnam ( usr_pr -> UserName );
	  if ( pe_pr == NULL )
	  {
	    Log2 ( 1, "aparser: User %s is not a user of the host, ignored.\n",
	      usr_pr -> UserName );
	    User_st* usr_tmp_pr = usr_pr -> next;
	    delete usr_pr;
	    usr_pr = usr_tmp_pr;
	    continue;
	  }
	  // okay, user exists
	  // rember its tag
	  int mem_needed = strlen ( pe_pr -> pw_gecos );
	  if ( mem_needed )
	  {
	    usr_pr -> UserTag = new char [ mem_needed + 1 ];
	    memcpy ( (void*) usr_pr -> UserTag, (void*) pe_pr -> pw_gecos,
	      mem_needed + 1 );
	  }
	  
	  usr_pr = usr_pr -> next;
	}
	return 0;
}

static User_st* BuildUser ( char* UserName, UsersTimeTableItem * TableItem_pr )
{
	User_st* currUser_pr;

	// first, we should find out whether the user entry already exists
	currUser_pr = UserRoot . FindUser ( UserName );
	if ( currUser_pr == NULL )
		currUser_pr = UserRoot. AddUser ( UserName );

	if ( !currUser_pr ) return currUser_pr; // fatal, but hopefully should not appear ...

	// thus, currUser_pr has initialized, start to add values to structures
	DaysList* DaysList_pr = DOWNCAST ( TableItem_pr ->df_pr -> value, DaysList );
	if ( DaysList_pr )
	{
		// it is a days list
		DayOfWeekInterval *DayInterval_pr;
		DayOfWeek *DayOfWeek_pr;
		stemListItem* item_pr;
		for ( item_pr = DaysList_pr -> base . base;
			item_pr; item_pr = item_pr -> next )
		{
			DayOfWeek_pr = DOWNCAST ( item_pr, DayOfWeek ); // whether it is DayOfWeek
			DayInterval_pr = DOWNCAST ( item_pr, DayOfWeekInterval );// whether it is an interval
			if ( DayOfWeek_pr )
			{
				BuildDay ( currUser_pr, DayOfWeek_pr -> value, TableItem_pr );
			}
			if ( DayInterval_pr )
			{
				int i;
				for ( i = DayInterval_pr -> Lvalue -> value;
					i <= DayInterval_pr -> Rvalue -> value ;
					i++
				)
					BuildDay ( currUser_pr, i, TableItem_pr );
			}
		}
	}
	AnyStem* Any_pr = DOWNCAST ( TableItem_pr ->df_pr -> value, AnyStem ) ;
	if ( Any_pr )
	{
		currUser_pr -> UserProps |= US_ANYDAY;

		// make a copy for every day in a week
		// ( correct me plz if week doesnt start on monday
		// but on sunday somewhere :=)

		int i;
		for ( i = SUNDAY_VAL; i <= SATURDAY_VAL; i++ )
			BuildDay ( currUser_pr, i, TableItem_pr );
	}

	// 2. if given su field, take it into account
	if ( TableItem_pr -> sf_pr ) // there is su field given
		currUser_pr -> UserProps |= US_SU;

	return currUser_pr;
}


static void BuildDay ( User_st* user_pr, int DayTag, UsersTimeTableItem*
	TableItem_pr )
{
	Day_st* currDay_pr;

	// check whether the day exists for the user
	currDay_pr = user_pr -> FindDay ( DayTag );
	if ( currDay_pr == NULL )
		currDay_pr = user_pr -> AddDay ( DayTag );
	if ( currDay_pr == NULL )
		return ; // fatal but hopefully should not happen

	// thus, at this point currDay_pr is defined to appropriate Day_st struct

	// now should define time interval, day limit and ttyss for the day
	// First, setting up the limit. if limit exists, just add new one
	UnlStem* Unlimited_pr = DOWNCAST ( TableItem_pr-> dlf_pr -> value, UnlStem );
	TimeOfDay* Limit_pr = DOWNCAST ( TableItem_pr -> dlf_pr -> value, TimeOfDay ) ;
	if ( Unlimited_pr )
		currDay_pr -> DayProps |= DAY_UNLIMITED;
	if ( Limit_pr )
	{
		// DayLimit = how to recalculate ??? <-- to be inserted
		currDay_pr -> HourLimit += Limit_pr -> Lvalue -> value; // hours
		currDay_pr -> MinLimit += Limit_pr -> Rvalue -> value; // minutes
		// and recalculate here!
		// 3 Aug 96: apparently this way: ( DayLimit in seconds ):
                currDay_pr -> DayLimit += 
                  (( Limit_pr -> Lvalue -> value * 60 ) +
                  Limit_pr -> Rvalue -> value ) * 60;
                
	}
	
	// And the traffic limit field, 3 Aug 96
	Unlimited_pr = DOWNCAST_MOSTDERIVED ( TableItem_pr -> tl_pr -> value, UnlStem );
	UnsBytes* UnsBytes_pr = DOWNCAST_MOSTDERIVED ( 
	  TableItem_pr -> tl_pr -> value, UnsBytes );
	if ( Unlimited_pr )
	  currDay_pr -> DayProps |= DAY_TRAFFIC_UNLIMITED;
	if ( UnsBytes_pr )
	  currDay_pr -> TrafficLimit += UnsBytes_pr -> value;
	
	// second, timeofday intervals -- valid intervals
	AnyStem* Any_pr = DOWNCAST ( TableItem_pr -> if_pr -> value, AnyStem );
	TimeOfDayIntervalList* IntervalList_pr =
		DOWNCAST ( TableItem_pr -> if_pr -> value, TimeOfDayIntervalList );
	if ( Any_pr )
		currDay_pr -> DayProps |= DAY_ANYTIME;
	if ( IntervalList_pr )
	{
		TimeOfDayInterval* Interval_pr;
		for (
			Interval_pr = DOWNCAST_MOSTDERIVED ( IntervalList_pr -> base . base,
				TimeOfDayInterval);
			Interval_pr;
			Interval_pr = DOWNCAST_MOSTDERIVED ( Interval_pr -> next, TimeOfDayInterval)
		)
			currDay_pr -> AddInterval ( // all in seconds from a day start
				60 * (Interval_pr -> Lvalue -> Lvalue -> value * 60 +
				Interval_pr -> Lvalue -> Rvalue -> value ),
				60 *  ( Interval_pr -> Rvalue -> Lvalue -> value * 60 +
				Interval_pr -> Rvalue -> Rvalue -> value )
			);
	}
	// third, tty
	Any_pr = DOWNCAST ( TableItem_pr -> tlf_pr -> value, AnyStem );
	TtyList* ttylist_pr = DOWNCAST ( TableItem_pr -> tlf_pr -> value, TtyList );
	if ( Any_pr )
		currDay_pr -> DayProps |= DAY_ANYTTY;
	if ( ttylist_pr )
	{
		Word* tty_pr;
		for ( tty_pr = DOWNCAST_MOSTDERIVED ( ttylist_pr -> base . base, Word );
			tty_pr;
			tty_pr = DOWNCAST_MOSTDERIVED ( tty_pr -> next, Word )
		)
		{
			char tty [ UT_LINESIZE +1 ];
			memcpy ( tty, &ConfMem[tty_pr -> sp],
				MIN ( UT_LINESIZE, tty_pr -> np - tty_pr -> sp ));
			tty [ MIN ( UT_LINESIZE, tty_pr -> np - tty_pr -> sp ) ] = 0; // fix it
			if ( currDay_pr -> FindTty ( tty ) )
				continue;
			currDay_pr -> AddTty ( tty );
		}
	}
	// Dat's all, seemingly :-(

}


/***************************************************************************
    Building Tty and User tags -- added by LD 3 Aug 96
***************************************************************************/

static int BuildTtyTags ( TtyTags& tt )
{
  // clear TtyTagsBase
  while ( TtyTagsBase . tail ) delete TtyTagsBase . tail ;
  TagBody* body_pr = tt . Rvalue;
  TagItem* item_pr;
  for (
    item_pr = DOWNCAST_MOSTDERIVED ( body_pr -> base . base, TagItem);
    item_pr;
    item_pr = DOWNCAST_MOSTDERIVED ( item_pr -> next, TagItem )
  )
  {
    Tag_st* tag_pr = new Tag_st;
    TtyTagsBase . Add ( tag_pr );
    strcpy (tag_pr -> name, item_pr -> name );
    strcpy ( tag_pr -> value, item_pr -> value );
#ifndef NO_DEBUG
    Log2 ( 4, "aparser: BuildTtyTags: tag is added.\n" );
#endif        
  }
  return 0;
}

/***************************************************************************
   DraconianTty rules support: added on 15 aug 96
***************************************************************************/

int BuildDraconian  ( DraconianTtyParam* dtp_pr )
{
   while ( UserRoot.DraconianBase .tail ) 
     delete UserRoot.DraconianBase .tail; // make sure all is cleaned up
     
   Word* w_pr;
   for ( w_pr = DOWNCAST_MOSTDERIVED ( dtp_pr -> ttylist -> base.base , Word );
     w_pr ;
     w_pr = DOWNCAST_MOSTDERIVED ( w_pr -> next,Word )
   )
   {
     char tmp [ UT_NAMESIZE + 1 ];
     memcpy ( (void*) tmp, &ConfMem [ w_pr -> sp ],
       MIN ( w_pr -> np - w_pr -> sp, UT_NAMESIZE ) );
     tmp [ MIN ( w_pr -> np - w_pr-> sp, UT_NAMESIZE ) ] = 0;
     UserRoot . AddDraconianTty(tmp );
   }
   return 0;
}
/***************************************************************************
   QueryAllow rules support: added 16 aug 
***************************************************************************/

int BuildQueryAllow ( QueryAllowParam* qap_pr )
{
  while ( UserRoot.AllowBase . tail )
    delete UserRoot.AllowBase.tail;
  DottedQuad* dq_pr;
  for ( dq_pr = DOWNCAST_MOSTDERIVED ( qap_pr -> AllowList .base.base, DottedQuad);
    dq_pr;
    dq_pr = DOWNCAST_MOSTDERIVED ( dq_pr -> next, DottedQuad )
  )
  {
    UserRoot.AddAllow ( dq_pr -> value . s_addr );
  }
  return 0;
}

/***************************************************************************
***************************************************************************/


/***************************************************************************
***************************************************************************/
