/***************************************************************************
        AnReader Header file ( Admind's nacctd reader )
        3  Aug 1996 Created.
****************************************************************************/
#ifndef ___ANREADER_H___
#define ___ANREADER_H___
#pragma interface
#include "parse.h"
#include "utmpdata.h"
#include <netinet/in.h>
#include <arpa/inet.h> // which of them?
#include <utmp.h>

//#define MAXDEVICELEN 15
#define MAXUSERNAMELEN UT_NAMESIZE 

/***************************************************************************
              Service classes (primitives) that may need for nacctd logs
              parsing
****************************************************************************/

// address in dotted notation
class DottedQuad : public stemListItem
{
 // DECLARE_CAST; // -- i guess we neednt this in most cases
public:
  struct in_addr value;
  
  DottedQuad () { value . s_addr = 0; };
  
  int LocateLtoR ( char* str, unsigned s, unsigned n );
};
  

/***************************************************************************
          class that defines nacctd log entry ( YOU MAY 
          WANT TO CUSTOMIZE PARSING RULES TO MATCH YOUR 
          NACCTD LOG FRAMEWORKS, see also  your  nacctd 
          readmes :)
          Just comment out those defines below that corresponds
          those fields that do not appear in your nacctd logs
          
          WARNING1: time stamp (the first ) field 
          in your nacctd logs should be in numeric form,
          not in human readable ( see nacctd's readme for 
          more information), or all things would very likely 
          appear broken.
          
          WARNING2: YOO SHOULD HAVE AT LEAST THE FOLLOWING 
          FIELDS IN YOUR NACCTD'S LOGS APPEARED, OR ALL NACCTD
          STATISTIC WILL BE SURELY BROKEN IN ADMIND:
            -- time stamp
            -- size
            -- associated user name.
          Without time stamp and associated user name you even will not
          be able to compile the source.
****************************************************************************/
//#define _NACCTD_TIMESTAMP
//#define _NACCTD_PROTONO
//#define _NACCTD_SOURCEIP
//#define _NACCTD_SOURCEPORT
//#define _NACCTD_DESTIP
//#define _NACCTD_DESTPORT
//#define _NACCTD_PACKETCOUNT
//#define _NACCTD_SIZE
//#define _NACCTD_DEVICE
//#define _NACCTD_USERNAME

class NacctdEntry : public stemListItem
{
public:
  // in order of apearence in nacctd log entry:
  UnsLong* 	TimeStamp; // time stamp
  Uns* 		ProtoNo; // the protocol number
  DottedQuad*	SourceIp; // Source ip address 
  Uns*		SourcePort;
  DottedQuad*	DestIp; // Dest ip address
  Uns*		DestPort;
  Uns*		PacketCount; // probably here UnsLong is needed? 
  UnsLong*	Size; // transfer size
  Word*		Device; // interface name
  Word*		UserName; // username. should be less than or = UT_NAMESIZE
  
  NacctdEntry () : 
    TimeStamp (NULL), ProtoNo(NULL), SourceIp(NULL),SourcePort(NULL),
    DestIp(NULL), DestPort(NULL), PacketCount(NULL),Size(NULL),Device(NULL),
    UserName(NULL) 
  {};
  virtual ~NacctdEntry()
  {
    if ( TimeStamp ) delete TimeStamp;
    if ( ProtoNo ) delete ProtoNo;
    if ( SourceIp ) delete SourceIp;
    if ( SourcePort ) delete SourcePort;
    if ( DestIp ) delete DestIp;
    if ( DestPort ) delete DestPort;
    if ( PacketCount ) delete PacketCount;
    if ( Size ) delete Size;
    if ( Device ) delete Device;
    if ( UserName ) delete UserName;
  };
  
  int LocateLtoR ( char* str, unsigned s, unsigned n );    
    
};
  

/***************************************************************************

****************************************************************************/

/***************************************************************************

****************************************************************************/

/***************************************************************************

****************************************************************************/

/***************************************************************************

****************************************************************************/

/***************************************************************************

****************************************************************************/

#endif /* ___ANREADER_H___ */