/****************************************************************************
        ANReader.cpp Nacctd's logs parse module (C) by LD
        3  Aug 1996 Created by LD

****************************************************************************/
#include <unistd.h>
#pragma implementation
#include "anreader.h"
#include "common.h"

/****************************************************************************
     DottedQuad locate
****************************************************************************/
int DottedQuad ::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
  stemStream ss ( str, s, n );
  Uns First,Second,Third,Forth;
  ss = ss >> &First >> &Separator ( "." ) >> &Second >> 
    &Separator ( "." ) >> &Third >> &Separator ("." )
    >> &Forth;
  if ( ! ss. is_valid () ) 
  {
#ifndef NO_DEBUG
     Log2 ( 4, "DottedQuad LocateLtoR failed.\n" );
#endif
     return -1;
  }
  
  // check ranges 
  if ( First . value > 255 || Second. value > 255 || Third . value > 255 ||
    Forth . value > 255 )
    return -1; // out of range..
    
  // read the value
  char tmp [ 17 ];
  if ( ss . stream_sp - s > 16 ) // hopefully, this would never happen
    return -1;
  
  memcpy ( tmp, &str [ s ], ss . stream_sp -s );
  tmp [ ss . stream_sp - s ] = 0; // fix it
  
  // reading now the real value 
  value . s_addr = inet_addr ( tmp );
  
  // likely all is okay
  sp = s; np = ss. stream_sp;

  return 0;
}

/****************************************************************************
  NacctdEntry locate 
****************************************************************************/
int NacctdEntry ::
LocateLtoR ( char* str, unsigned s, unsigned n )
{
  // make sure objects if any would not be lost 
  
#ifdef _NACCTD_TIMESTAMP  
  if ( !TimeStamp ) TimeStamp = new UnsLong;
#endif
#ifdef _NACCTD_PROTONO  
  if ( !ProtoNo ) ProtoNo = new Uns;
#endif  
#ifdef _NACCTD_SOURCEIP
  if ( !SourceIp ) SourceIp = new DottedQuad;
#endif
#ifdef _NACCTD_SOURCEPORT  
  if ( !SourcePort ) SourcePort = new Uns;
#endif
#ifdef _NACCTD_DESTIP  
  if ( !DestIp ) DestIp = new DottedQuad ;
#endif
#ifdef _NACCTD_DESTPORT  
  if ( !DestPort ) DestPort = new Uns;
#endif
#ifdef _NACCTD_PACKETCOUNT  
  if ( !PacketCount ) PacketCount = new Uns;
#endif
#ifdef _NACCTD_SIZE  
  if ( !Size ) Size = new UnsLong;
#endif
#ifdef _NACCTD_DEVICE  
  if ( !Device ) Device = new Word;
#endif
#ifdef _NACCTD_USERNAME  
  if ( !UserName ) UserName = new Word;
#endif  

  // parse it 
  stemStream ss ( str, s, n );
  ss = ss >>  
  
#ifdef _NACCTD_TIMESTAMP  
#ifndef NO_DEBUG
    TimeStamp >> &ComSep();
    if ( !ss . is_valid () )
      Log2 ( 2, "NacctdEntry::LocateLtoR: TimeStamp parse failed.\n" );
    ss = ss >>
#else
    TimeStamp >> &ComSep() >>
#endif    
#endif

#ifdef _NACCTD_PROTONO  
#ifndef NO_DEBUG
    ProtoNo >> &ComSep();
    if ( ! ss. is_valid() )
      Log2 ( 2, "NacctdEntry:: LocateLtoR: ProtoNo parse failed.\n" );
    ss = ss >>
#else   
    ProtoNo >> &ComSep() >>
#endif    
#endif  

#ifdef _NACCTD_SOURCEIP
#ifndef NO_DEBUG
    SourceIp >> &ComSep();
    if ( !ss. is_valid() )
      Log2 ( 2, "NacctdEntry:: LocateLtoR: SourceIp parse failed.\n" );
    ss = ss >>
#else
    SourceIp >> &ComSep() >>
#endif    
#endif

#ifdef _NACCTD_SOURCEPORT  
#ifndef NO_DEBUG
    SourcePort >> &ComSep();
    if ( !ss . is_valid() )
      Log2 ( 2, "NacctdEntry:: LocateLtoR: SourcePort parse failed.\n" );
    ss= ss>>
#else
    SourcePort >> &ComSep() >>
#endif    
#endif

#ifdef _NACCTD_DESTIP  
#ifndef NO_DEBUG
    DestIp >> &ComSep();
    if ( !ss . is_valid() )
      Log2 ( 2, "NacctdEntry:: LocateLtoR: DestIp parse failed.\n" );
    ss=ss>>
#else
    DestIp >> &ComSep() >>
#endif    
#endif

#ifdef _NACCTD_DESTPORT  
#ifndef NO_DEBUG
    DestPort >> &ComSep();
    if ( ! ss. is_valid () )
      Log2 ( 2, "NacctdEntry:: LocateLtoR: DestPort parse failed.\n" );
    ss=ss>>
#else
    DestPort >> &ComSep() >>
#endif    
#endif

#ifdef _NACCTD_PACKETCOUNT  
#ifndef NO_DEBUG
    PacketCount >> &ComSep();
    if ( ! ss. is_valid () ) 
      Log2 ( 2, "NacctdEntry:: LocateLtoR: PacketCount parse failed.\n" );
    ss = ss>>
#else    
    PacketCount >> &ComSep() >>
#endif    
#endif

#ifdef _NACCTD_SIZE  
#ifndef NO_DEBUG
    Size >> &ComSep();
    if ( ! ss. is_valid () )
      Log2 ( 2, "NacctdEntry:: LocateLtoR: Size parse failed.\n" );
    ss = ss>>
#else
    Size >> &ComSep() >>
#endif    
#endif

#ifdef _NACCTD_DEVICE  
#ifndef NO_DEBUG
    Device >> &ComSep();
    if ( ! ss. is_valid () )
      Log2 ( 2, "NacctdEntry:: LocateLtoR: Device parse failed.\n" );
    ss = ss>>
#else
    Device >> &ComSep() >>
#endif    
#endif

#ifdef _NACCTD_USERNAME  
    UserName;
#ifndef NO_DEBUG
    if ( ! ss.is_valid () )
      Log2 ( 2, "NacctdEntry:: LocateLtoR: UserName parse failed.\n " );
#endif    
#endif  
  
  if ( ! ss . is_valid () ) 
  {
#ifndef NO_DEBUG
    Log2 ( 4, "NacctdEntry::LocateLtoR: common parse failed.\n" );
#endif      
    return -1;
  }
    
  // now check some values.. 
#ifdef _NACCTD_DEVICE  
  if ( Device -> np - Device -> sp > MAXDEVICELEN )
  {
#ifndef NO_DEBUG
    Log2 ( 2, "NacctdEntry:: LocateLtoR: device field length is too big to store.\n" );
#endif      
    return -1; // out of range 
  }
#endif
#ifdef _NACCTD_USERNAME
  if ( UserName -> np - UserName ->sp > MAXUSERNAMELEN )
  {
#ifndef NO_DEBUG
    Log2 (2, "NacctdEntry:: LocateLtoR: Username field length is too big to store.\n" );  
#endif    
    return -1; // out of range     
  }
#endif

  // all is okay seemingly
  sp = s; np = ss . stream_sp;    
  return 0;
}

/****************************************************************************
****************************************************************************/

/****************************************************************************
****************************************************************************/


/****************************************************************************
****************************************************************************/

/****************************************************************************
****************************************************************************/




