#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdlib.h>
#include <utmp.h>

#include "memdata.h"

// return codes are as follows:
// 127 -- admind is not running or connect error or other error
// 0 = user okay
// 1 = user access denied 

#define ALC_AUTH_ADDR "localhost"

char ModuleName [] = "alchecker";

static struct Handshake_st ModuleSig = { LOGIN_SIG, VERSION }, RespSig;
static int sock;
static FILE* fsock;

static int ConnectToAdmind ();

int main ( int argc, char** argv )
{
  char Line [ UT_LINESIZE + 1 ];
  char UserName [ UT_NAMESIZE + 1 ];
  time_t timestamp = time(NULL);
  
  
  if ( argc != 2 && argc !=3 )
  {
    Log2 ( 1, "alchecker:wrong number of arguments in call\n" );
    printf ( "Warning:wrong arguments in call to alchecker\n");
    return 127;
  }
  // username should be passed in as first parameter
  
  if ( strlen ( argv [ 1] ) > UT_NAMESIZE  )
  {
    Log2 ( 1, "alchecker: username passed is too long.\n" );
    printf ("Warning:wrong arguments in call to alchecker\n" );
    return 127;
  }
  strcpy ( UserName, argv [ 1 ] );
  
  if ( argc == 2 ) // ttyname is not passed, trying to determine 
  {
    char* tty_pr;
    if ( NULL == ( tty_pr = ttyname ( 0 ) ) )
    { 
      Log2 ( 1, "alchecker:tty name is not passed and failed to determine myself.\n" ); 
      return 127;
    }
    
    strcpy ( Line, &tty_pr [ sizeof ( "/dev/") -1 ] );
#ifndef NO_DEBUG
    Log2( 3, "alchecker:line determined as %s\n", Line );
#endif
  }
  else 
  {
    if  (strlen ( argv [2] ) >= UT_LINESIZE )
    {
      Log2 (1, "alchecker:tty name passed is too long.\n");
      printf ("Warning:wrong arguments in call to alchecker\n" );
      return 127;
    }
    strcpy ( Line, argv [2] );
  }
      
  
  // done read options 

  // Connect to admind
  if ( ConnectToAdmind() )
    return 127;
  
  // sending signature && request
  
  struct LoginRequest request;
  struct LoginResponse response;
  
  strcpy ( request.UserName, UserName );
  strcpy ( request.Line, Line );
  
  if ( 1 != fwrite ( (void* )&ModuleSig, sizeof ( ModuleSig ), 1, fsock ) ||
    1 != fwrite ( (void* )&request, sizeof ( request ),1 , fsock ) )
  {
    Log2 ( 1, "alchecker:error while communicating with admind.\n" );
    return 127;
  }
  fflush ( fsock );
  // waiting for response
  if ( 1 != fread ( (void*)&RespSig, sizeof (RespSig),1, fsock ) ||
    1 != fread ( (void*)&response, sizeof ( response ),1 , fsock ))
  {
    Log2 ( 1, "alchecker:error reading response from admind.\n" );
    return 127;
  }
  fclose ( fsock );
  
  //  ,     ?
  if ( response. UserProps & US_NOTVALID_INTERVAL )
  {
    Log2 ( 1,"alchecker %s:User %s login on %s refused: time is not valid.\n",
      ctime ( &timestamp), UserName, Line );
    printf ( "User %s login denied: time is not valid.\n", UserName );
    return 1;
  }
  if ( response.UserProps & US_HARD_TIME_EXPIRED )
  {
    Log2 ( 1,"alchecker %s:User %s login on %s refused:hard time limit expired.\n",
      ctime ( &timestamp),UserName, Line );
    printf ( "User %s login denied: hard time limit expired.\n", UserName );
    return 1;
  }
  if ( response.UserProps & US_HARD_TRAFFIC_EXPIRED )
  {
    Log2 ( 1, "alchecker %s:User %s login on %s refused:traffic limit is expired.\n",
      ctime ( &timestamp ), UserName, Line );
    printf ( "User %s login denied: hard traffic limit expired.\n", UserName );
    return 1;
  }
  if (response.UserProps & US_NOTVALID_TTY )
  {
    Log2 ( 1, "alchecker %s:User %s login on %s refused:not valid tty.\n",
      ctime  (&timestamp ), UserName, Line );
    printf ( "User %s login denied: terminal %s is not valid for you.\n",
      UserName, Line );
    return 1;
  }
  if ( response. UserProps & US_UNKNOWN )
  { 
    Log2 ( 1, "alchecker %s:User %s login on %s refused:user unknown to quota system.\n",
      ctime ( &timestamp ), UserName, Line );
    printf ( "User %s login denied: you are unknown to our system.\n",
      UserName );
    return 1;
  }
  if  (response . UserProps & US_SOFT_TIME_EXPIRED )
  {
    printf ( "Warning:You have reached your soft time limit for today.\n" );
  }
  if ( response. UserProps & US_SOFT_TRAFFIC_EXPIRED )
  {
    printf ( "Warning: You have reached your soft traffic limit for today.\n" );
  }
  return 0;  
}          
 
static struct sockaddr_in sa; 
static char ConErrMess[] = "alchecker:connect to admind failed.\n" ;
 
static int ConnectToAdmind()
{
#ifndef NO_DEBUG
   Log2 ( 4, "entered ConnectToAdmind\n" );
#endif
   struct hostent* h_pr = gethostbyname ( ALC_AUTH_ADDR );
   if ( h_pr == NULL )
   { printf ( ConErrMess ); return -1; }

#ifndef NO_DEBUG
   Log2 ( 4, "got hostent okay\n" );
#endif

   memset ( (void* )&sa, 0, sizeof ( sa ) );

   sa.sin_family = AF_INET;
   memcpy ( (void*) &sa.sin_addr, (void*) h_pr -> h_addr, h_pr -> h_length);

   sa.sin_port = htons( CGI_PORT );
   sock = socket ( AF_INET, SOCK_STREAM, 0 );

#ifndef NO_DEBUG
   Log2 (4, "about calling connect()\n" );
#endif
   if ( -1 == connect ( sock, (struct sockaddr*)&sa, sizeof (sa )) )
   { printf ( ConErrMess ); return -1; }
#ifndef NO_DEBUG
   Log2 ( 4, "<P>connected okay\n" );
#endif

   // connected .
   if  (NULL == (fsock= fdopen ( sock, "r+" ) ) )
   { printf (ConErrMess ); return -1; }

#ifndef NO_DEBUG
   Log2 ( 4, "<P> fdopen() passed okay.\n" );
#endif

   //     
   return 0;
 }
 