/*
 * usrmgr - Linux user manager
 * Copyright 1995 by Michael McNeil <kludge@zot.com>
 * XForms GUI adaptation by R. Mitnitksi <mitnits@shani.net>
 * Released under the GNU Public License. See COPYING for details.
 */

#include "forms.h"
#include "xfusermgr.h"
#include "xuser.xpm"
FD_xfusermgr_top *fd_xfusermgr_top;

FD_xfusermgr_top *create_form_xfusermgr_top(void)
{
  FL_OBJECT *obj;
  FD_xfusermgr_top *fdui = (FD_xfusermgr_top *) fl_calloc(1, sizeof(FD_xfusermgr_top));

  fdui->xfusermgr_top = fl_bgn_form(FL_NO_BOX, 540, 310);
  obj = fl_add_box(FL_FLAT_BOX,0,0,540,310,"");
    fl_set_object_color(obj,FL_TOP_BCOL,FL_COL1);
  fdui->users = obj = fl_add_browser(FL_HOLD_BROWSER,20,10,120,280,"");
    fl_set_object_color(obj,FL_TOP_BCOL,FL_YELLOW);
    fl_set_browser_fontsize(obj,FL_NORMAL_SIZE);
    fl_set_browser_fontstyle(obj, FL_FIXEDBOLD_STYLE);
    fl_set_object_callback(obj,usrselc_cb,0);

  fdui->Ulgname_te = obj = fl_add_input(FL_NORMAL_INPUT,260,250,150,30,"Login Name");
  fl_set_object_callback(obj, text_modify,0);
  fdui->Ufname_te = obj = fl_add_input(FL_NORMAL_INPUT,260,210,150,30,"Full name");
  fl_set_object_callback(obj, text_modify,0);
  fdui->Ugroup_te= obj = fl_add_input(FL_NORMAL_INPUT,260,170,150,30,"Group");
  fl_set_object_callback(obj, text_modify,0);
  fdui->Uusrid_te= obj = fl_add_input(FL_NORMAL_INPUT,260,130,150,30,"User Id");
  fl_set_object_callback(obj, text_modify,0);
  fdui->Uhmdir_te = obj = fl_add_input(FL_NORMAL_INPUT,260,90,150,30,"Home Directory");
  fl_set_object_callback(obj, text_modify,0);
  fdui->Ushell_te = obj = fl_add_input(FL_NORMAL_INPUT,260,50,150,30,"Shell");
  fl_set_object_callback(obj, text_modify,0);
  fdui->Upasswd_te = obj = fl_add_input(FL_NORMAL_INPUT,260,10,150,30,"Password");
  fl_set_object_callback(obj, text_modify,0);

  fdui->exit_b = obj = fl_add_button(FL_NORMAL_BUTTON,430,10,90,30,"Exit");
    fl_set_object_callback(obj,Exit,0);
  fdui->clear_b = obj = fl_add_button(FL_NORMAL_BUTTON,430,50,90,30,"Clear");
    fl_set_object_callback(obj,reset_user,0);
  fdui->remove_b = obj = fl_add_button(FL_NORMAL_BUTTON,430,90,90,30,"Remove");
    fl_set_object_callback(obj,rem_user,0);
  fdui->disable_b = obj = fl_add_button(FL_NORMAL_BUTTON,430,130,90,30,"Disable");
    fl_set_object_callback(obj,dis_user,0);
  fdui->add_update_b = obj = fl_add_button(FL_NORMAL_BUTTON,430,170,90,30,"Add-Update");
    fl_set_object_callback(obj,add_user,0);
  fdui->add_button = obj = fl_add_button(FL_NORMAL_BUTTON,430,210,90,30,"New");
    fl_set_object_callback(obj,new_user,0);
  obj = fl_add_pixmap(FL_NORMAL_PIXMAP,430,250,90,50,"");
    fl_set_pixmap_data(obj,100, 64, xuser_xpm); 
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

int main(int argc, char *argv[])
{
 
  fl_initialize(argv[0], "xfusermgr" , 0, 0, &argc, argv);
  fd_xfusermgr_top = create_form_xfusermgr_top();
  
  fl_set_goodies_font(FL_TIMESBOLD_STYLE,FL_MEDIUM_SIZE); 
  
  /* show the first form */
  fl_show_form(fd_xfusermgr_top->xfusermgr_top,FL_PLACE_CENTER,
	       FL_FULLBORDER,"User Manager");
  FillUsersList();
  fl_do_forms();
  return 0;
}



