#!/bin/sh

if test $UID != "0"
then
echo Must be executed by root.
exit 0
fi
version=".02";

clear

echo -e "
**  **                    ****                    ***     **            
**  **                   **  **                  ** **                  
**  **   *****  ** ***  **       ****   *****    **      ***     *** ** 
**  **  **       *** ** **      **  **  **  **  ****      **    **  **  
**  **   ****    **  ** **      **  **  **  **   **       **    **  **  
**  **      **   **      **  ** **  **  **  **   **       **     *****  
******  *****   ****      ****   ****   **  **  ****     ****       **  
                        $version Install                             *****   
----------------------------------------------------------------------------
			By Sean Clarke...\n"
echo -n "Welcome to User Configuration install. Continue [y] ? "
read yes
if [ "$yes" != "n" ]; then 
echo Good.  Now starting install.
echo First I need to know where your perl is location on your system.
if test -f /usr/bin/perl; then
echo -n "Enter perl location [ /usr/bin/perl ] ? "
read perl
if [ "" = "$perl" ]; then
perl="/usr/bin/perl"
else
if test -f $perl; then
echo "There it is, $perl"
else
echo "Not found there"
echo -n "Enter perl location [ /usr/bin/perl ] ? "
read perl
if [ "" = "$perl" ]; then
perl="/usr/bin/perl"
else
if test -f $perl; then
echo "There it is, $perl"
else
echo "Can't find it there, exiting.  If you don't perl on your machine
but you do have a c compiler, please contact me at clarke@minot.com and I 
will get you the newest c version to you ASAP." 
exit 1
fi
fi
fi
fi
else
echo -n "Enter Perl location : "
read perl
if test -f $perl; then
echo "There it is, $perl"
else
echo Not found.
echo -n "Enter Perl location : "
read perl
if test -f $perl; then
echo "There it is, $perl"
else
echo "Can't find it there, exiting.  If you don't perl on your machine
but you do have a c compiler, please contact me at clarke@minot.com and I 
will get you the newest c version to you ASAP." 
exit 1
fi
fi
fi
if test -d $HOME/bin; then
echo -n "Loading User Configuration file in $HOME/bin/usrconfig . . ."
echo "#!$perl" > $HOME/bin/usrconfig
cat .usrconfig >> $HOME/bin/usrconfig
chmod 700 $HOME/bin/usrconfig
echo Done.
else
echo -n "Loading User Configuration file in /bin/usrconfig . . . "
echo "#!$perl" > /bin/usrconfig
cat .usrconfig >> /bin/usrconfig
chmod 700 /bin/usrconfig
echo Done.
fi
echo -n "Making log directory in /tmp/.uc . . . "
if test -d /tmp/.uc; then
chmod 700 /tmp/.uc
else
mkdir /tmp/.uc
chmod 700 /tmp/.uc
fi
echo -ne "#!$perl\n\n\$version = \"$version\";\n" > /tmp/.uc/setup
cat .setup >> /tmp/.uc/setup
chmod 700 /tmp/.uc/setup
echo Done.
echo -ne "\n[30;47mPress enter to continue.[0m"
read wait
/tmp/.uc/setup
else
echo "Goodbye."
exit 0
fi
