#include <unistd.h>
#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/* Prototypes ... */
void usage();
char *changename(struct passwd *pwd, char []);
char *changeuser(struct passwd *pwd, char [], char []);
char *changehome(struct passwd *pwd, char []);

void main (int argc, char **argv)
{	int ch;
	struct passwd *pwd;
	char *username, *p, *foo2=NULL,*pass=NULL,*home=malloc(255),*command=malloc(255), *lpass=malloc(255);
	char runby[9], name[35];
	FILE *passfile, *npass;
	uid_t uid=getuid();

	if (uid)
	  puts("\t\tONLY ROOT is allowed to modify user attributes ... \n\t\t\t\t\tSiviwe\'s usermod (ver 1.1)\n");

	strcpy(runby,argv[argc-1]);
	pwd = getpwnam(runby);
	if (pwd == NULL)  {
	  usage();
	  exit(1);
	}

	if ((passfile=fopen("/etc/passwd","r"))==NULL) {
	  printf("Could not open passwd file\n Write failed !\n");
	  exit(-1);
	}
	if ((npass=fopen("/etc/ptmp","w"))==NULL) {
	  printf("Could not open temp file\n Write failed !\n");
	  exit(-1);
	}

	pass=malloc(255);
	username=malloc(9);
	command[0]='\0';

// HAD to put these 2 lines above here to accomodate the change in username
// ----------------------------------------
// This is the pointwhere we write to file ...
// DONT you just *HATE* C ? *grin*
        p=malloc(20);
	foo2=malloc(255);
	sprintf(p,"%s:",pwd->pw_name);
	strcpy(foo2,"");
// ----------------------------------------

	while ((ch=getopt(argc, argv, "f:h:s:u:l")) != EOF)
	  switch(ch) {
	    case 'f': strcpy(name,changename(pwd,optarg));
		      pwd->pw_gecos = name;
		      break;

	    case 's': pwd->pw_shell=optarg;
		      break;

	    case 'u': strcpy(username,changeuser(pwd,optarg,runby));
		      pwd->pw_name = username;
		      break;

	    case 'h': strcpy(home,changehome(pwd,optarg));
		      pwd->pw_dir=home;
		      break;

	    case 'l': lpass=pwd->pw_passwd;
		      if (*lpass == '*') 
			lpass++;
		      pwd->pw_passwd=lpass;
		      break;
 	    case '?': usage();
	  }

	  // Write the new passwd file :)
	  while(fgets(foo2,255,passfile)) {
	    if (!strncmp(foo2,p,strlen(p))) {
	      if(putpwent(pwd,npass) <0) {
                printf("Could not get new entry written. EXITING");
		endpwent();
		fclose(passfile);
		unlink("/etc/ptmp");
		exit(-1);
	      }
            }
	    else {
	      if (fputs(foo2,npass) <0) {
                puts("Could not write ENTRIES into new passwd file. EXITING");
		fclose(passfile);
		fclose(npass);
		unlink("/etc/ptmp");
		exit(-1);
	      }
            }
	  }

	  // Close all the files
	  fclose(passfile);
	  fclose(npass);

	  // Practice safe sex and all while getting the job done
	  if (unlink("/etc/passwd.OLD")<0)
	    fprintf(stderr,"Could not get rid of old passwd file\n");
	  if (link("/etc/passwd","/etc/passwd.OLD") <0)
	    fprintf(stderr,"Could not keep OLD copy of passwd\n");
	  if (unlink("/etc/passwd")<0)
	    fprintf(stderr,"Old passwd file not deleted, no change\n");
	  if (link("/etc/ptmp","/etc/passwd")<0)
	    fprintf(stderr,"Could not write new passwd entry, no change\n");
	  if (unlink("/etc/ptmp") < 0)
	    fprintf(stderr,"Could not delete /etc/ptmp, still exists\n");

	  // get rid of our pointers and all the important thingums.
	  free(pass);
	  free(pwd->pw_passwd);
	  printf("Done.\n");
}

void usage ()
{  printf("usage: usermod [-f FullName] [-h home-dir] [-l] [-s shell] [-u username] user\n");
  exit(1);
}

char *changename(struct passwd *pwd, char name[40])
{     	char foo[40], *namethingie=malloc(255);

	strcpy(foo,optarg);
      	namethingie=strchr(pwd->pw_gecos,',');
      	if (namethingie != NULL) {
	  strcat(foo,namethingie);
      	}
	name[0] = '\0';
	strcpy(name,foo);
	return name;
}

char *changeuser(struct passwd *pwd, char username[9], char olduser[9])
{
      if ((getpwnam(username))==NULL) {
        /* Get our old entry back */
	pwd = getpwnam(olduser);
      }
      else {
	printf("Username in use, choose another!");
	exit(-1);
      } 
      return(username);
}

char *changehome(struct passwd *pwd, char home[256])
{	/* First case is when called by the case h */
	char command[256];
	
	sprintf(command, "mv --verbose --force %s %s",pwd->pw_dir, home);
	system(command);
	return(home);
}
