/*      -------------------------------------------------------------------
	xldlas -- A Stastics Package

	Copyright (C) 1996 Thor Sigvaldason

	Very straightforward (and non-hypertext) help. Just read helpfiles
	into a window based on the items selected

	also includes the prefs routines	
        -------------------------------------------------------------------*/

#include "xldlas.h"


extern void say_status(char the_status[XLDLASMAX_INPUT]);
extern void set_startup_defaults();
extern void read_rc_file(FILE *the_file);
extern void inhibit_input();
extern void reenable_input();
extern void make_rc_file(FILE *the_file);

extern TOOLTIPS_ERROR tooltips_suspend();
extern TOOLTIPS_ERROR tooltips_resume();


void stop_help(FL_OBJECT *obj, long user_data)
{
	window_geometry[XLDLAS_HELP][0] = obj->form->x;
	window_geometry[XLDLAS_HELP][1] = obj->form->y;
	window_geometry[XLDLAS_HELP][2] = obj->form->w;
	window_geometry[XLDLAS_HELP][3] = obj->form->h;
	fl_hide_form(help_window);
	say_status("Ready");
}

void help_about_general(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"general.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}

void help_about_file(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"file.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}

void help_about_data(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"data.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}

void help_about_log(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"log.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}

void help_about_graph(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"graph.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}

void help_about_analysis(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"analysis.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}

void help_about_license(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"license.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}

void help_about_tutorial(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"tutorial.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}

void help_about_test(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"test.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}

void help_about_filter(FL_OBJECT *obj, long user_data)
{
	char helpfile[XLDLASMAX_INPUT];
	fl_freeze_form(help_window);
	fl_clear_browser(help_browser);
	strcpy(helpfile,help_location);
	strcat(helpfile,"filter.help");
	fl_load_browser(help_browser, helpfile);
	fl_unfreeze_form(help_window);
}



void help_routines(FL_OBJECT *menu, long user_data)
{
	int choice;
	say_status("Displaying Help");

	fl_set_button(general_help_button,0);
	fl_set_button(file_help_button,0);
	fl_set_button(data_help_button,0);
	fl_set_button(log_help_button,0);
	fl_set_button(graph_help_button,0);
	fl_set_button(analysis_help_button,0);
	fl_set_button(license_help_button,0);
	fl_set_button(tutorial_help_button,0);
	fl_set_button(test_help_button,0);
	fl_set_button(filter_help_button,0);
	fl_set_form_minsize(help_window, 400, 210);	
	if(window_geometry[XLDLAS_HELP][0] != -1)
	{
		fl_set_form_geometry(help_window, 
					window_geometry[XLDLAS_HELP][0],
					window_geometry[XLDLAS_HELP][1],
					window_geometry[XLDLAS_HELP][2],
					window_geometry[XLDLAS_HELP][3]);
	}	
	fl_show_form(help_window,FL_PLACE_FREE,FL_FULLBORDER,"Help");
	choice = fl_get_menu(menu);
	if(choice == 1)
	{
   		fl_set_button(general_help_button,1);
		help_about_general(menu, user_data);
	}
	if(choice == 2)
	{
   		fl_set_button(file_help_button, 1);
		help_about_file(menu, user_data);
	}
	if(choice == 3)
	{
   		fl_set_button(data_help_button, 1);
		help_about_data(menu, user_data);
	}
	if(choice == 4)
	{
   		fl_set_button(log_help_button, 1);
		help_about_log(menu, user_data);
	}
	if(choice == 5)
	{
   		fl_set_button(graph_help_button, 1);
		help_about_graph(menu, user_data);
	}
	if(choice == 6)
	{
   		fl_set_button(analysis_help_button, 1);
		help_about_analysis(menu, user_data);
	}
	if(choice == 7)
	{
   		fl_set_button(test_help_button, 1);
		help_about_test(menu, user_data);
	}
	if(choice == 8)
	{
   		fl_set_button(filter_help_button, 1);
		help_about_filter(menu, user_data);
	}
	if(choice == 9)
	{
   		fl_set_button(license_help_button, 1);
		help_about_license(menu, user_data);
	}
	if(choice == 10)
	{
   		fl_set_button(tutorial_help_button, 1);
		help_about_tutorial(menu, user_data);
	}
}


int click_end_prefs(FL_FORM *form, void *arg)
{
	window_geometry[XLDLAS_PREFS][0] = form->x;
	window_geometry[XLDLAS_PREFS][1] = form->y;
	window_geometry[XLDLAS_PREFS][2] = form->w;
	window_geometry[XLDLAS_PREFS][3] = form->h;
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}

void set_font_preference(FL_OBJECT *obj, long arg)
{
	if(arg == 1) fl_set_browser_fontsize(main_browser,FL_SMALL_SIZE);
	if(arg == 2) fl_set_browser_fontsize(main_browser,FL_NORMAL_SIZE);
	if(arg == 3) fl_set_browser_fontsize(main_browser,FL_LARGE_SIZE);
	fl_set_button(prefs_font_small_button, 0);
	fl_set_button(prefs_font_normal_button, 0);
	fl_set_button(prefs_font_large_button, 0);
	fl_set_button(obj, 1);
	main_font = arg;
}

void set_prefs_values()
{
	char string_one[XLDLASMAX_INPUT];
	fl_freeze_form(prefs_window);

	fl_set_counter_value(prefs_numb_bars_counter, numb_bars);
	fl_set_counter_bounds(prefs_numb_bars_counter, 1, XLDLAS_NUMB_BARS_MAX);
	fl_set_counter_step(prefs_numb_bars_counter, 1, 10);

	fl_set_counter_value(prefs_ga_cycles_counter, ga_cycles);
	fl_set_counter_bounds(prefs_ga_cycles_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(prefs_ga_cycles_counter, 1, 10);

	fl_set_counter_value(prefs_ga_update_counter, ga_update);
	fl_set_counter_bounds(prefs_ga_update_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(prefs_ga_update_counter, 1, 10);

	fl_set_counter_value(prefs_ga_mutate_counter, ga_mutate);
	fl_set_counter_bounds(prefs_ga_mutate_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(prefs_ga_mutate_counter, 1, 10);

	fl_set_counter_value(prefs_ga_maxreal_counter, ga_maxreal);
	fl_set_counter_bounds(prefs_ga_maxreal_counter, 1, XLDLAS_GA_MAXREAL);
	fl_set_counter_step(prefs_ga_maxreal_counter, 1, 10);

	fl_set_counter_value(prefs_ga_bitsize_counter, ga_bitsize);
	fl_set_counter_bounds(prefs_ga_bitsize_counter, 1, XLDLAS_MAX_GA_BITSIZE);
	fl_set_counter_step(prefs_ga_bitsize_counter, 1, 10);

	fl_set_counter_value(prefs_ga_poolsize_counter, ga_poolsize);
	fl_set_counter_bounds(prefs_ga_poolsize_counter, 1, XLDLAS_MAX_GA_POOLSIZE);
	fl_set_counter_step(prefs_ga_poolsize_counter, 1, 10);

	fl_set_counter_value(prefs_ga_swap_counter, ga_swap);
	fl_set_counter_bounds(prefs_ga_swap_counter, 1, XLDLAS_MAX_GA_POOLSIZE);
	fl_set_counter_step(prefs_ga_swap_counter, 1, 10);

	fl_set_counter_value(prefs_ga_cross_counter, ga_cross);
	fl_set_counter_bounds(prefs_ga_cross_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(prefs_ga_cross_counter, 1, 10);

	fl_set_counter_value(prefs_ga_perturbe_counter, ga_perturbe);
	fl_set_counter_bounds(prefs_ga_perturbe_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(prefs_ga_perturbe_counter, 1, 10);

	fl_set_counter_value(prefs_ga_tolerance_counter, ga_tolerance);
	fl_set_counter_bounds(prefs_ga_tolerance_counter, 0, XLDLAS_GA_MAXREAL);
	fl_set_counter_step(prefs_ga_tolerance_counter, 1, 10);

	fl_set_counter_value(prefs_nn_cycles_counter, nn_cycles);
	fl_set_counter_bounds(prefs_nn_cycles_counter, 0, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(prefs_nn_cycles_counter, 1, 10);

	fl_set_counter_value(prefs_nn_learn_counter, nn_learn);
	fl_set_counter_bounds(prefs_nn_learn_counter, 0.0, 20.0);
	fl_set_counter_step(prefs_nn_learn_counter, 0.1, 0.01);
	

	fl_set_button(prefs_quick_dropping_button, quick_dropping);
	fl_set_button(prefs_graph_key_on_button, graph_key_on);
	fl_set_button(prefs_graph_overwrite_on_button, graph_overwrite_on);
	fl_set_button(prefs_graph_normal_on_button, graph_normal_on);
	fl_set_button(prefs_ga_cross_ok_button, ga_cross_ok);
	fl_set_button(prefs_ga_mutate_ok_button, ga_mutate_ok);
	fl_set_button(prefs_ga_perturbe_ok_button, ga_perturbe_ok);
	fl_set_button(prefs_pearls_of_wisdom_button, pearls_of_wisdom);
	fl_set_button(prefs_nnet_annealing_button, nn_annealing);
	fl_set_button(prefs_nnet_pictex_button, nn_pictex);
	fl_set_button(prefs_ga_force_button, ga_force);
	fl_set_button(prefs_balloon_help_button, balloon_help);
	fl_set_button(prefs_assume_sample_button, assume_sample);

	sprintf(string_one,"%f",missing_value);
	fl_set_input(prefs_missing_value_input,string_one);
	fl_set_input(prefs_graph_output_format_input, graph_output_format);
	fl_set_input(prefs_graph_output_options_input, graph_output_options);
	fl_set_input(prefs_gnuplot_geometry_input, gnuplot_geometry);
	fl_set_input(prefs_print_command_input, print_command);
	fl_set_input(prefs_tex_command_input, tex_command);
	fl_set_input(prefs_dviview_command_input, dviview_command);
	fl_set_input(prefs_dviprint_command_input, dviprint_command);
	fl_set_input(prefs_tex_preamble_input, tex_preamble);
	fl_set_input(prefs_tex_graphmacrol_input, tex_graphmacrol);
	fl_set_input(prefs_tex_graphmacror_input, tex_graphmacror);
	
	if(main_font == 2 || main_font < 0 || main_font > 3) set_font_preference(prefs_font_normal_button, 2);
	if(main_font == 1 ) set_font_preference(prefs_font_small_button, 1);
	if(main_font == 3 ) set_font_preference(prefs_font_large_button, 3);

	fl_unfreeze_form(prefs_window);	
}

void handle_prefs_buttons(FL_OBJECT *obj, long arg)
{
	FILE *rc_file;
	int i;
	char searcher[XLDLASMAX_INPUT];
	char home_dir[XLDLASMAX_INPUT];
	char	**env = environ;
	quick_dropping = fl_get_button(prefs_quick_dropping_button);
	graph_overwrite_on = fl_get_button(prefs_graph_overwrite_on_button);
	ga_cross_ok = fl_get_button(prefs_ga_cross_ok_button);
	ga_mutate_ok = fl_get_button(prefs_ga_mutate_ok_button);
	ga_perturbe_ok = fl_get_button(prefs_ga_perturbe_ok_button);
	pearls_of_wisdom = fl_get_button(prefs_pearls_of_wisdom_button);
	graph_key_on = fl_get_button(prefs_graph_key_on_button);
	graph_normal_on = fl_get_button(prefs_graph_normal_on_button);
	nn_annealing = fl_get_button(prefs_nnet_annealing_button);
	nn_pictex = fl_get_button(prefs_nnet_pictex_button);
	ga_force = fl_get_button(prefs_ga_force_button);
	balloon_help = fl_get_button(prefs_balloon_help_button);
	assume_sample = fl_get_button(prefs_assume_sample_button);
	if(balloon_help == TRUE)
	{
		tooltips_resume();
	}
	if(balloon_help == FALSE)
	{
		tooltips_suspend();
	}
	if(arg == 12)
	{
		set_startup_defaults();
		set_prefs_values();
	}
	if(arg == 13)
	{
		while (*env)
		{
			strcpy(searcher, *env);
			if(strncmp("HOME=", searcher, 5) == FALSE)
			{
				for(i=5; i< XLDLASMAX_INPUT; i++)
				{
					home_dir[i-5] = searcher[i];
					if(searcher[i] == '\0')
					{
						i = XLDLASMAX_INPUT;
					}
				}
			}
		env++;
		}
		strcat(home_dir,"/.xldlasrc");
		rc_file = fopen(home_dir,"r");
		if(!rc_file)
		{
			fl_show_alert("Very Strange: I can't load your .xldlasrc file!","","",TRUE);
		}
		else
		{
			read_rc_file(rc_file);
			fclose(rc_file);
		}
		set_prefs_values();
	}
	if(arg == 14)
	{
		window_geometry[XLDLAS_PREFS][0] = obj->form->x;
		window_geometry[XLDLAS_PREFS][1] = obj->form->y;
		window_geometry[XLDLAS_PREFS][2] = obj->form->w;
		window_geometry[XLDLAS_PREFS][3] = obj->form->h;
		fl_hide_form(prefs_window);
		say_status("Ready");
		reenable_input();
	}
	if(arg == 15)
	{
		while (*env)
		{
			strcpy(searcher, *env);
			if(strncmp("HOME=", searcher, 5) == FALSE)
			{
				for(i=5; i< XLDLASMAX_INPUT; i++)
				{
					home_dir[i-5] = searcher[i];
					if(searcher[i] == '\0')
					{
						i = XLDLASMAX_INPUT;
					}
				}
			}
		env++;
		}
		strcat(home_dir,"/.xldlasrc");
		rc_file = fopen(home_dir,"w");
		if(!rc_file)
		{
			fl_show_alert("Very Strange: I can't overwrite your .xldlasrc file!","","",TRUE);
		}
		else
		{
			make_rc_file(rc_file);
			fclose(rc_file);
		}
	}
}

void handle_prefs_counters(FL_OBJECT *obj, long arg)
{
	numb_bars = fl_get_counter_value(prefs_numb_bars_counter);
	ga_cycles = fl_get_counter_value(prefs_ga_cycles_counter);
	ga_update = fl_get_counter_value(prefs_ga_update_counter);
	ga_mutate = fl_get_counter_value(prefs_ga_mutate_counter);
	ga_maxreal = fl_get_counter_value(prefs_ga_maxreal_counter);
	ga_bitsize = fl_get_counter_value(prefs_ga_bitsize_counter);
	ga_poolsize = fl_get_counter_value(prefs_ga_poolsize_counter);
	ga_swap = fl_get_counter_value(prefs_ga_swap_counter);
	ga_cross = fl_get_counter_value(prefs_ga_cross_counter);
	ga_perturbe = fl_get_counter_value(prefs_ga_perturbe_counter);
	ga_tolerance = fl_get_counter_value(prefs_ga_tolerance_counter);
	nn_cycles = fl_get_counter_value(prefs_nn_cycles_counter);
	nn_learn = fl_get_counter_value(prefs_nn_learn_counter);
}

void handle_prefs_inputs(FL_OBJECT *obj, long arg)
{
	missing_value = atof(fl_get_input(prefs_missing_value_input));
	strcpy(graph_output_format, fl_get_input(prefs_graph_output_format_input));
	strcpy(graph_output_options, fl_get_input(prefs_graph_output_options_input));
	strcpy(gnuplot_geometry, fl_get_input(prefs_gnuplot_geometry_input));
	strcpy(print_command, fl_get_input(prefs_print_command_input));
	strcpy(tex_command, fl_get_input(prefs_tex_command_input));
	strcpy(dviview_command, fl_get_input(prefs_dviview_command_input));
	strcpy(dviprint_command, fl_get_input(prefs_dviprint_command_input));
	strcpy(tex_preamble, fl_get_input(prefs_tex_preamble_input));
	strcpy(tex_graphmacrol, fl_get_input(prefs_tex_graphmacrol_input));
	strcpy(tex_graphmacror, fl_get_input(prefs_tex_graphmacror_input));
}

void start_prefs(FL_OBJECT *obj, long arg)
{
	inhibit_input();
	say_status("Adjusting Preferences");
	set_prefs_values();
	if(window_geometry[XLDLAS_PREFS][0] != -1)
	{
		fl_set_form_geometry(prefs_window, 
					window_geometry[XLDLAS_PREFS][0],
					window_geometry[XLDLAS_PREFS][1],
					window_geometry[XLDLAS_PREFS][2],
					window_geometry[XLDLAS_PREFS][3]);
	}	
	fl_show_form(prefs_window,FL_PLACE_FREE,FL_FULLBORDER,"Preferences");
}
