/****************************************************************************
 *
 * Sierpinski Demo
 *
 * Draws a 2d Sierpinski cube (testing recursions in Xi)
 *
 * Usage: sierpinski(Iterations)
 *
 *            Iterations   :   Depth of the cube
 *
 ****************************************************************************/

void draw_sierpinski(int Iteration,double center[],double radius)
{
  if(Iteration==3) startbuffer();
  if(Iteration==0)
    {
      s=radius/3;
      rect({center[0]-radius,center[0]+radius,
            center[0]-radius,center[0]+radius,
            center[0]-radius,center[0]-s,
            center[0]+s,center[0]+radius},
           {center[1]-radius,center[1]-s,
            center[1]+s,center[1]+radius,
            center[1]-radius,center[1]+radius,
            center[1]-radius,center[1]+radius},\color=4,\fill);
/*      rect(center[0]-radius,center[1]-radius,
           center[0]+radius,center[1]+radius,\color=4,\fill);*/
    }
  else
    {
      radius=radius/3;
      s=2*radius;
      draw_sierpinski(Iteration-1,center+{ s, s},radius);
      draw_sierpinski(Iteration-1,center+{ s, 0},radius);
      draw_sierpinski(Iteration-1,center+{ s,-s},radius);
      draw_sierpinski(Iteration-1,center+{ 0, s},radius);
      draw_sierpinski(Iteration-1,center+{ 0,-s},radius);
      draw_sierpinski(Iteration-1,center+{-s, s},radius);
      draw_sierpinski(Iteration-1,center+{-s, 0},radius);
      draw_sierpinski(Iteration-1,center+{-s,-s},radius);
    }
  if(Iteration==3) endbuffer();
}

void sierpinski(int Iterations=3)
{
  window(0,\bpp=3,\size={400,400},\clearAll);
  plot(\xrange={-1.1,1.1},\yrange={-1.1,1.1});
  axis(\noticks,\nonum,\left,\right,\top,\bottom);
  draw_sierpinski(Iterations,{0.0,0.0},1.0);
}