/************************************************************************
*Name: rainbow
*Type: LibraryFunction
*Section: 61 Color Manipulations
*Parameters: (int) n = 255, (double) s = 0.8, (double) v=0.8
*Return: char[] (contains the colormap)
*DescriptionShort: generates a rainbow colormap
*DescriptionLong:
The function \e\rainbow\e\ produces a rainbow colormap with \e\n\e\ entries,
the saturation (determines how pure a color is) \e\s\e\ and the
value (intensity of the color) \e\v\e\.
*Example:
>rainbowMap=rainbow();
Function rainbow defined
>loadct(rainbow(126,0.4,0.4));
>window(0,\bpp=7);
>show(cincarr(126,1)+2);
*SeeAlso: graymap, loadct
*Reference:
*End:
*************************************************************************/

char[] rainbow(int n=255, double s=0.8, double v=0.8)
{
   double hsv[n,3];
   phi_step=280.0/n;

   for (i=0; i<n; i++)
     hsv[i,*]={phi_step*i, s, v};

   return hsv2rgb(hsv);
}