double[] ising(int ntotal, int nskip)
{
   set_seed(1234);

   char spin[34,34];
   double s[1], sq[7];
   int i=0;

   spin=1;
   for (beta=0.1; beta<=0.7; beta+=0.1)
    {
      s=0.0;
      for (nsum=0; nsum<ntotal; nsum++)
        {
          update(beta,1,1,spin); update(beta,1,2,spin);  
          update(beta,2,1,spin); update(beta,2,2,spin);
          if (nsum >= nskip) s=s+abs(sum(double(spin),0,1));
	}
      sq[i]=s[0]/(ntotal-nskip); 
      i++;
    }
   x=interval(0.1,0.7,7);
   plot(x,sq,\curve,\xtitle="Beta",\ytitle="Magnetisation abs(S)",
                            \title="Ising Model");
   plot(x,sq,\marker=5);
}  

