/***********************************************************************
*Name: interval2d
*Type: BuildinFunction
*Section: 515 Array functions
*Parameters: (double) x0, (double) y0, (double) xn, (double) yn,
             (int) nx = 100, (int) ny = 100
*Return: [double[],double[]] (contains the x- and y-values)
*DescriptionShort: Subdivid a rectangle into tiles
*DescriptionLong:
 \t\interval2d\t\ generates a tiling of a rectangular domain of the plane.
 This is especially useful for evaluation of two dimensional functions.
 The rectangle is defined by the two corners (\e\x0\e\,\e\y0\e\) and
 (\e\xn\e\,\e\yn\e\). \t\interval2d\t\ will return two
 (\e\nx\e\+1)x(\e\ny\e\+1) array containing the x- resp. y-coordinates,
 such that x[.,0]=\e\x0\e\, x[.,\e\nx\e\]=\e\xn\e\ , y[0,.]=\e\y0\e\ and
 y[\e\ny\e\,.]=\e\yn\e\.
*Example:
 (  1)>[x,y]=interval2d(0,0,1,1,2,2);
 Function interval2d defined
 (  2)>print(x,y)
 <dblarr>
            0          0.5            1 
            0          0.5            1 
            0          0.5            1 
 <dblarr>
            0            0            0 
          0.5          0.5          0.5 
            1            1            1 
*SeeAlso: interval2d
*End:
************************************************************************/
   
[ double[], double[] ] interval2d(double x0, double y0,
                                  double xn, double yn,
                                  int nx=100, int ny=100)
{
  x=y=darr(ny+1,nx+1);
  for(i=0;i<=ny;i++)
    for(j=0;j<=nx;j++)
      {
        x[i,j]=j*(xn-x0)/nx+x0;
        y[i,j]=i*(yn-y0)/ny+y0;
      }
  return [x,y];
}