/***********************************************************************
*Name: interval
*Type: BuildinFunction
*Section: 515 Array functions
*Parameters: (double) x0, (double) xn, (int) n = 100
*Return: double[] (contains the x-values)
*DescriptionShort: Subdivid a interval into equidistant tiles
*DescriptionLong:
 \t\interval\t\ simply subdivides the interval [\e\x0\e\,\e\xn\e\] into
 \e\n\e\ equistant tiles. It returns an array with \e\n\e\+1 elements, such
 that the first element is \e\x0\e\ and the last is \e\xn\e\.
*Example:
 (  1)>x=interval(0,1,10);
 Function interval defined
 (  2)>print(x)
 <dblarr> 
            0          0.1          0.2          0.3          0.4          0.5 
          0.6          0.7          0.8          0.9            1 
*SeeAlso: interval2d
*End:
************************************************************************/

double[] interval(double x0, double xn, int n=100)
{
  return dincarr(n+1)/n*(xn-x0)+x0;
}
