/********************************************************************************
*Name: fft_image_filter
*Type: BuildinFuntion
*Section: 62 Geometrical Transformations
*Parameters: (char[]) image, (int) radius
*Return: char[] (contains the filtered image)
*DescriptionShort: filters an image in the frequency domain
*DescriptionLong:
 The function \e\fft_image_filter\e\ performs an ideal low pass
 filter with cutoff frequency \e\radius\e\. 
*Example:
*SeeAlso: fft, rev_fft
*End:
************************************************************************/

char[] fft_image_filter(char image[], char radius)
{
   s=size(image);
   rows=s[3];
   cols=s[4];

   mrows=rows/2;
   mcols=cols/2;

   b=sqrt(dist(rows,cols))+1;
   b[where(b >= radius)]=0.0;
   b[where(b != 0.0)]=1.0; 
   b=shift(b,mrows,mcols);

   n=abs(rev_fft(fft(image)*b));

   delete b;
   delete s;

   return (char) (n / (max(n)/255));
}
