#!/bin/sh

archs="i486-linux-elf i486-linux-aout alpha-osf rs6000-aix sparc-solaris"

sysname=`uname -s`

case $sysname in
  Linux)
	   if test -f /lib/libc.so.5
	   then
	     arch=i486-linux-elf
	   else
	     arch=i486-linux-aout
	   fi
	   ;;
  ULTRIX)
	   arch=misp-ultrix ;;
  OSF1)
	   arch=alpha-osf ;;
  AIX)
           arch=rs6000-aix ;;
  SunOS)
	   arch=sparc-solaris ;;
esac

if test "$1" = ""
then
  installdir=/usr/local/xi
else
  installdir=$1
fi

echo "Hmm... this machine seems to be a \"$arch\""
echo -n "Is this correct? [Y/n]: "
read r

if test "$r" = "n" -o "$r" = "N"
then
  echo ""
  echo "That's to bad. Please send a mail to xi@zaphod.uni-muenster.de"
  echo "But let's see what we can do now."
  echo "Avialable binaries are:"
  echo ""
  for i in $archs
  do
    if test -f ./bin.$i/xi
    then
      echo "$i"
    fi
  done
  echo ""
  echo -n "Please enter one of the above: "
  read r
  while test ! -f ./bin.$r/xi
  do
    echo ""
    echo "Your input \"$r\" is not valid."
    echo -n "Please enter again: "
    read r
  done
  arch=$r
  lockarch=1
fi

echo ""
echo "Okay let's go ahead"
echo "Installing $arch - Version in $installdir"
echo -n "Is this correct? [Y/n]: "
read r

while test "$r" = "n" -o "$r" = "N"
do
  echo ""
  echo -n "Please enter an alternative directory: "
  read installdir
  echo ""
  echo "Installing $arch - Version in $installdir"
  echo -n "Is this correct? [Y/n]: "
  read r
done

if test ! -d $installdir
then
  mkdir -p $installdir
fi

if test ! -d $installdir/bin.$arch
then
  mkdir -p $installdir/bin.$arch
fi

if test ! -d $installdir/lib.$arch
then
  mkdir -p $installdir/lib.$arch
fi

if test ! -d $installdir/include
then
  mkdir -p $installdir/include
fi

if test ! -d $installdir/xilib
then
  mkdir -p $installdir/xilib
fi

if test ! -d $installdir/docu
then
  mkdir -p $installdir/docu
fi

for i in $archs
do
  if test -f ./bin.$i/xi
  then
    if test "$i" != "$arch" -a "$lockarch" = "1"
    then
      continue
    fi
    if test "$i" != "$arch" -a "$lockarch" != "1"
    then
      echo ""
      echo "Hmm... there is also a $i - version avialable"
      echo -n "Should this also be installed? [y/N] : "
      read r
      if test "$r" != "y" -a "$r" != "Y"
      then
	continue
      fi
    fi
    
    cp bin.$arch/xi* $installdir/bin.$arch
    cp lib.$arch/* $installdir/lib.$arch
    cp include/* $installdir/include
    cp xilib/*.xi $installdir/xilib
    cp xilib/xihelp $installdir/xilib
    cp -r docu/* $installdir/docu
  fi
done

if test "$2" = ""
then
  installbin=/usr/local/bin
else
  installbin=$2
fi

echo ""
echo "Installing script in $installbin"
echo -n "Is this correct? [Y/n]: "
read r

while test "$r" = "n" -o "$r" = "N"
do
  echo ""
  echo -n "Please enter an alternative directory: "
  read installbin
  echo ""
  echo "Installing script in $installbin"
  echo -n "Is this correct? [Y/n]: "
  read r
done

if test "$lockarch" = "1"
then
  cat - >$installbin/xi << END
#!/bin/sh

arch=$arch
XIPATH=$installdir
exec $installdir/bin.\$arch/xi
END

else
  cat - >$installbin/xi << END
#!/bin/sh

sysname=\`uname -s\`

case \$sysname in
  Linux)
	   if test -f /lib/libc.so.5
	   then
	     arch=i486-linux-elf
	   else
	     arch=i486-linux-aout
	   fi
	   ;;
  ULTRIX)
	   arch=mips-ultrix ;;
  OSF1)
	   arch=alpha-osf ;;
  AIX)
           arch=rs6000-aix ;;
  SunOS)
	   arch=sparc-solaris ;;
esac

XIPATH=$installdir
exec $installdir/bin.\$arch/xi
END

fi

chmod 755 $installbin/xi

echo ""
echo "We've finally done it."
echo "You should now be able to start Xi by $installbin/xi"
echo "If this don't work I'm out of ideas."
echo "Please send mail to xi@zaphod.uni-muenster.de"
