// -*-Mode: C++;-*-

// $Id$

/*
 * $Log$
 */

#ifndef __xiPlotWindow_h
#define __xiPlotWindow_h

#include <xiPlotParam.h>
#include <xiAxisParam.h>
#include <xiLineStyle.h>
#include <xiFillStyle.h>

enum deviceType { deviceX, deviceEPS, devicePPM, 
                  device3dX, device3dPOV, device3dEPS,
		  deviceJAVA };

enum pipeType { pipeUnix, pipePvm, pipeShm };

class xiPipe;
class xiGraphCmd;

class xiPlotWindow
{
  xiPipe     *pipe;
  deviceType type;
  int        actualPlotNum;
  xiGraphCmd *cmdList;

  void       add(xiGraphCmd *);
  void       waitFor() const;
public:
  xiPlotWindow(int,deviceType =deviceX,pipeType =pipeUnix,
	       const char * =NULL,
	       const char * =NULL,
	       const char * =NULL,
	       const char * =NULL,
	       const char * =NULL,
	       int =-1);
  ~xiPlotWindow();

  void clearList();
  int  isActive() const;
  void send();

  void clearAll();
  void name(const char *);
  void title(const char *);
  void size(int,int);
  void position(int,int);
  void background(int);
  void map();

  void setActualPlot(int);
  void setActualPlot3d(int);
  void erase();

  void setAxis(axisType,int,const xiAxisParam &);
  void removeAxis(axisType,int);
  void setPlot(const xiPlotParam &);

  void setDrawColor(int);
  void setLineStyle(const xiLineStyle &);
  void setFillStyle(const xiFillStyle &);
  void setMarker(int);

  void point(double,double);
  void pointErr(double,double,double,double);
  void points(int,const double *,const double *);
  void pointsErr(int,const double *,const double *,
		     const double *,const double *);

  void line(double,double,double,double);
  void lines(int,const double *,const double *);
  void linesErr(int,const double *,const double *,
		    const double *,const double *);

  void curve(int,const double *,const double *);
  void curveErr(int,const double *,const double *,
		    const double *,const double *);

  void rect(double,double,double,double);
  void rects(int,const double *,const double *);

  void triag(double,double,double,double,double,double);
  void triags(int,const double *,const double *);

  void poly(int,const double *,const double *);
};

#endif
