// -*- Mode:C++; -*-

// $Id$

/*
 * $Log$
 */

#ifndef __xiPlotParam_h
#define __xiPlotParam_h

#define maskNone        0x0
#define maskXRange      0x1
#define maskYRange      0x2
#define maskTitleHeight 0x4
#define maskPosition    0x8
#define maskWidth       0x10
#define maskHeight      0x20
#define maskBounds      (maskPosition | maskWidth | maskHeight)
#define maskTitle       0x40
#define maskXLogBase    0x80
#define maskYLogBase    0x100

class xiPipe;

#include <stdlib.h>

struct xiPlotParam
{
  int      mask;
  double   posx,posy,width,height;
  double   xmin,xmax,ymin,ymax;
  double   TitleTextHeight;
  char     *cTitle;
  int      xlogBase,ylogBase;

  xiPlotParam()          { mask=maskNone; cTitle=NULL; }
  xiPlotParam(const xiPlotParam &);
  ~xiPlotParam();

  xiPlotParam &Bounds(double _xmin,double _ymin,double _xmax,double _ymax)
                         { mask|=maskBounds; posx=_xmin; posy=_ymin;
			   width=_xmax-_xmin; height=_ymax-_ymin;
			   return *this; }
  xiPlotParam &Position(double x,double y)
                         { mask|=maskPosition; posx=x; posy=y; return *this; }
  xiPlotParam &Width(double w)
                         { mask|=maskWidth; width=w; return *this; }
  xiPlotParam &Height(double h)
                         { mask|=maskHeight; height=h; return *this; }
  xiPlotParam &XRange(double min,double max) 
                         { mask|=maskXRange; xmin=min; xmax=max;
			   return *this; }
  xiPlotParam &YRange(double min,double max)
                         { mask|=maskYRange; ymin=min; ymax=max;
                           return *this; }
  xiPlotParam &TitleHeight(double h)
                         { mask|=maskTitleHeight; TitleTextHeight=h;
                           return *this; }
  xiPlotParam &NoTitle();
  xiPlotParam &Title(const char *);
  xiPlotParam &XLogBase(int _xlogBase)
                         { mask|=maskXLogBase; xlogBase=_xlogBase;
       			   return *this; }
  xiPlotParam &YLogBase(int _ylogBase)
                         { mask|=maskYLogBase; ylogBase=_ylogBase;
       			   return *this; }

  // Operators
  xiPlotParam &operator=(const xiPlotParam &);

  friend xiPipe &operator<<(xiPipe &,const xiPlotParam &);
  friend xiPipe &operator>>(xiPipe &,xiPlotParam &);
};

#endif
