// -*- Mode: C++; -*-

// $Id$

/*
 * $Log$
 */

#ifndef __xiAxisParam_h
#define __xiAxisParam_h

#include <stdlib.h>

#define maskAxisNone     0x0
#define maskAxisTitle    0x1
#define maskAxisRange    0x2
#define maskAxisTickPos  0x4
#define maskAxisTickName 0x8
#define maskAxisSTLen    0x10
#define maskAxisLTLen    0x20
#define maskAxisTHeight  0x40
#define maskAxisNHeight  0x80
#define maskAxisLogBase  0x100

enum axisType { 
  axisLeft=0,       axisRight,       axisTop,        axisBottom,
  axisBottomLeft=0, axisBottomRight, axisBottomBack, axisBottomFront,
  axisTopLeft,      axisTopRight,    axisTopBack,    axisTopFront, 
  axisFrontLeft,    axisFrontRight,  axisFrontTop,   axisFrontBottom,
  axisBackLeft,     axisBackRight,   axisBackTop,    axisBackBottom,
  axisLeftFront,    axisLeftBack,    axisLeftTop,    axisLeftBottom,
  axisRightFront,   axisRightBack,   axisRightTop,   axisRightBottom };

class xiPipe;

struct xiAxisParam
{
  int      mask;
  double   shortTickLen,longTickLen,titleHeight,numHeight;
  int      nTicks;
  double   from,to,*positions;
  char     *cTitle,**ticks;
  int      logBase;

  xiAxisParam()          { mask=maskAxisNone; cTitle=NULL;
                           nTicks=-1; positions=NULL; 
                           ticks=NULL; }
  ~xiAxisParam();

  xiAxisParam &Range(double _from,double _to)
                         { mask|=maskAxisRange; from=_from; to=_to;
			   return *this; }
  xiAxisParam &ShortTickLen(double stlen)
                         { mask|=maskAxisSTLen; shortTickLen=stlen;
			   return *this; }
  xiAxisParam &LongTickLen(double ltlen)
                         { mask|=maskAxisLTLen; longTickLen=ltlen;
			   return *this; }
  xiAxisParam &TickLen(double stlen,double ltlen)
                         { mask|=(maskAxisSTLen|maskAxisLTLen);
			   shortTickLen=stlen;
			   longTickLen=ltlen; return *this; }
  xiAxisParam &NoTicks() { TickLen(0.0,0.0); return *this; }
  xiAxisParam &TitleHeight(double h)
                         { mask|=maskAxisTHeight; titleHeight=h;
			   return *this; }
  xiAxisParam &NumHeight(double h)
                         { mask|=maskAxisNHeight; numHeight=h; return *this; }
  xiAxisParam &NoNum()   { NumHeight(0.0); return *this; }
  xiAxisParam &Title(const char *);
  xiAxisParam &NoTitle() { Title(NULL); return *this; }
  xiAxisParam &Ticks(int,double *,const char ** =NULL);
  xiAxisParam &LogBase(int _logBase)
                         { mask|=maskAxisLogBase; logBase=_logBase;
			   return *this; }

  // Operators
  xiAxisParam &operator=(const xiAxisParam &);

  friend xiPipe &operator<<(xiPipe &,const xiAxisParam &);
  friend xiPipe &operator>>(xiPipe &,xiAxisParam &);
};

#endif
