
import java.awt.*;
import java.applet.Applet;
import java.util.StringTokenizer;
import java.net.URL;
import java.net.MalformedURLException;

public class YaTicker extends Applet implements Runnable {
  // Parameter infos
  private int       unit = 100;
  private Dimension appletDimension,backDimension;
  private Font      font;
  private FontMetrics fontM;
  private URL       documentURL;
  private Color     borderColor;

  // Actual job infos
  public final static int JOBSTATIC = 0;
  public final static int JOBWARP = 1;
  public final static int JOBDROPIN = 2;
  public final static int JOBDROPOUT = 3;
  public final static int JOBEXPLODEIN = 4;
  public final static int JOBEXPLODEOUT = 5;
  public final static int JOBSPREADIN = 6;
  public final static int JOBSPREADOUT = 7;
  public final static int JOBSAWIN = 8;
  public final static int JOBSAWOUT = 9;
  public final static int JOBSHIFTIN = 10;
  public final static int JOBSHIFTOUT = 11;
  public final static int JOBFALLIN = 12;
  public final static int JOBGLIDEIN = 13;
  public final static int JOBGLIDEOUT = 14;
  public final static int JOBCLEAR = 15;

  private String    actualurl;
  private int       lifetime,type,jobParam1;
  private int       midy;
  private int       plen = 0;
  private int       px[],py[],pdx[],pdy[],pcolor[];
  private char      pchar[];
  private int       oldlen;
  private int       oldx[],oldy[],olddx[],olddy[],oldcolor[];
  private char      oldchar[];

  // Internal use
  private Image     backImage;
  private Graphics  backScreen;
  private Color     color[];
  private Thread    animatorThread = null;  

  // Job list
  private int       njobs=0,maxjobs,actualJob=-1;
  private int       jobs[] = null;
  private String    jobStr[];
  private int       jobTime[];
  private int       jobSpeed[];
  private String    jobUrl[];

  private void addJob(int jtype,String jstr,int jtime,int jspeed,
                      String jurl) {
    if(jobs == null) {
      maxjobs = 100;
      jobs = new int[maxjobs];
      jobStr = new String[maxjobs];
      jobTime = new int[maxjobs];
      jobSpeed = new int[maxjobs];
      jobUrl = new String[maxjobs];
    }
    if(njobs>=maxjobs) {
      maxjobs *= 2;
      int nj[] = new int[maxjobs];
      String njs[] = new String[maxjobs];
      int njt[] = new int[maxjobs];
      int njsp[] = new int[maxjobs];
      String njurl[] = new String[maxjobs];
      for(int i=0;i<njobs;i++) {
        nj[i] = jobs[i];
        njs[i] = jobStr[i];
        njt[i] = jobTime[i];
        njsp[i] = jobSpeed[i];
        njurl[i] = jobUrl[i];
      }
      jobs=nj;
      jobStr=njs;
      jobTime=njt;
      jobSpeed=njsp;
      jobUrl=njs;
    }
    jobs[njobs]=jtype;
    jobStr[njobs]=jstr;
    jobTime[njobs]=jtime;
    jobSpeed[njobs]=jspeed;
    jobUrl[njobs]=jurl;
    njobs++;
  }

  private void nextJob() {
    actualJob++;
    actualJob = actualJob % njobs;

    oldlen = plen;
    oldx = px; oldy = py; olddx = pdx; olddy = pdy; 
    oldchar = pchar; oldcolor = pcolor;

    int x = 0,step,fac;

    if(jobStr[actualJob] == null) {
      plen=0;
      px = py = pdx = pdy = null; pchar = null; pcolor = null;
    } else {
      int len = jobStr[actualJob].length();
      char temp[] = new char[len];
      jobStr[actualJob].getChars(0,len,temp,0);
      int i,col,count = 0;
      for(i=0;i<temp.length;i++)
        if(temp[i]=='\\' && i+1<temp.length) count--;
        else if(temp[i]!=' ') count++;
    
      plen = count;
      pchar = new char[plen];
      pcolor = new int[plen];
      px = new int[plen];
      py = new int[plen];
      pdx = new int[plen];
      pdy = new int[plen];

      i = 0; col = 1; count = 0; 
      while(i<plen && count<temp.length) {
        if(temp[count]=='\\') {
          count++;
          col = temp[count] - '0';
          count++;
        } if(temp[count]==' ') {
          x+=fontM.stringWidth(" ");
          count++;
        } else {
          pchar[i] = temp[count];
          pcolor[i] = col;
          px[i]=x;
          x+=fontM.stringWidth(String.valueOf(pchar[i]));
          py[i]=midy;
          pdx[i]=pdy[i]=0;
          i++;
          count++;
        }
      }
    }

    type = jobs[actualJob];
    lifetime = jobTime[actualJob];
    actualurl = jobUrl[actualJob];
    switch(type) {
      case JOBSTATIC:
        oldlen=0; oldx=oldy=olddx=olddy=null; oldcolor=null; oldchar=null;
        x = (backDimension.width-x)/2;
        for(int i=0;i<plen;i++) px[i]+=x;
        break;
      case JOBWARP:
        jobParam1 = Math.max(backDimension.width,x);
        for(int i=0;i<plen;i++) {
          pdx[i]=-jobSpeed[actualJob];
          pdy[i]=0;
          px[i]+=jobParam1;
        }
        for(int i=0;i<oldlen;i++) {
          olddx[i]=-jobSpeed[actualJob];
          olddy[i]=0;
        }
        break;
      case JOBDROPIN:
        step = (midy/jobTime[actualJob])+1;
        x = (backDimension.width-x)/2;
        for(int i=0;i<plen;i++) {
          px[i]+=x;
          py[i]-=step*jobTime[actualJob];
          pdy[i]=step;
        }
        for(int i=0;i<oldlen;i++) {
          olddx[i]=0;
          olddy[i]=step;
        }
        break;
      case JOBDROPOUT:
        step = (midy/jobTime[actualJob])+1;
        for(int i=0;i<oldlen;i++) {
          olddx[i]=0;
          olddy[i]=step;
        }
        break;
      case JOBEXPLODEIN:
        step = Math.max(backDimension.width,backDimension.height)/8/
                 jobTime[actualJob]+1;
        for(int i=0;i<oldlen;i++) {
          double phi=6.28*Math.random(), r=Math.random()*step+step;
          olddx[i]=(int)(r*Math.cos(phi));
          olddy[i]=(int)(r*Math.sin(phi));
        }
        x = (backDimension.width-x)/2;
        for(int i=0;i<plen;i++) px[i]+=x;
        for(int i=0;i<plen;i++) {
          double phi=6.28*Math.random(), r=Math.random()*step+step;
          pdx[i]=(int)(r*Math.cos(phi));
          pdy[i]=(int)(r*Math.sin(phi));
          px[i]-=pdx[i]*jobTime[actualJob];
          py[i]-=pdy[i]*jobTime[actualJob];
        }
        break;
      case JOBEXPLODEOUT:
        step = Math.max(backDimension.width,backDimension.height)/8/
                 jobTime[actualJob]+1;
        for(int i=0;i<oldlen;i++) {
          double phi=6.28*Math.random(), r=Math.random()*step+step;
          olddx[i]=(int)(r*Math.cos(phi));
          olddy[i]=(int)(r*Math.sin(phi));
        }
        break;
      case JOBSPREADIN:
        step = backDimension.width/2/jobTime[actualJob]+1;
        for(int i=0;i<oldlen/2;i++) {
          olddx[i]=-(step+oldlen/2-1-i);
          olddy[i]=0;
        }
        for(int i=oldlen/2;i<oldlen;i++) {
          olddx[i]=(step+i-oldlen/2);
          olddy[i]=0;
        }
        x = (backDimension.width-x)/2;
        for(int i=0;i<plen;i++) px[i]+=x;
        for(int i=0;i<plen/2;i++) {
          pdx[i]=(step+plen/2-1-i);
          pdy[i]=0;
          px[i]-=pdx[i]*jobTime[actualJob];
        }
        for(int i=plen/2;i<plen;i++) {
          pdx[i]=-(step+i-oldlen/2);
          pdy[i]=0;
          px[i]-=pdx[i]*jobTime[actualJob];
        }
        break;
      case JOBSPREADOUT:
        step = backDimension.width/2/jobTime[actualJob]+1;
        for(int i=0;i<oldlen/2;i++) {
          olddx[i]=-(step+oldlen/2-1-i);
          olddy[i]=0;
        }
        for(int i=oldlen/2;i<oldlen;i++) {
          olddx[i]=(step+i-oldlen/2);
          olddy[i]=0;
        }
        break;
      case JOBSAWIN:
        step = (midy/jobTime[actualJob])+1;
        fac = 1;
        x = (backDimension.width-x)/2;
        for(int i=0;i<plen;i++) {
          px[i]+=x;
          py[i]-=fac*step*jobTime[actualJob];
          pdy[i]=fac*step;
          fac = -fac;
        }
        for(int i=0;i<oldlen;i++) {
          olddx[i]=0;
          olddy[i]=fac*step;
          fac = -fac;
        }
        break;
      case JOBSAWOUT:
        step = (midy/jobTime[actualJob])+1;
        fac = 1;
        for(int i=0;i<oldlen;i++) {
          olddx[i]=0;
          olddy[i]=fac*step;
          fac = -fac;
        }
        break;
      case JOBSHIFTIN:
        x = (backDimension.width-x)/2;
        step = ((backDimension.width-x)/jobTime[actualJob])+1;
        for(int i=0;i<plen;i++) {
          px[i]+=x; py[i]=midy;
          px[i]+=step*jobTime[actualJob];
          pdx[i]=-step;
        }
        for(int i=0;i<oldlen;i++) {
          olddx[i]=-step;
          olddy[i]=0;
        }
        break;
      case JOBSHIFTOUT:
        x = (backDimension.width-x)/2;
        step = ((backDimension.width-x)/jobTime[actualJob])+1;
        for(int i=0;i<oldlen;i++) {
          olddx[i]=-step;
          olddy[i]=0;
        }
        break;
      case JOBFALLIN:
        oldlen=0; oldx=oldy=olddx=olddy=null; oldcolor=null; oldchar=null;
        step = (midy*plen/jobTime[actualJob])+1;
        x = (backDimension.width-x)/2;
        jobParam1=midy;
        for(int i=0;i<plen;i++) {
          px[i]+=x;
          py[i]-=step*(int)((i+1)*jobTime[actualJob]/plen);
          pdy[i]=step;
        }
        break;
      case JOBGLIDEIN:
        step = (midy/jobTime[actualJob])+1;
        x = (backDimension.width-x)/2;
        for(int i=0;i<plen;i++) {
          px[i]+=x;
          py[i]-=(i+1)*step*jobTime[actualJob];
          pdy[i]=(i+1)*step;
        }
        for(int i=0;i<oldlen;i++) {
          olddx[i]=0;
          olddy[i]=(i+1)*step;
        }
        break;
      case JOBGLIDEOUT:
        step = (midy/jobTime[actualJob])+1;
        for(int i=0;i<oldlen;i++) {
          olddx[i]=0;
          olddy[i]=(i+1)*step;
        }
        break;
      case JOBCLEAR:
        oldlen=0; oldx=oldy=olddx=olddy=null; oldcolor=null; oldchar=null;
        break;        
      default:
        break;
    }
  }

  public void addStatic(String jstr,int jtime,String jurl) {
    addJob(JOBSTATIC,jstr,jtime,0,jurl);
  }

  public void addWarp(String jstr,int jtime,int jspeed,String jurl) {
    addJob(JOBWARP,jstr,jtime,jspeed,jurl);
  }

  public void addDropIn(String jstr,int jtime) {
    addJob(JOBDROPIN,jstr,jtime,0,null);
  }

  public void addDropOut(int jtime) {
    addJob(JOBDROPOUT,null,jtime,0,null);
  }

  public void addExplodeIn(String jstr,int jtime) {
    addJob(JOBEXPLODEIN,jstr,jtime,0,null);
  }

  public void addExplodeOut(int jtime) {
    addJob(JOBEXPLODEOUT,null,jtime,0,null);
  }

  public void addSpreadIn(String jstr,int jtime) {
    addJob(JOBSPREADIN,jstr,jtime,0,null);
  }

  public void addSpreadOut(int jtime) {
    addJob(JOBSPREADOUT,null,jtime,0,null);
  }

  public void addSawIn(String jstr,int jtime) {
    addJob(JOBSAWIN,jstr,jtime,0,null);
  }

  public void addSawOut(int jtime) {
    addJob(JOBSAWOUT,null,jtime,0,null);
  }

  public void addShiftIn(String jstr,int jtime) {
    addJob(JOBSHIFTIN,jstr,jtime,0,null);
  }

  public void addShiftOut(int jtime) {
    addJob(JOBSHIFTOUT,null,jtime,0,null);
  }

  public void addFallIn(String jstr,int jtime) {
    addJob(JOBFALLIN,jstr,jtime,0,null);
  }

  public void addGlideIn(String jstr,int jtime) {
    addJob(JOBGLIDEIN,jstr,jtime,0,null);
  }

  public void addGlideOut(int jtime) {
    addJob(JOBGLIDEOUT,null,jtime,0,null);
  }

  public void addClear(int jtime) {
    addJob(JOBCLEAR,null,jtime,0,null);
  }

  private void parseJobs(String str) {
    String lasttext = null;
    StringTokenizer jcmds = new StringTokenizer(str,";\n");
    while(jcmds.hasMoreTokens())
      {
        StringTokenizer jcmd = new StringTokenizer(jcmds.nextToken(),"|");
        String name = jcmd.nextToken();
        if(name != null) {
          name = name.toUpperCase();
          if(name.compareTo("STATIC") == 0 || name.compareTo("WAIT") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                String text = jcmd.nextToken();
                if(jcmd.hasMoreTokens()) {
                  String jurl = jcmd.nextToken();
                  addStatic(text,time,jurl);
                } else
                  addStatic(text,time,null);
                lasttext=text;
              } else if(lasttext != null)
                addStatic(lasttext,time,null);
            }
          } else if(name.compareTo("WAITURL") == 0 && lasttext != null) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                String jurl = jcmd.nextToken();
                addStatic(lasttext,time,jurl);
              }
            }
          } else if(name.compareTo("WARP") == 0) {  
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                int speed = Integer.parseInt(jcmd.nextToken());
                if(jcmd.hasMoreTokens()) {
                  String text = jcmd.nextToken();
                  if(jcmd.hasMoreTokens()) {
                    String jurl = jcmd.nextToken();
                    addWarp(text,time,speed,jurl);
                  } else
                    addWarp(text,time,speed,null);
                  lasttext=text;
                }
              }
            }
          } else if(name.compareTo("DROPIN") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                String text = jcmd.nextToken();
                addDropIn(text,time);
                lasttext=text;
              }
            }
          } else if(name.compareTo("DROPOUT") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              addDropOut(time);
            }
          } else if(name.compareTo("EXPLODEIN") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                String text = jcmd.nextToken();
                addExplodeIn(text,time);
                lasttext=text;
              }
            }
          } else if(name.compareTo("EXPLODEOUT") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              addExplodeOut(time);
              lasttext = null;
            }            
          } else if(name.compareTo("SPREADIN") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                String text = jcmd.nextToken();
                addSpreadIn(text,time);
                lasttext=text;
              }
            }
          } else if(name.compareTo("SPREADOUT") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              addSpreadOut(time);
              lasttext = null;
            }            
          } else if(name.compareTo("SAWIN") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                String text = jcmd.nextToken();
                addSawIn(text,time);
                lasttext=text;
              }
            }
          } else if(name.compareTo("SAWOUT") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              addSawOut(time);
            }
          } else if(name.compareTo("SHIFTIN") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                String text = jcmd.nextToken();
                addShiftIn(text,time);
                lasttext=text;
              }
            }
          } else if(name.compareTo("SHIFTOUT") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              addShiftOut(time);
            }
          } else if(name.compareTo("FALLIN") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                String text = jcmd.nextToken();
                addFallIn(text,time);
                lasttext=text;
              }
            }
          } else if(name.compareTo("GLIDEIN") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              if(jcmd.hasMoreTokens()) {
                String text = jcmd.nextToken();
                addGlideIn(text,time);
                lasttext=text;
              }
            }
          } else if(name.compareTo("GLIDEOUT") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              addGlideOut(time);
            }
          } else if(name.compareTo("CLEAR") == 0) {
            if(jcmd.hasMoreTokens()) {
              int time = Integer.parseInt(jcmd.nextToken());
              addGlideOut(time);
            } else
              addGlideOut(0);
          } else
            System.out.println("unknown command: " + name);
        }
      }
  }

  private Color parseColor(String str,Color def) {
    if(str == null)
      return def;

    StringTokenizer col = new StringTokenizer(str,",");
    if(col.hasMoreTokens()) {
      int r = Integer.parseInt(col.nextToken());
      if(col.hasMoreTokens()) {
        int g = Integer.parseInt(col.nextToken());
  	if(col.hasMoreTokens()) {
          int b = Integer.parseInt(col.nextToken());
          return new Color(r,g,b);
        }
      }
    }
    return def;
  }

  public void init() {
    // Get documentURL
    documentURL = getDocumentBase();

    // Get the Parameters
    String str = getParameter("unit");
    int unit = (str != null) ? Integer.parseInt(str) : 10;

    String fontString = getParameter("font");
    if(fontString == null)
      fontString = "TimesRoman";

    str = getParameter("fontSize");
    int fontSizeInt = (str != null) ? Integer.parseInt(str) : 24;

    str = getParameter("fontStyle");
    int fontStyleInt = Font.PLAIN;
    if(str != null) {
      str = str.toUpperCase();
      if(str.compareTo("BOLD") == 0) fontStyleInt = Font.BOLD;
      else if(str.compareTo("ITALIC") == 0) fontStyleInt = Font.ITALIC;
      else if(str.compareTo("PLAIN") == 0) fontStyleInt = Font.PLAIN;
    }

    str = getParameter("script");

    if(str == null)
      addWarp("This is yet another ticker",-1,5,
              "http://planck.uni-muenster.de:8080/~junglas");
    else
      parseJobs(str);

    // Get all Dimensions
    font = new Font(fontString,fontStyleInt,fontSizeInt);
    fontM = getFontMetrics(font);

    appletDimension = size();
    backDimension = new Dimension(appletDimension.width-12,
                                  appletDimension.height-12);
    midy = (backDimension.height+fontM.getHeight())/2 - 2;

    // Set the Colortable (a really small one)
    color = new Color[8];
    color[0] = parseColor(getParameter("color0"),new Color(0,0,0));
    color[1] = parseColor(getParameter("color1"),new Color(255,255,255));
    color[2] = parseColor(getParameter("color2"),new Color(255,0,0));
    color[3] = parseColor(getParameter("color3"),new Color(0,255,0));
    color[4] = parseColor(getParameter("color4"),new Color(0,0,255));
    color[5] = parseColor(getParameter("color5"),new Color(255,255,0));
    color[6] = parseColor(getParameter("color6"),new Color(0,255,255));
    color[7] = parseColor(getParameter("color7"),new Color(255,0,255));
    borderColor = parseColor(getParameter("border"),new Color(150,150,150));

    backImage = createImage(backDimension.width,backDimension.height);
    backScreen = backImage.getGraphics();
    backScreen.setFont(font);
    backScreen.setColor(color[0]);
    backScreen.fillRect(0,0,backDimension.width,backDimension.height);

    nextJob();
  }

  public void start() {
    if(animatorThread == null)
      animatorThread = new Thread(this);
    animatorThread.start();
  }

  public void stop() {
    animatorThread = null;
  }

  public void run() {
//    Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
    long startTime = System.currentTimeMillis();

    while (Thread.currentThread() == animatorThread) {
      for(int i=0;i<plen;i++) {
        px[i]+=pdx[i];
        py[i]+=pdy[i]; }
      for(int i=0;i<oldlen;i++) {
        oldx[i]+=olddx[i];
        oldy[i]+=olddy[i]; }
      if(type == JOBWARP) {
        for(int i=0;i<plen;i++)
          if(px[i]<0) px[i]+=jobParam1;
        for(int i=0;i<oldlen;i++)
          if(oldx[i]<0) oldx[i]+=jobParam1;
      } else if(type == JOBFALLIN) {
        for(int i=0;i<plen;i++)
          if(py[i]>=jobParam1) pdy[i]=0;
      }
        
      repaint();
      if(lifetime > 0) lifetime--;
      if(lifetime == 0) nextJob();
      try { startTime += unit;
            Thread.sleep(Math.max(0,startTime-System.currentTimeMillis()));
      } catch (InterruptedException e) { break; }
    }
  }

  public void update(Graphics g) {
    backScreen.setColor(color[0]);
    backScreen.fillRect(0,0,backDimension.width,backDimension.height);
    for(int i=0;i<plen;i++) {
      backScreen.setColor(color[pcolor[i]]);
      backScreen.drawChars(pchar,i,1,px[i],py[i]);
    }
    for(int i=0;i<oldlen;i++) {
      backScreen.setColor(color[oldcolor[i]]);
      backScreen.drawChars(oldchar,i,1,oldx[i],oldy[i]);
    }
    paint(g);
  }

  public void paint(Graphics g) {
    g.setColor(borderColor);
    for(int i=0;i<3;i++)
      g.draw3DRect(i,i,appletDimension.width-2*i,appletDimension.height-2*i-1,
                   true);
    for(int i=3;i<6;i++)
      g.draw3DRect(i,i,appletDimension.width-2*i,appletDimension.height-2*i-1,
                   false);
    g.drawImage(backImage,6,6,this);
  }

  public boolean mouseDown(Event evt, int x, int y) {
    if(actualurl != null) {
      try {
        URL url = new URL(documentURL,actualurl);
        getAppletContext().showDocument(url);
      } catch (MalformedURLException e) { showStatus("BAD URL"); }
    }
    return true;
  }

  public boolean mouseEnter(Event evt, int x, int y) {
    showStatus("YaTicker (junglas@uni-muenster.de)");
    return true;
  }
}

