#!/usr/bin/make

# xdome.mak Version 0.4.0. Compile xdome.c.
# Copyright (C) 2004-2010 dondalah721@yahoo.com (Dondalah)

# Xdome is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# Xdome is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	51 Franklin St, Fifth Floor
# 	Boston, MA  02110-1301, USA

# Make sure that the Debian font package xfonts-base
# is installed on your system.  Or have the equivalent
# of xfonts-base installed.

# Debian font
################################ for VGA 640x480
################################ XFONT=\"7x13\"
################################ for XGA 1024x768
################################ XFONT=\"10x20\"
XFONT=\"10x20\"

# uncomment if you want the dome window in
# the upper left of your virtual desktop
# UPPERLEFT=-D UPPERLEFT

OBJ=xdome.o \
	domeinit.o \
	domefree.o \
	bld.o \
	calc_c1.o \
	calc_c1i.o \
	c1i_front.o \
	c1i_front_top.o \
	c1i_front_side.o \
	c1i_back.o \
	c1i_back_top.o \
	c1i_back_side.o \
	c1i_top.o \
	c1i_top_top.o \
	c1i_top_side.o \
	calc_c1o.o \
	c1o_front.o \
	c1o_front_top.o \
	c1o_back.o \
	c1o_back_top.o \
	c1o_top.o \
	c1o_top_top.o \
	calc_c1t.o \
	c1t_front.o \
	c1t_front_top.o \
	c1t_front_side.o \
	c1t_back.o \
	c1t_back_top.o \
	c1t_back_side.o \
	c1t_top.o \
	c1t_top_top.o \
	calc_c2.o \
	calc_c2i.o \
	c2i_front.o \
	c2i_front_top.o \
	c2i_front_side.o \
	c2i_front_ne.o \
	c2i_front_se.o \
	c2i_front_sw.o \
	c2i_front_nw.o \
	c2i_front_fg.o \
	c2i_back.o \
	c2i_back_top.o \
	c2i_back_side.o \
	c2i_back_ne.o \
	c2i_back_se.o \
	c2i_back_sw.o \
	c2i_back_nw.o \
	c2i_back_fg.o \
	c2i_top.o \
	c2i_top_top.o \
	c2i_top_side.o \
	c2i_top_ne.o \
	c2i_top_se.o \
	c2i_top_sw.o \
	c2i_top_nw.o \
	c2i_top_fg.o \
	calc_c2o.o \
	c2o_front.o \
	c2o_front_top.o \
	c2o_front_side.o \
	c2o_front_east.o \
	c2o_front_south.o \
	c2o_front_west.o \
	c2o_back.o \
	c2o_back_top.o \
	c2o_back_side.o \
	c2o_back_east.o \
	c2o_back_south.o \
	c2o_back_west.o \
	c2o_top.o \
	c2o_top_top.o \
	c2o_top_side.o \
	c2o_top_east.o \
	c2o_top_west.o \
	calc_c2t.o \
	c2t_front.o \
	c2t_front_top.o \
	c2t_front_side.o \
	c2t_front_east.o \
	c2t_front_west.o \
	c2t_front_fg.o \
	c2t_back.o \
	c2t_back_top.o \
	c2t_back_side.o \
	c2t_back_east.o \
	c2t_back_west.o \
	c2t_back_fg.o \
	c2t_top.o \
	c2t_top_top.o \
	c2t_top_side.o \
	c2t_top_east.o \
	c2t_top_west.o \
	c2t_top_fg.o \
	drawchord.o \
	getkey.o \
	ifkey.o \
	initx.o \
	shwmenu.o \
	slow.o \
	slp.o

CC=gcc

CFLAGS=-c -Wall -O6 -I/usr/X11R6/include/X11 \
        -DFONT=$(XFONT) \
	$(UPPERLEFT)

LDFLAGS=-L/usr/X11R6/lib -lX11 -L. -lxdome -lm

all:		$(OBJ) libxdome.a xdome xdome.mak

xdome:		$(OBJ)
	$(CC) -Wall -O6 xdome.o -o xdome $(LDFLAGS)

libxdome.a:		$(OBJ)
	rm -f libxdome.a
	ar r libxdome.a $(OBJ)

xdome.o:		xdome.c
	$(CC) $(CFLAGS) xdome.c

domeinit.o:		domeinit.c
	$(CC) $(CFLAGS) domeinit.c

domefree.o:		domefree.c
	$(CC) $(CFLAGS) domefree.c

bld.o:		bld.c
	$(CC) $(CFLAGS) bld.c

calc_c1.o:		calc_c1.c
	$(CC) $(CFLAGS) calc_c1.c

calc_c1i.o:		calc_c1i.c
	$(CC) $(CFLAGS) calc_c1i.c

c1i_front.o:		c1i_front.c
	$(CC) $(CFLAGS) c1i_front.c

c1i_front_top.o:	c1i_front_top.c
	$(CC) $(CFLAGS) c1i_front_top.c

c1i_front_side.o:	c1i_front_side.c
	$(CC) $(CFLAGS) c1i_front_side.c

c1i_back.o:		c1i_back.c
	$(CC) $(CFLAGS) c1i_back.c

c1i_back_top.o:		c1i_back_top.c
	$(CC) $(CFLAGS) c1i_back_top.c

c1i_back_side.o:	c1i_back_side.c
	$(CC) $(CFLAGS) c1i_back_side.c

c1i_top.o:		c1i_top.c
	$(CC) $(CFLAGS) c1i_top.c

c1i_top_top.o:		c1i_top_top.c
	$(CC) $(CFLAGS) c1i_top_top.c

c1i_top_side.o:		c1i_top_side.c
	$(CC) $(CFLAGS) c1i_top_side.c

calc_c1o.o:		calc_c1o.c
	$(CC) $(CFLAGS) calc_c1o.c

c1o_front.o:		c1o_front.c
	$(CC) $(CFLAGS) c1o_front.c

c1o_front_top.o:	c1o_front_top.c
	$(CC) $(CFLAGS) c1o_front_top.c

c1o_back.o:		c1o_back.c
	$(CC) $(CFLAGS) c1o_back.c

c1o_back_top.o:		c1o_back_top.c
	$(CC) $(CFLAGS) c1o_back_top.c

c1o_top.o:		c1o_top.c
	$(CC) $(CFLAGS) c1o_top.c

c1o_top_top.o:		c1o_top_top.c
	$(CC) $(CFLAGS) c1o_top_top.c

calc_c1t.o:		calc_c1t.c
	$(CC) $(CFLAGS) calc_c1t.c

c1t_front.o:		c1t_front.c
	$(CC) $(CFLAGS) c1t_front.c

c1t_front_top.o:	c1t_front_top.c
	$(CC) $(CFLAGS) c1t_front_top.c

c1t_front_side.o:	c1t_front_side.c
	$(CC) $(CFLAGS) c1t_front_side.c

c1t_back.o:		c1t_back.c
	$(CC) $(CFLAGS) c1t_back.c

c1t_back_top.o:		c1t_back_top.c
	$(CC) $(CFLAGS) c1t_back_top.c

c1t_back_side.o:	c1t_back_side.c
	$(CC) $(CFLAGS) c1t_back_side.c

c1t_top.o:		c1t_top.c
	$(CC) $(CFLAGS) c1t_top.c

c1t_top_top.o:		c1t_top_top.c
	$(CC) $(CFLAGS) c1t_top_top.c

calc_c2.o:		calc_c2.c
	$(CC) $(CFLAGS) calc_c2.c

calc_c2i.o:		calc_c2i.c
	$(CC) $(CFLAGS) calc_c2i.c

c2i_front.o:		c2i_front.c
	$(CC) $(CFLAGS) c2i_front.c

c2i_front_top.o:	c2i_front_top.c
	$(CC) $(CFLAGS) c2i_front_top.c

c2i_front_side.o:	c2i_front_side.c
	$(CC) $(CFLAGS) c2i_front_side.c

c2i_front_ne.o:		c2i_front_ne.c
	$(CC) $(CFLAGS) c2i_front_ne.c

c2i_front_se.o:		c2i_front_se.c
	$(CC) $(CFLAGS) c2i_front_se.c

c2i_front_sw.o:		c2i_front_sw.c
	$(CC) $(CFLAGS) c2i_front_sw.c

c2i_front_nw.o:		c2i_front_nw.c
	$(CC) $(CFLAGS) c2i_front_nw.c

c2i_front_fg.o:		c2i_front_fg.c
	$(CC) $(CFLAGS) c2i_front_fg.c

c2i_back.o:		c2i_back.c
	$(CC) $(CFLAGS) c2i_back.c

c2i_back_top.o:		c2i_back_top.c
	$(CC) $(CFLAGS) c2i_back_top.c

c2i_back_side.o:	c2i_back_side.c
	$(CC) $(CFLAGS) c2i_back_side.c

c2i_back_ne.o:		c2i_back_ne.c
	$(CC) $(CFLAGS) c2i_back_ne.c

c2i_back_se.o:		c2i_back_se.c
	$(CC) $(CFLAGS) c2i_back_se.c

c2i_back_sw.o:		c2i_back_sw.c
	$(CC) $(CFLAGS) c2i_back_sw.c

c2i_back_nw.o:		c2i_back_nw.c
	$(CC) $(CFLAGS) c2i_back_nw.c

c2i_back_fg.o:		c2i_back_fg.c
	$(CC) $(CFLAGS) c2i_back_fg.c

c2i_top.o:		c2i_top.c
	$(CC) $(CFLAGS) c2i_top.c

c2i_top_top.o:		c2i_top_top.c
	$(CC) $(CFLAGS) c2i_top_top.c

c2i_top_side.o:		c2i_top_side.c
	$(CC) $(CFLAGS) c2i_top_side.c

c2i_top_ne.o:		c2i_top_ne.c
	$(CC) $(CFLAGS) c2i_top_ne.c

c2i_top_se.o:		c2i_top_se.c
	$(CC) $(CFLAGS) c2i_top_se.c

c2i_top_sw.o:		c2i_top_sw.c
	$(CC) $(CFLAGS) c2i_top_sw.c

c2i_top_nw.o:		c2i_top_nw.c
	$(CC) $(CFLAGS) c2i_top_nw.c

c2i_top_fg.o:		c2i_top_fg.c
	$(CC) $(CFLAGS) c2i_top_fg.c

calc_c2o.o:		calc_c2o.c
	$(CC) $(CFLAGS) calc_c2o.c

c2o_front.o:		c2o_front.c
	$(CC) $(CFLAGS) c2o_front.c

c2o_front_top.o:	c2o_front_top.c
	$(CC) $(CFLAGS) c2o_front_top.c

c2o_front_side.o:	c2o_front_side.c
	$(CC) $(CFLAGS) c2o_front_side.c

c2o_front_east.o:	c2o_front_east.c
	$(CC) $(CFLAGS) c2o_front_east.c

c2o_front_south.o:	c2o_front_south.c
	$(CC) $(CFLAGS) c2o_front_south.c

c2o_front_west.o:	c2o_front_west.c
	$(CC) $(CFLAGS) c2o_front_west.c

c2o_back.o:		c2o_back.c
	$(CC) $(CFLAGS) c2o_back.c

c2o_back_top.o:		c2o_back_top.c
	$(CC) $(CFLAGS) c2o_back_top.c

c2o_back_side.o:	c2o_back_side.c
	$(CC) $(CFLAGS) c2o_back_side.c

c2o_back_east.o:	c2o_back_east.c
	$(CC) $(CFLAGS) c2o_back_east.c

c2o_back_south.o:	c2o_back_south.c
	$(CC) $(CFLAGS) c2o_back_south.c

c2o_back_west.o:	c2o_back_west.c
	$(CC) $(CFLAGS) c2o_back_west.c

c2o_top.o:		c2o_top.c
	$(CC) $(CFLAGS) c2o_top.c

c2o_top_top.o:		c2o_top_top.c
	$(CC) $(CFLAGS) c2o_top_top.c

c2o_top_side.o:		c2o_top_side.c
	$(CC) $(CFLAGS) c2o_top_side.c

c2o_top_east.o:		c2o_top_east.c
	$(CC) $(CFLAGS) c2o_top_east.c

c2o_top_west.o:		c2o_top_west.c
	$(CC) $(CFLAGS) c2o_top_west.c

calc_c2t.o:		calc_c2t.c
	$(CC) $(CFLAGS) calc_c2t.c

c2t_front.o:		c2t_front.c
	$(CC) $(CFLAGS) c2t_front.c

c2t_front_top.o:	c2t_front_top.c
	$(CC) $(CFLAGS) c2t_front_top.c

c2t_front_side.o:	c2t_front_side.c
	$(CC) $(CFLAGS) c2t_front_side.c

c2t_front_east.o:	c2t_front_east.c
	$(CC) $(CFLAGS) c2t_front_east.c

c2t_front_west.o:	c2t_front_west.c
	$(CC) $(CFLAGS) c2t_front_west.c

c2t_front_fg.o:		c2t_front_fg.c
	$(CC) $(CFLAGS) c2t_front_fg.c

c2t_back.o:		c2t_back.c
	$(CC) $(CFLAGS) c2t_back.c

c2t_back_top.o:		c2t_back_top.c
	$(CC) $(CFLAGS) c2t_back_top.c

c2t_back_side.o:	c2t_back_side.c
	$(CC) $(CFLAGS) c2t_back_side.c

c2t_back_east.o:	c2t_back_east.c
	$(CC) $(CFLAGS) c2t_back_east.c

c2t_back_west.o:	c2t_back_west.c
	$(CC) $(CFLAGS) c2t_back_west.c

c2t_back_fg.o:		c2t_back_fg.c
	$(CC) $(CFLAGS) c2t_back_fg.c

c2t_top.o:		c2t_top.c
	$(CC) $(CFLAGS) c2t_top.c

c2t_top_top.o:		c2t_top_top.c
	$(CC) $(CFLAGS) c2t_top_top.c

c2t_top_side.o:		c2t_top_side.c
	$(CC) $(CFLAGS) c2t_top_side.c

c2t_top_east.o:		c2t_top_east.c
	$(CC) $(CFLAGS) c2t_top_east.c

c2t_top_west.o:		c2t_top_west.c
	$(CC) $(CFLAGS) c2t_top_west.c

c2t_top_fg.o:		c2t_top_fg.c
	$(CC) $(CFLAGS) c2t_top_fg.c

drawchord.o:		drawchord.c
	$(CC) $(CFLAGS) drawchord.c

getkey.o:		getkey.c
	$(CC) $(CFLAGS) getkey.c

ifkey.o:		ifkey.c
	$(CC) $(CFLAGS) ifkey.c

initx.o:		initx.c
	$(CC) $(CFLAGS) initx.c

shwmenu.o:		shwmenu.c
	$(CC) $(CFLAGS) shwmenu.c

slow.o:			slow.c
	$(CC) $(CFLAGS) slow.c

slp.o:			slp.c
	$(CC) $(CFLAGS) slp.c

clean:
	rm -f xdome libxdome.a $(OBJ)
