/*
xdome.h Version 0.4.0. xdome header file
Copyright (C) 2004-2010 dondalah721@yahoo.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

/* to define the escape key */
/* and other special keys */
#define XK_MISCELLANY 1
#define XK_LATIN1 1

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <string.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <X11/Xlib.h>
#include <X11/keysymdef.h>
#include <assert.h>
#include <unistd.h>
#include <math.h>

/* Debian font */
/* This font requires the Debian xfonts-base */
/* package to be installed. */
/* for VGA 640x480     */
/* #define FONT "7x13" */
/* for XGA 1024x768    */
/* #define FONT "10x20" */

/* The font is defined in xdome.mak */

#define NIL (0)
#define SCRW 1020
#define SCRH 760
#define LFTMARG  20
#define IMGSZ  750
#define RADIUS 360

/******************** VGA 640x480             ***********************/
/******************** #define SCRW 620        ***********************/
/******************** #define SCRH 420        ***********************/
/******************** #define LFTMARG  10     ***********************/
/******************** #define IMGSZ  410      ***********************/
/******************** #define RADIUS 200      ***********************/

/******************** XGA 1024x768            ***********************/
/******************** #define SCRW 1020       ***********************/
/******************** #define SCRH 760        ***********************/
/******************** #define LFTMARG  20     ***********************/
/******************** #define IMGSZ  750      ***********************/
/******************** #define RADIUS 300      ***********************/

#define CLASS_I  0
#define CLASS_II 1
/* polyhedron */
#define ICOSA    0
#define OCTA     1
#define TETRA    2
/* view */
#define FRONT    0
#define BACK     1
#define TOP      2
/* rotation direction */
#define LEFT     0
#define RIGHT    1
#define UP       2
#define DOWN     3
#define CCLKWISE 4
#define CLKWISE  5
/* array sizes */
#define TOTNODES  1700
#define TOTSTRUTS 5100
/* slightly larger than a frequency 32 icosahedron */
#define MAXSTR    32768
#define PGHGTH    792
#define PGWDTH    612

typedef struct xwfmt {
   int whiteColor;
   int blackColor;
   int runflg;
   int pause;
   int drawsw;
   unsigned long red;
   unsigned long blue;
   Display *dpy;
   Window w;
   GC gc;
   Font fontid;
   Screen *dfltscr;
   Colormap cmap;
   XColor scrdef;
   XColor exctdef;
   int rootww;
   int rootwh;
   int dpywdth;
   int dpyhght;
   int class;
   int dometype;
   int freq;
   int view;
   int bball;
   int pscript;     /* used for Postscript hard copy */
   int pshndl;      /* handle for Postscript hard copy */
   int wtfact;
   int shift;       /* used for shift F1-F4 */
   int totvtx;
   int totnode;
   int totstr;
   int tottri;      /* total triangles */
   double imgsz;
   double radius;
   double lftmarg;
   double ecc;
   double hrot;
   double vrot;
   double spin;
   double d2r;
   double r2d;
   double rad12;
   double rad18;
   double rad36;
   double rad45;
   double rad54;
   double rad60;
   double rad72;
   double rad90;
   double rad108;
   double rad120;
   double rad135;
   double rad144;
   double rad180;
   double rad216;
   double rad240;
   double rad288;
   double sin72;
   double cos36;
   double cos72;
   double tau;
   double oneovertau;
   double halffreq;
   unsigned char *byplst;
   char *font;
   int *vtxfrom;
   int *vtxto;
   int *topfrom;    /* top          vertex of triangle */
   int *leftto;     /* bottom left  vertex of triangle */
   int *rghtto;     /* bottom right vertex of triangle */
   int *bbmidpt;    /* buckyball mid point */
   double *philst;
   double *thetalst;
   double *philow;
   double *thetalow;
   double *phifrom;
   double *thetafrom;
   double *phito;
   double *thetato;
   double *eccx1;
   double *eccy1;
   double *eccz1;
   double *eccx2;
   double *eccy2;
   double *eccz2;
   } xwfmt;

void getkey(xwfmt *xw);

void ifkey(xwfmt *xw);

void initx(xwfmt *xw,
   char *pgm);

void domeinit(xwfmt *xw);

void domefree(xwfmt *xw);

void slow(xwfmt *xw);

void slp(xwfmt *xw);

void shwmenu(xwfmt *xw);

void drawchord(xwfmt *xw,
   double phi1,
   double theta1,
   double phi2,
   double theta2);

void bld(xwfmt *xw);

void calc_c1(xwfmt *xw);

void calc_c1i(xwfmt *xw);

void c1i_front(xwfmt *xw);

void c1i_front_top(xwfmt *xw);

void c1i_front_side(xwfmt *xw);

void c1i_back(xwfmt *xw);

void c1i_back_top(xwfmt *xw);

void c1i_back_side(xwfmt *xw);

void c1i_top(xwfmt *xw);

void c1i_top_top(xwfmt *xw);

void c1i_top_side(xwfmt *xw);

void calc_c1o(xwfmt *xw);

void c1o_front(xwfmt *xw);

void c1o_front_top(xwfmt *xw);

void c1o_back(xwfmt *xw);

void c1o_back_top(xwfmt *xw);

void c1o_top(xwfmt *xw);

void c1o_top_top(xwfmt *xw);

void calc_c1t(xwfmt *xw);

void c1t_front(xwfmt *xw);

void c1t_front_top(xwfmt *xw);

void c1t_front_side(xwfmt *xw);

void c1t_back(xwfmt *xw);

void c1t_back_top(xwfmt *xw);

void c1t_back_side(xwfmt *xw);

void c1t_top(xwfmt *xw);

void c1t_top_top(xwfmt *xw);

void calc_c2(xwfmt *xw);

void calc_c2i(xwfmt *xw);

void c2i_front(xwfmt *xw);

void c2i_front_top(xwfmt *xw);

void c2i_front_side(xwfmt *xw);

void c2i_front_ne(xwfmt *xw);

void c2i_front_se(xwfmt *xw);

void c2i_front_sw(xwfmt *xw);

void c2i_front_nw(xwfmt *xw);

void c2i_front_fg(xwfmt *xw);

void c2i_back(xwfmt *xw);

void c2i_back_top(xwfmt *xw);

void c2i_back_side(xwfmt *xw);

void c2i_back_ne(xwfmt *xw);

void c2i_back_se(xwfmt *xw);

void c2i_back_sw(xwfmt *xw);

void c2i_back_nw(xwfmt *xw);

void c2i_back_fg(xwfmt *xw);

void c2i_top(xwfmt *xw);

void c2i_top_top(xwfmt *xw);

void c2i_top_side(xwfmt *xw);

void c2i_top_ne(xwfmt *xw);

void c2i_top_se(xwfmt *xw);

void c2i_top_sw(xwfmt *xw);

void c2i_top_nw(xwfmt *xw);

void c2i_top_fg(xwfmt *xw);

void calc_c2o(xwfmt *xw);

void c2o_front(xwfmt *xw);

void c2o_front_top(xwfmt *xw);

void c2o_front_side(xwfmt *xw);

void c2o_front_east(xwfmt *xw);

void c2o_front_south(xwfmt *xw);

void c2o_front_west(xwfmt *xw);

void c2o_back(xwfmt *xw);

void c2o_back_top(xwfmt *xw);

void c2o_back_side(xwfmt *xw);

void c2o_back_east(xwfmt *xw);

void c2o_back_south(xwfmt *xw);

void c2o_back_west(xwfmt *xw);

void c2o_top(xwfmt *xw);

void c2o_top_top(xwfmt *xw);

void c2o_top_side(xwfmt *xw);

void c2o_top_east(xwfmt *xw);

void c2o_top_west(xwfmt *xw);

void calc_c2t(xwfmt *xw);

void c2t_front(xwfmt *xw);

void c2t_front_top(xwfmt *xw);

void c2t_front_side(xwfmt *xw);

void c2t_front_east(xwfmt *xw);

void c2t_front_west(xwfmt *xw);

void c2t_front_fg(xwfmt *xw);

void c2t_back(xwfmt *xw);

void c2t_back_top(xwfmt *xw);

void c2t_back_side(xwfmt *xw);

void c2t_back_east(xwfmt *xw);

void c2t_back_west(xwfmt *xw);

void c2t_back_fg(xwfmt *xw);

void c2t_top(xwfmt *xw);

void c2t_top_top(xwfmt *xw);

void c2t_top_side(xwfmt *xw);

void c2t_top_east(xwfmt *xw);

void c2t_top_west(xwfmt *xw);

void c2t_top_fg(xwfmt *xw);
