/*
shwmenu.c Version 0.4.0. Display menu on screen
Copyright (C) 2004-2010 dondalah721@yahoo.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

#include "xdome.h"

void shwmenu(xw)
xwfmt *xw;
   {
   int jmp;
   int row,dest;
   int col;
   int pgfact;
   char wtstr[64];
   char eccstr[64];
   char str[128];
   char classname[64];
   char hedraname[64];
   char viewname[64];

   /****************** XGA         *******************/
   /****************** 1024x768    *******************/
   /****************** jmp = 30;   *******************/
   /****************** row = 40;   *******************/
   /****************** col = 770;  *******************/

   /****************** VGA         *******************/
   /****************** 640x480     *******************/
   /****************** jmp = 15;   *******************/
   /****************** row = 20;   *******************/
   /****************** col = 440;  *******************/

   if (xw->dpywdth < 700)
      {
      jmp = 15;
      row = 20;
      col = xw->dpywdth - 200;
      } /* if VGA */
   else
      {
      jmp = 30;
      row = 40;
      col = xw->dpywdth - 250;
      } /* if XGA */

   dest = SCRW - 1;
   XSetForeground(xw->dpy, xw->gc, xw->whiteColor);
   XFillRectangle(xw->dpy,xw->w,xw->gc,col,0,160,400);
   XSetForeground(xw->dpy, xw->gc, xw->blackColor);
   XSetBackground(xw->dpy, xw->gc, xw->whiteColor);
   if (xw->class == CLASS_I)
      strcpy(classname,"I");
   else if (xw->class == CLASS_II)
      strcpy(classname,"II");
   else
      {
      fprintf(stderr,"Invalid class %d\n", xw->class);
      exit(1);
      } /* bad class */
   if (xw->dometype == ICOSA)
      strcpy(hedraname,"Icosahedron");
   else if (xw->dometype == OCTA)
      strcpy(hedraname,"Octahedron");
   else if (xw->dometype == TETRA)
      strcpy(hedraname,"Tetrahedron");
   else
      {
      fprintf(stderr,"Invalid dometype %d\n", xw->dometype);
      exit(1);
      } /* bad dometype */
   if (xw->view == FRONT)
      strcpy(viewname,"Front");
   else if (xw->view == BACK)
      {
      if (xw->dometype == OCTA)
         strcpy(viewname,"Side");
      else
	 strcpy(viewname,"Back");
      } /* if view is BACK */
   else if (xw->view == TOP)
      strcpy(viewname,"Top");
   else
      {
      fprintf(stderr,"Invalid view %d\n", xw->view);
      exit(1);
      } /* bad view */
   sprintf(str,"Class %s %s",
      classname, hedraname);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"Freq %d %s View",
      xw->freq, viewname);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   wtstr[0] = eccstr[0] = '\0';
   if (xw->ecc != 1.0)
      {
      sprintf(eccstr,"Elipse %4.2f",
	 xw->ecc);
      } /* if eccentric */
   if (xw->wtfact)
      {
      if (xw->wtfact == 1)
         sprintf(wtstr,"Speed 1");
      else
         sprintf(wtstr,"Speed 1/%d",
	    xw->wtfact);
      } /* if wtfact != 0 */
   if (xw->wtfact || xw->ecc != 1.0)
      {
      strcpy(str,wtstr);
      if (xw->wtfact && xw->ecc != 1.0)
         strcat(str," ");
      strcat(str,eccstr);
      XDrawImageString(xw->dpy,xw->w,xw->gc,
	 col,row,str,strlen(str));
      row += jmp;
      } /* if slow or eccentric */
   row += jmp;
   sprintf(str,"Insert) Class I");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"Delete) Class II");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
	    /* ....+....1....+....2....+....3....+....4   */
   sprintf(str,"Tab)       Polyhedron");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"Backspace) Polyhedron");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
	    /* ....+....1....+....2....+....3....+....4   */
   sprintf(str,"Up)   Frequency-1");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"Down) Frequency+1");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   if (xw->bball) pgfact = 6;
   else pgfact = 8;
   sprintf(str,"PageUp)   Frequency+%d", pgfact);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"PageDown) Frequency+%d", pgfact);
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"Right) Next View");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"Left)  Prev View");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"F1) Speed");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"F2, F3) H V Elipse");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"F4) Buckyball");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"Shift F1-F4) Reset");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"Return) Draw Image");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   sprintf(str,"q) Quit");
   XDrawImageString(xw->dpy,xw->w,xw->gc,
      col,row,str,strlen(str));
   row += jmp;
   } /* shwmenu */
