/*
psinit.c Version 0.4.0. Initialize postscript file
Copyright (C) 2006-2010 dondalah721@yahoo.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

#include "xdome.h"

void psinit(xwfmt *xw)
   {
   double fromexx;
   double fromwyy;
   double toexx;
   double towyy;
   double totwdth;
   double tothght;
   double mtxwdth;
   double mtxhght;
   double red;
   double green;
   double blue;
   if (xw->pshndl != 0) return;
   else
      {
      xw->pshndl = open("xdome.ps",
   	   O_WRONLY|O_APPEND,
	   S_IWUSR)
      if (xw->pshndl < 1)
         {
         fprintf(stderr,"psinit: error opening "
            "xdome.ps\n");
         return();
         } /* open error */
      } /* else xw->pshndl closed */
   xw->pscript = 1;
   xw->seq = 0;
   xw->lmarg = LMARG;
   xw->tmarg = TMARG;
   if (xw->totrow > xw->totcol)
      {
      tothght = xw->pghght - xw->tmarg - xw->tmarg;
      mtxhght = tothght - xw->lmarg - xw->lmarg;
      xw->sz = mtxhght / xw->totrow;
      xw->halfsz = xw->sz * 0.5;
      totwdth = (xw->sz * xw->totcol)
	 + xw->lmarg + xw->lmarg;
      xw->dlmarg = (xw->pgwdth - totwdth) * 0.5;
      xw->dtmarg = xw->tmarg;
      } /* if landscape shape */
   else
      {
      totwdth = xw->pgwdth - xw->lmarg - xw->lmarg;
      mtxwdth = totwdth - xw->lmarg - xw->lmarg;
      xw->sz = mtxwdth / xw->totcol;
      xw->halfsz = xw->sz * 0.5;
      tothght = (xw->sz * xw->totrow)
	 + xw->lmarg + xw->lmarg;
      xw->dlmarg = xw->lmarg;
      xw->dtmarg = (xw->pghght - tothght) * 0.5;
      } /* if portrait shape */
   xw->page = 0;
   xw->col  = 1.0;
   xw->row  = 1.0;
   xw->color = 'B';
   xw->gray  = (double) 0.80;
   printf("%%!PS-Adobe-1.0\n");
   printf("%%%%Creator: Copyright "
      "2006-2010 dondalah721@yahoo.com "
      "(Dondalah)\n");
   printf("%%%%Title: xdome Version 0.4.0\n");
   printf("%%%%CreationDate: Sun Jan 1 "
      "00:00:00 2010\n");
   printf("%%%%Pages: 0\n");
   printf("%%%%PageOrder: Ascending\n");
   printf("%%%%BoundingBox: 0 0 %.0f %.0f\n",
      xw->pgwdth, xw->pghght);
   printf("%%%%DocumentFonts: Times-Roman\n");
   printf("%%%%EndComments\n");
   printf("\n%% Copying this Postscript program:\n");

   printf("\n%% xdome is free software; "
      "you can redistribute it and/or\n");
   printf("%% modify it under the terms of "
      "the GNU General Public License\n");
   printf("%% as published by the Free Software "
      "Foundation; either version 2\n");
   printf("%% of the License, or (at your "
      "option) any later version.\n");

   printf("\n%% xdome is distributed in the "
      "hope that it will be useful,\n");
   printf("%% but WITHOUT ANY WARRANTY; without "
      "even the implied warranty of\n");
   printf("%% MERCHANTABILITY or FITNESS FOR "
      "A PARTICULAR PURPOSE.  See the\n");
   printf("%% GNU General Public License "
      "for more details.\n");

   printf("%% You should have received a "
      "copy of the GNU General Public License\n");
   printf("%% along with this Postscript "
      "program; if not, write to:\n");

   printf("\n%% 	Free Software Foundation, Inc.\n");
   printf("%% 	51 Franklin St, Fifth Floor\n");
   printf("%% 	Boston, MA  02110-1301, USA\n");

   printf("\n%% Description:\n");
   printf("%% Postscript program to print "
      "and display\n");
   printf("%% a geodesic dome\n");

   printf("\n/Helvetica findfont       "
      "%% Get the basic font\n");
   printf("20 scalefont              "
      "%% Scale the font to 20 points\n");
   printf("setfont                   "
      "%% Make it the current font\n");
   printf("\nnewpath                   "
      "%% Start a new path\n");
   printf("\n1.0 setlinewidth          "
      "%% Set line width\n");
   printf("%% total cols %f\n", xw->totcol);
   printf("%% total rows %f\n", xw->totrow);
   printf("%% point size %f\n", xw->sz);
   printf("%% half point size %f\n", xw->halfsz);
   printf("\n%%%%Page: 1 0\n\n");
   printf("1.00 setgray\n");
   printf("gsave newpath\n");
   fromexx = xw->dlmarg;
   fromwyy = xw->pghght - xw->dtmarg;
   printf("%f %f moveto\n", fromexx, fromwyy);
   toexx   = xw->dlmarg + totwdth;
   towyy   = fromwyy;
   printf("%f %f lineto\n", toexx, towyy);
   towyy   = xw->pghght - xw->dtmarg - tothght;
   printf("%f %f lineto\n", toexx, towyy);
   toexx   = xw->dlmarg;
   printf("%f %f lineto\n", toexx, towyy);
   towyy = xw->pghght - xw->dtmarg;
   printf("%f %f lineto\n", toexx, towyy);
   printf("closepath fill stroke grestore\n");
   } /* psinit */
