/*
getkey.c Version 0.4.0. Wait for keyboard input and read key
Copyright (C) 2004-2010 dondalah721@yahoo.com (Dondalah)

Xdome is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

Xdome is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	51 Franklin St, Fifth Floor
	Boston, MA  02110-1301, USA
*/

#include "xdome.h"

void getkey(xw)
xwfmt *xw;
   {
   /* After each drawn image, */
   /* wait for command or exposure. */

   XSelectInput(xw->dpy, xw->w,
      KeyPressMask|ExposureMask
      |ButtonPressMask|KeyReleaseMask);

   while(1)
      {
      int symbol;
      XEvent e;
      XKeyEvent *k;
      XNextEvent(xw->dpy, &e);
      if (e.type == KeyPress)
         {
         k = (XKeyEvent *) &e;
         symbol = XLookupKeysym(k,0);
         if (symbol == XK_Escape || symbol == XK_q)
            {
            xw->runflg = 0;
            break;
            } /* if quit */
         else if (symbol == XK_Return)
            {
            xw->drawsw = 1;
            break;
            } /* if draw image */
         else if (symbol == XK_Insert)
            {
            xw->class = CLASS_I;
            break;
            } /* if class I */
         else if (symbol == XK_Delete)
            {
            xw->class = CLASS_II;
	    if (xw->bball)
	       {
	       if (xw->freq % 6)
	          xw->freq = 6 - (xw->freq % 6) + xw->freq;
	       if (xw->freq > 30) xw->freq = 30;
	       } /* if buckyball */
	    else if (xw->freq % 2)
	       {
	       xw->freq++;
	       if (xw->freq > 32) xw->freq = 32;
	       } /* if not buckyball and odd frequency */
            break;
            } /* if class II */
         else if (symbol == XK_Tab)
            {
	    if (xw->shift)
	       {
               xw->dometype--;
               if (xw->dometype < ICOSA)
                  xw->dometype = TETRA;
	       } /* if shift key */
	    else
	       {
               xw->dometype++;
               if (xw->dometype > TETRA)
                  xw->dometype = ICOSA;
	       } /* not shift key */
            break;
            } /* if polyhedron tab */
         else if (symbol == XK_BackSpace)
            {
            xw->dometype--;
            if (xw->dometype < ICOSA)
               xw->dometype = TETRA;
            break;
            } /* if polyhedron backspace */
         else if (symbol == XK_minus ||
	    symbol == XK_Down)
            {
	    if (xw->class == CLASS_II)
	       {
	       if (xw->bball)
		  {
                  xw->freq += 6;
	          if (xw->freq > 30)
		     xw->freq = 30;
		  } /* if buckyball */
               else xw->freq += 2;
	       } /* if class 2 */
	    else
	       {
	       if (xw->bball)
		  {
                  xw->freq += 3;
	          if (xw->freq > 30)
		     xw->freq = 30;
		  } /* if buckyball */
               else xw->freq++;
	       } /* if class 1 */
	    if (xw->freq > 32) xw->freq = 32;
            break;
            } /* if add 1 to frequency */
         else if (symbol == XK_plus ||
	    symbol == XK_Up)
            {
	    if (xw->class == CLASS_II)
	       {
	       if (xw->bball)
		  {
                  xw->freq -= 6;
	          if (xw->freq < 6)
		     xw->freq = 6;
		  } /* if buckyball */
               else
		  {
		  xw->freq -= 2;
	          if (xw->freq < 2) xw->freq = 2;
		  } /* if not buckyball */
	       } /* class II */
	    else
	       {
	       if (xw->bball)
		  {
                  xw->freq -= 3;
	          if (xw->freq < 3)
		     xw->freq = 3;
		  } /* if buckyball */
               else
		  {
                  xw->freq--;
	          if (xw->freq < 1) xw->freq = 1;
		  } /* if not buckyball */
	       } /* class I */
            break;
            } /* if subtract 1 from frequency */
         else if (symbol == XK_Page_Down)
            {
            if (xw->bball)
	       {
               xw->freq += 6;
               if (xw->freq > 30)
	          xw->freq = 30;
	       } /* if buckyball */
	    else
	       {
               xw->freq += 8;
	       if (xw->freq > 32) xw->freq = 32;
	       } /* if not buckyball */
            break;
            } /* if add 8 to frequency */
         else if (symbol == XK_Page_Up)
            {
            if (xw->bball)
	       {
               xw->freq -= 6;
	       if (xw->class == CLASS_I)
		  {
                  if (xw->freq < 3)
	             xw->freq = 3;
		  } /* if class I */
	       else
		  {
                  if (xw->freq < 6)
	             xw->freq = 6;
		  } /* if class II */
	       } /* if buckyball */
	    else
	       {
               xw->freq -= 8;
               if (xw->class == CLASS_II)
                  {
                  if (xw->freq < 2) xw->freq = 2;
                  } /* class II */
               else
                  {
                  if (xw->freq < 1) xw->freq = 1;
                  } /* class I */
	       } /* if not buckyball */
            break;
            } /* if subtract 8 from frequency */
         else if (symbol == XK_Home)
            {
	    if (xw->class == CLASS_II)
	       {
	       if (xw->bball)
                  xw->freq = 6;
               else xw->freq = 2;
	       } /* if class II */
	    else
	       {
	       if (xw->bball)
                  xw->freq = 3;
               else xw->freq = 1;
	       } /* if class I */
            break;
            } /* if set frequency to 1 */
         else if (symbol == XK_End)
            {
            if (xw->bball)
               xw->freq = 30;
            else xw->freq = 32;
            break;
            } /* if set frequency to 32 */
         else if (symbol == XK_Right)
            {
            xw->view++;
	    if (xw->view > TOP)
	       xw->view = FRONT;;
            break;
            } /* if next view */
         else if (symbol == XK_Left)
            {
            xw->view--;
	    if (xw->view < FRONT)
	       xw->view = TOP;
            break;
            } /* if prev view */
	 else if (symbol == XK_Shift_L
            || symbol == XK_Shift_R)
            {
            xw->shift = 1;
            /* don't break yet */
            /* wait for next key */
            } /* if shift key pressed */
         else if (symbol == XK_F1)
            {
	    if (xw->shift)
	       {
               xw->wtfact = 0;
	       break;
	       } /* if shift F1 */
	    else
	       {
               xw->wtfact <<= 1;
               if (!xw->wtfact)
                  xw->wtfact = 1;
               else if (xw->wtfact > 16)
                  xw->wtfact = 0;
               break;
	       } /* if simple F1 */
            } /* if fast/slow */
         else if (symbol == XK_F2)
            {
	    if (xw->shift)
	       {
               xw->ecc = 1.0;
	       break;
	       } /* if shift F2 */
	    else
	       {
               if (xw->ecc >1.0)
                  xw->ecc -= 0.04;
	       else
                  xw->ecc -= 0.02;
               if (xw->ecc < 0.5)
		  {
                  xw->ecc = 0.5;
		  XFlush(xw->dpy);
		  } /* if lower limit */
               else if (xw->ecc > 0.99999
		  && xw->ecc < 1.00001)
                  xw->ecc = 1.0;
               break;
	       } /* if simple F2 */
            } /* if horizontal elipse */
         else if (symbol == XK_F3)
            {
	    if (xw->shift)
	       {
               xw->ecc = 1.0;
	       break;
	       } /* if shift F3 */
	    else
	       {
               if (xw->ecc >= 1.0)
                  xw->ecc += 0.04;
	       else
                  xw->ecc += 0.02;
               if (xw->ecc > 2.0)
		  {
                  xw->ecc = 2.0;
		  XFlush(xw->dpy);
		  } /* if higher limit */
               else if (xw->ecc > 0.99999
		  && xw->ecc < 1.00001)
                  xw->ecc = 1.0;
               break;
	       } /* if simple F3 */
            } /* if vertical elipse */
         else if (symbol == XK_F4)
            {
	    if (xw->shift)
	       {
               xw->bball = 0;
	       break;
	       } /* if shift F4 */
	    else
	       {
               xw->bball ^= 1;
	       if (xw->bball)
		  {
	          if (xw->class == CLASS_II)
	             {
                     if (xw->freq % 6)
		        {
                        xw->freq = 6 - (xw->freq % 6) + xw->freq;
			if (xw->freq > 30)
			   xw->freq = 30;
		        } /* if freq not multiple of 6 */
	             } /* if CLASS_II */
	          else
	             {
                     if (xw->freq % 3)
		        {
                        xw->freq = 3 - (xw->freq % 3) + xw->freq;
			if (xw->freq > 30)
			   xw->freq = 30;
		        } /* if freq not multiple of 3 */
	             } /* if CLASS_I */
	          } /* if buckyball turned on */
	       break;
	       } /* if simple F4 */
            } /* if buckyball toggle F4 */
         } /* if keypress event */
      if (e.type == KeyRelease)
         {
         k = (XKeyEvent *) &e;
         symbol = XLookupKeysym(k,0);
	 if (symbol == XK_Shift_L
	    || symbol == XK_Shift_R)
	    xw->shift = 0;
         } /* if key release event */
      if (e.type == ButtonPress)
         {
	 xw->runflg = 0;
	 break;
         } /* if button press event */
      else if (e.type == Expose)
         {
         xw->drawsw = 1;
         break;
         } /* if expose event */
      } /* wait for window shutdown */
   } /* getkey */
