/* c2t_front_top.c Version 0.4.0. Class II Tetrahedron */
/* Front View, Top Triangle */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C2T_FRONT_TOP: class II tetrahedron, front view                 */
/*                     top triangle                                     */
/*									*/

#include "xdome.h"

void c2t_front_top(xwfmt *xw)
   {
   int x,y,z;
   int row;
   int trunc;
   int node,nodefrom,nodeto;
   int rowlmt;
   int xlmt;
   int halffreq;
   double x1,y1,z1;
   double root;
   double root2,root3;
   double phi,theta;
   double phi1,theta1,phi2,theta2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   int *topfromptr;
   int *topfromend;
   int *lefttoptr;
   int *rghttoptr;
   int *bbmidptr;
   int basefrom;
   int baseto;
   int topfromvtx;
   int lefttovtx;
   int rghttovtx;
   int bbmidvtx;
   int bbputsw;
   double leftmidphi;
   double rghttophi;
   double northmidphi;
   double *philstptr;
   double *thetalstptr;
   vtxfromptr  = (int *) xw->vtxfrom;
   vtxtoptr    = (int *) xw->vtxto;
   topfromptr  = (int *) xw->topfrom;
   lefttoptr   = (int *) xw->leftto;
   rghttoptr   = (int *) xw->rghtto;
   bbmidptr    = (int *) xw->bbmidpt;
   philstptr   = (double *) xw->philst;
   thetalstptr = (double *) xw->thetalst;
   if (xw->freq % 2) xw->freq++;
   halffreq = xw->freq >> 1;
   root2 = sqrt(2.0);
   root3 = sqrt(3.0);
   xw->tottri = node = xw->totvtx = 0;
   rowlmt = halffreq + 1;
   for (row=0;row<rowlmt;row++)
      {
      trunc = row % 3;
      xlmt = row + 1;
      for (x=0;x<xlmt;x++)
         {
         y = row - x;
         z = xw->freq - x - y;
         x1 = root3 * (double) x;
         y1 = (double) (y + y - x);
         z1 = (double) (z + z + z - x - y) / root2;
	 /* cotangent = x/y */
         if (y1 == 0.0)
            {
            if (x1 == 0.0) phi = 0.0;
            else
               {
	       phi = xw->rad90;
               } /* atan2 err */
            } /* if divide by zero */
         else phi = atan2(x1,y1);
         root  = sqrt((x1 * x1) + (y1 * y1));
         theta = atan2(root+root,z1);
         if (x < row)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
                  *vtxtoptr++   = node + 1;
                  xw->totvtx++;
                  *bbmidptr++   = node + row + 2;
	          } /* if trunc == 1 */
	       } /* if buckyball */
            } /* if x < row */
         if (row < halffreq)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 1;
                  xw->totvtx++;
		  /* buckyball mid point */
                  *bbmidptr++   = node - 1;
	          } /* if trunc == 1 */
	       else if (trunc == 2)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 2;
                  xw->totvtx++;
                  *bbmidptr++   = node + row + 1;
	          } /* if trunc == 2 */
	       } /* if buckyball */
	    else     /* not buckyball */
	       {
	       if (x < row)
		  {
	          /* upside down triangle */
                  *topfromptr++  = node + row + 2;
                  *lefttoptr++   = node;
                  *rghttoptr++   = node + 1;
                  xw->tottri++;
		  } /* if x < row */
	       /* right side up triangle */
               *topfromptr++  = node;
               *lefttoptr++   = node + row + 1;
               *rghttoptr++   = node + row + 2;
               xw->tottri++;
	       } /* not buckyball */
            } /* if row < halffreq */
         *philstptr++   = phi;
         *thetalstptr++ = theta;
	 trunc++;
	 trunc %= 3;
         node++;
         } /* for each x */
      } /* for each row */
   xw->totnode = node;
   vtxfromptr  = (int *) xw->vtxfrom;
   vtxtoptr    = (int *) xw->vtxto;
   vtxendptr   = (int *) xw->vtxfrom      + xw->totvtx;
   topfromptr  = (int *) xw->topfrom;
   topfromend  = (int *) xw->topfrom      + xw->tottri;
   lefttoptr   = (int *) xw->leftto;
   rghttoptr   = (int *) xw->rghtto;
   bbmidptr    = (int *) xw->bbmidpt;
   /* for each triangle */
   while (!xw->bball && topfromptr < topfromend)
      {
      topfromvtx  = *topfromptr++;
      lefttovtx   = *lefttoptr++;
      rghttovtx   = *rghttoptr++;
      basefrom    = lefttovtx;
      baseto      = rghttovtx;

      phi1        = *(xw->philst+topfromvtx);
      phi2        = *(xw->philst+lefttovtx);
      leftmidphi  = (phi1 + phi2) * 0.5;
      rghttophi   = *(xw->philst+rghttovtx);
      northmidphi = (leftmidphi + rghttophi) * 0.5;

      /* base strut */
      phi1     = *(xw->philst  +basefrom);
      theta1   = *(xw->thetalst+basefrom);
      phi2     = *(xw->philst  +baseto);
      theta2   = *(xw->thetalst+baseto);
      /* northern hemisphere */
      if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,-phi1,theta1,
            -phi2,theta2);
	 } /* else foreground */
      /* left strut */
      phi1     = *(xw->philst  +topfromvtx);
      theta1   = *(xw->thetalst+topfromvtx);
      phi2     = *(xw->philst  +lefttovtx);
      theta2   = *(xw->thetalst+lefttovtx);
      /* northern hemisphere */
      if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,-phi1,theta1,
            -phi2,theta2);
	 } /* else foreground */
      /* right strut */
      phi1     = *(xw->philst  +topfromvtx);
      theta1   = *(xw->thetalst+topfromvtx);
      phi2     = *(xw->philst  +rghttovtx);
      theta2   = *(xw->thetalst+rghttovtx);
      /* northern hemisphere */
      if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,-phi1,theta1,
            -phi2,theta2);
	 } /* else foreground */
      } /* for each triangle */
   /* for each buckyball strut */
   while (xw->bball && vtxfromptr < vtxendptr)
      {
      nodefrom    = *vtxfromptr++;
      nodeto      = *vtxtoptr++;
      bbmidvtx    = *bbmidptr++;
      northmidphi = *(xw->philst+bbmidvtx);

      phi1     = *(xw->philst  +nodefrom);
      theta1   = *(xw->thetalst+nodefrom);
      phi2     = *(xw->philst  +nodeto);
      theta2   = *(xw->thetalst+nodeto);
      /* northern hemisphere */
      bbputsw = 0;
      if (xw->freq == 6
	 && phi1 < xw->rad90 + 1.0
	 && phi2 < xw->rad90 + 1.0)
	 bbputsw = 1;
      else if (xw->freq == 12
	 && phi1 < xw->rad90 + 0.1
	 && phi2 < xw->rad90 + 0.1)
	 bbputsw = 1;
      else if (xw->freq == 18
	 && phi1 < xw->rad90 + 0.2
	 && phi2 < xw->rad90 + 0.2)
	 bbputsw = 1;
      else if (xw->freq == 24
	 && phi1 < xw->rad90 + 0.2
	 && phi2 < xw->rad90 + 0.2)
	 bbputsw = 1;
      else if (xw->freq == 30
	 && phi1 < xw->rad90 + 0.1
	 && phi2 < xw->rad90 + 0.1)
	 bbputsw = 1;
      if (bbputsw)
	 {
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,-phi1,theta1,
            -phi2,theta2);
	 } /* else foreground */
      if (northmidphi > xw->rad90)
	 {
	 /* bypass */
	 } /* if background */
      else
	 {
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,-phi1,theta1,
            -phi2,theta2);
	 } /* else foreground */
      } /* for each buckyball strut */
   } /* c2t_front_top */
