/* c2i_top_top.c Version 0.4.0. Class II Icosahedron */
/* Top View, Top Triangle */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C2I_TOP_TOP: class II icosahedron, top view                     */
/*                     top triangle                                     */
/*									*/

#include "xdome.h"

void c2i_top_top(xwfmt *xw)
   {
   int x,y,z;
   int semifreq;
   int row;
   int trunc;
   int node,nodefrom,nodeto;
   int rowlmt;
   int xlmt;
   double dblx,dbly,dblz;
   double x1,y1,z1;
   double halffreq;
   double root;
   double phi,theta;
   double phi1,theta1,phi2,theta2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   int *topfromptr;
   int *topfromend;
   int *lefttoptr;
   int *rghttoptr;
   int *bbmidptr;
   int basefrom;
   int baseto;
   int topfromvtx;
   int lefttovtx;
   int rghttovtx;
   int bbmidvtx;
   double leftmidtheta;
   double rghttotheta;
   double midtheta;
   double *philstptr;
   double *thetalstptr;
   vtxfromptr  = (int *) xw->vtxfrom;
   vtxtoptr    = (int *) xw->vtxto;
   topfromptr  = (int *) xw->topfrom;
   lefttoptr   = (int *) xw->leftto;
   rghttoptr   = (int *) xw->rghtto;
   bbmidptr    = (int *) xw->bbmidpt;
   philstptr   = (double *) xw->philst;
   thetalstptr = (double *) xw->thetalst;
   if (xw->freq % 2 != 0) xw->freq++;
   semifreq = xw->freq >> 1;
   halffreq = (double) xw->freq * 0.5;
   xw->tottri = node = xw->totvtx = 0;
   rowlmt = semifreq + 1;
   for (row=0;row<rowlmt;row++)
      {
      trunc = row % 3;
      xlmt = row + 1;
      for (x=0;x<xlmt;x++)
         {
         y = row - x;
         z = xw->freq - x - y;
         dblx = (double) x;
         dbly = (double) y;
         dblz = (double) z;
         x1 = dblx * xw->sin72;
         y1 = dbly + (dblx * xw->cos72);
         z1 = halffreq + (dblz * xw->oneovertau);
	 /* cotangent = x/y */
         if (y1 == 0.0)
            {
            if (x1 == 0.0) phi = 0.0;
            else
               {
	       phi = xw->rad90;
               } /* atan2 err */
            } /* if divide by zero */
         else phi = atan2(x1,y1);
         root  = sqrt((x1 * x1) + (y1 * y1));
         theta = atan2(root,(xw->cos36 * z1));
         if (x < row)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
                  *vtxtoptr++   = node + 1;
                  xw->totvtx++;
                  *bbmidptr++   = node + row + 2;
	          } /* if trunc == 1 */
	       } /* if buckyball */
            } /* if x < row */
         if (row < semifreq)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 1;
                  xw->totvtx++;
		  /* buckyball mid point */
                  *bbmidptr++   = node - 1;
	          } /* if trunc == 1 */
	       else if (trunc == 2)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 2;
                  xw->totvtx++;
                  *bbmidptr++   = node + row + 1;
	          } /* if trunc == 2 */
	       } /* if buckyball */
	    else     /* not buckyball */
	       {
	       if (x < row)
		  {
	          /* upside down triangle */
                  *topfromptr++  = node + row + 2;
                  *lefttoptr++   = node;
                  *rghttoptr++   = node + 1;
                  xw->tottri++;
		  } /* if x < row */
	       /* right side up triangle */
               *topfromptr++  = node;
               *lefttoptr++   = node + row + 1;
               *rghttoptr++   = node + row + 2;
               xw->tottri++;
	       } /* not buckyball */
            } /* if row < semifreq */
         *philstptr++   = phi;
         *thetalstptr++ = theta;
	 trunc++;
	 trunc %= 3;
         node++;
         } /* for each x in row */
      } /* for each row */
   xw->totnode = node;
   vtxfromptr  = (int *) xw->vtxfrom;
   vtxtoptr    = (int *) xw->vtxto;
   vtxendptr   = (int *) xw->vtxfrom      + xw->totvtx;
   topfromptr  = (int *) xw->topfrom;
   topfromend  = (int *) xw->topfrom      + xw->tottri;
   lefttoptr   = (int *) xw->leftto;
   rghttoptr   = (int *) xw->rghtto;
   bbmidptr    = (int *) xw->bbmidpt;
   /* for each triangle */
   while (!xw->bball && topfromptr < topfromend)
      {
      topfromvtx  = *topfromptr++;
      lefttovtx   = *lefttoptr++;
      rghttovtx   = *rghttoptr++;
      basefrom    = lefttovtx;
      baseto      = rghttovtx;

      theta1        = *(xw->thetalst+topfromvtx);
      theta2        = *(xw->thetalst+lefttovtx);
      leftmidtheta  = (theta1 + theta2) * 0.5;
      rghttotheta   = *(xw->thetalst+rghttovtx);
      midtheta      = (leftmidtheta + rghttotheta) * 0.5;

      /* base strut */
      phi1     = *(xw->philst  +basefrom);
      theta1   = *(xw->thetalst+basefrom);
      phi2     = *(xw->philst  +baseto);
      theta2   = *(xw->thetalst+baseto);
      /* northern hemisphere, polar view */
      if (midtheta < xw->rad90)
	 {
         drawchord(xw,phi1,theta1,phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);
	 } /* if northern hemisphere, polar view */

      /* left strut */
      phi1     = *(xw->philst  +topfromvtx);
      theta1   = *(xw->thetalst+topfromvtx);
      phi2     = *(xw->philst  +lefttovtx);
      theta2   = *(xw->thetalst+lefttovtx);
      /* northern hemisphere, polar view */
      if (midtheta < xw->rad90)
	 {
         drawchord(xw,phi1,theta1,phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);
	 } /* if northern hemisphere, polar view */

      /* right strut */
      phi1     = *(xw->philst  +topfromvtx);
      theta1   = *(xw->thetalst+topfromvtx);
      phi2     = *(xw->philst  +rghttovtx);
      theta2   = *(xw->thetalst+rghttovtx);
      /* northern hemisphere, polar view */
      if (midtheta < xw->rad90)
	 {
         drawchord(xw,phi1,theta1,phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);
	 } /* if northern hemisphere, polar view */
      } /* for each triangle */
   /* for each buckyball strut */
   while (xw->bball && vtxfromptr < vtxendptr)
      {
      nodefrom    = *vtxfromptr++;
      nodeto      = *vtxtoptr++;
      bbmidvtx    = *bbmidptr++;
      midtheta    = *(xw->thetalst+bbmidvtx);

      /* northern hemisphere, polar view */
      phi1     = *(xw->philst  +nodefrom);
      theta1   = *(xw->thetalst+nodefrom);
      phi2     = *(xw->philst  +nodeto);
      theta2   = *(xw->thetalst+nodeto);
      if (midtheta < xw->rad90)
	 {
         drawchord(xw,phi1,theta1,phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);
	 } /* if northern hemisphere, polar view */
      } /* for each buckyball strut */
   } /* c2i_top_top */
