/* c2i_top_fg.c Version 0.4.0. Class II Icosahedron */
/* Top View, Side Triangle, Foreground */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C2I_TOP_FG: class II icosahedron, top view                      */
/*                      side triangle, foreground                       */
/*									*/

#include "xdome.h"

void c2i_top_fg(xwfmt *xw)
   {
   int nodefrom,nodeto;
   double phi1,theta1,phi2,theta2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   int *topfromptr;
   int *topfromend;
   int *lefttoptr;
   int *rghttoptr;
   int *bbmidptr;
   int basefrom;
   int baseto;
   int topfromvtx;
   int lefttovtx;
   int rghttovtx;
   int bbmidvtx;
   double leftmidtheta;
   double rghttotheta;
   double northmidtheta;
   double southmidtheta;
   vtxfromptr  = (int *) xw->vtxfrom;
   vtxtoptr    = (int *) xw->vtxto;
   vtxendptr   = (int *) xw->vtxfrom      + xw->totvtx;
   topfromptr  = (int *) xw->topfrom;
   topfromend  = (int *) xw->topfrom      + xw->tottri;
   lefttoptr   = (int *) xw->leftto;
   rghttoptr   = (int *) xw->rghtto;
   bbmidptr    = (int *) xw->bbmidpt;
   /* for each triangle */
   while (!xw->bball && topfromptr < topfromend)
      {
      topfromvtx  = *topfromptr++;
      lefttovtx   = *lefttoptr++;
      rghttovtx   = *rghttoptr++;
      basefrom    = lefttovtx;
      baseto      = rghttovtx;

      theta1        = *(xw->thetalow+topfromvtx);
      theta2        = *(xw->thetalow+lefttovtx);
      leftmidtheta  = (theta1 + theta2) * 0.5;
      rghttotheta   = *(xw->thetalow+rghttovtx);
      northmidtheta = (leftmidtheta + rghttotheta) * 0.5;
      theta1        = xw->rad180 - *(xw->thetalow+topfromvtx);
      theta2        = xw->rad180 - *(xw->thetalow+lefttovtx);
      leftmidtheta  = (theta1 + theta2) * 0.5;
      rghttotheta   = xw->rad180 - *(xw->thetalow+rghttovtx);
      southmidtheta = (leftmidtheta + rghttotheta) * 0.5;

      /* northern hemisphere, polar view */
      if (northmidtheta <= xw->rad90)
	 {
         /* base strut */
         phi1     = *(xw->philow  +basefrom);
         theta1   = *(xw->thetalow+basefrom);
         phi2     = *(xw->philow  +baseto);
         theta2   = *(xw->thetalow+baseto);
         /* northern hemisphere side triangles */
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);

         /* left strut */
         phi1     = *(xw->philow  +topfromvtx);
         theta1   = *(xw->thetalow+topfromvtx);
         phi2     = *(xw->philow  +lefttovtx);
         theta2   = *(xw->thetalow+lefttovtx);
         /* northern hemisphere side triangles */
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);

         /* right strut */
         phi1     = *(xw->philow  +topfromvtx);
         theta1   = *(xw->thetalow+topfromvtx);
         phi2     = *(xw->philow  +rghttovtx);
         theta2   = *(xw->thetalow+rghttovtx);
         /* northern hemisphere side triangles */
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);
	 } /* if northern hemisphere, polar view */

      /* northern hemisphere, polar view */
      theta1   = *(xw->thetalow+basefrom);
      theta2   = *(xw->thetalow+baseto);
      if (theta1 < xw->rad90 + 0.01
         && theta2 < xw->rad90 + 0.01)
	 {
         /* base strut */
         phi1     = *(xw->philow  +basefrom);
         phi2     = *(xw->philow  +baseto);
         /* northern hemisphere side triangles */
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);
	 } /* if northern hemisphere, polar view */

      /* southern hemisphere, polar view */
      if (southmidtheta <= xw->rad90)
	 {
         /* base strut */
         phi1     = *(xw->philow  +basefrom) + xw->rad36;
         theta1   = xw->rad180 - *(xw->thetalow+basefrom);
         phi2     = *(xw->philow  +baseto)   + xw->rad36;
         theta2   = xw->rad180 - *(xw->thetalow+baseto);
         /* southern hemisphere side triangles */
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);

         /* left strut */
         phi1     = *(xw->philow  +topfromvtx) + xw->rad36;
         theta1   = xw->rad180 - *(xw->thetalow+topfromvtx);
         phi2     = *(xw->philow  +lefttovtx) + xw->rad36;
         theta2   = xw->rad180 - *(xw->thetalow+lefttovtx);
         /* southern hemisphere side triangles */
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);

         /* right strut */
         phi1     = *(xw->philow  +topfromvtx) + xw->rad36;
         theta1   = xw->rad180 - *(xw->thetalow+topfromvtx);
         phi2     = *(xw->philow  +rghttovtx) + xw->rad36;
         theta2   = xw->rad180 - *(xw->thetalow+rghttovtx);
         /* southern hemisphere side triangles */
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         drawchord(xw,phi1+xw->rad72,theta1,
            phi2+xw->rad72,theta2);
         drawchord(xw,phi1-xw->rad72,theta1,
            phi2-xw->rad72,theta2);
         drawchord(xw,phi1+xw->rad144,theta1,
            phi2+xw->rad144,theta2);
         drawchord(xw,phi1-xw->rad144,theta1,
            phi2-xw->rad144,theta2);
	 } /* if southern hemisphere, polar view */
      } /* for each triangle */

   /* for each buckyball strut */
   while (xw->bball && vtxfromptr < vtxendptr)
      {
      nodefrom    = *vtxfromptr++;
      nodeto      = *vtxtoptr++;
      bbmidvtx    = *bbmidptr++;
      northmidtheta = *(xw->thetalow+bbmidvtx);
      southmidtheta = xw->rad180 - *(xw->thetalow+bbmidvtx);

      /* northern hemisphere, polar view */
      theta1   = *(xw->thetalow + nodefrom);
      theta2   = *(xw->thetalow + nodeto);
      if (theta1 < xw->rad90 + 0.1
         && theta2 < xw->rad90 + 0.1)
	 {
         phi1     = *(xw->philow   + nodefrom);
         theta1   = *(xw->thetalow + nodefrom);
         phi2     = *(xw->philow   + nodeto);
         theta2   = *(xw->thetalow + nodeto);
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
         phi1     = xw->rad72 - *(xw->philow   + nodefrom);
         phi2     = xw->rad72 - *(xw->philow   + nodeto);
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 } /* northern hemisphere, polar view */

      /* southern hemisphere, polar view */
      theta1   = xw->rad180 - *(xw->thetalow + nodefrom);
      theta2   = xw->rad180 - *(xw->thetalow + nodeto);
      if (theta1 < xw->rad90 + 0.1
         && theta2 < xw->rad90 + 0.1)
	 {
         phi1     = xw->rad36 - *(xw->philow    + nodefrom);
         phi2     = xw->rad36 - *(xw->philow    + nodeto);
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 phi1 += xw->rad72;
	 phi2 += xw->rad72;
         drawchord(xw,phi1,theta1,
            phi2,theta2);
	 } /* southern hemisphere, polar view */
      } /* for each buckyball strut */
   } /* c2i_top_fg */
