/* c2i_back_se.c Version 0.4.0. Class II Icosahedron */
/* Back View, South East Side Triangle */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C2I_BACK_SE: class II icosahedron, back view                    */
/*                      south east side triangle                        */
/*									*/

#include "xdome.h"

void c2i_back_se(xwfmt *xw)
   {
   double phi,theta;
   double newphi,newtheta;
   double heighttheta,sidetheta;
   double phimed,thetamed;
   double diff;
   double prod1,prod2,prod3; 
   double dvsr,quotient;
   double *philstptr;
   double *thetalstptr;
   double *philowptr;
   double *thetalowptr;
   double *phiendptr;
   philstptr   = xw->philst;
   phiendptr   = xw->philst + xw->totnode;
   thetalstptr = xw->thetalst;
   philowptr   = xw->philow;
   thetalowptr = xw->thetalow;
   phimed   = xw->rad36;
   heighttheta = atan(xw->tau);
   sidetheta   = M_PI - heighttheta - heighttheta;
   thetamed    = sidetheta * 0.5;
   while (philstptr < phiendptr)
      {
      phi   = (*philstptr++) - xw->rad144;
      theta = *thetalstptr++;
      diff = phimed - phi;
      prod1 = cos(thetamed + thetamed) * cos(theta);
      prod2 = sin(thetamed + thetamed)
         * sin(theta) * cos(diff);
      newtheta = acos(prod1 + prod2);
      prod3 = sin(theta) * sin(diff);
      dvsr = sin(newtheta);
      if (dvsr == 0.0)
         {
         fprintf(stderr,"Divide by zero\n");
         exit(1);
         } /* divide by zero */
      quotient = prod3 / dvsr;
      newphi = asin(quotient) + xw->rad36;
      *philowptr++   = newphi;
      *thetalowptr++ = newtheta;
      } /* for each vertex */
   c2i_back_fg(xw);
   } /* c2i_back_se */
