/* c1t_front_side.c Version 0.4.0. Class I Tetrahedron */
/* Front View, Side Triangle */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor    */
/*       Boston, MA  02110-1301, USA   */

/*									*/
/*      C1T_FRONT_SIDE: class I tetrahedron, front view                 */
/*                      side triangle                                   */
/*									*/

#include "xdome.h"

void c1t_front_side(xwfmt *xw)
   {
   int node,nodefrom,nodeto;
   double x1,y1,z1;
   double phi,theta;
   double newphi,newtheta;
   double phi1,theta1,phi2,theta2;
   double root;
   double phimed,thetamed;
   double diff;
   double prod1,prod2,prod3; 
   double dvsr,quotient;
   double thetaleft;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   int *topfromptr;
   int *topfromend;
   int *lefttoptr;
   int *rghttoptr;
   int *bbmidptr;
   int basefrom;
   int baseto;
   int topfromvtx;
   int lefttovtx;
   int rghttovtx;
   double leftmidphi;
   double rghttophi;
   double northmidphi;
   double *philstptr;
   double *thetalstptr;
   double *philowptr;
   double *thetalowptr;
   double *phiendptr;
   unsigned char *byplstptr;
   unsigned char *bypendptr;
   vtxfromptr  = (int *) xw->vtxfrom;
   vtxtoptr    = (int *) xw->vtxto;
   philstptr   = (double *) xw->philst;
   phiendptr   = (double *) xw->philst + xw->totnode;
   thetalstptr = (double *) xw->thetalst;
   philowptr   = (double *) xw->philow;
   thetalowptr = (double *) xw->thetalow;
   byplstptr   = (unsigned char *) xw->byplst;
   bypendptr   = (unsigned char *) xw->byplst + TOTNODES;
   while (byplstptr < bypendptr)
      *byplstptr++ = '\0';
   /* x=3 y=3 z=0 */
   x1 = sqrt(3.0) * 3.0;
   y1 = 3.0;                  /* y + y - x          */
   z1 = -6.0 / sqrt(2.0);     /* z + z + z - x - y  */
   phimed   = xw->rad60;
   root = sqrt((x1 * x1) + (y1 * y1));
   thetamed = atan2(root,z1);
   thetaleft = thetamed + thetamed - xw->rad180;
   node = 0;
   while (philstptr < phiendptr)
      {
      phi   = *philstptr++;
      theta = *thetalstptr++;
      if (theta < thetaleft)
         {
         *(xw->byplst+node) = 'x';
         } /* bypass tip of bottom triangle */
      diff = phimed - phi;
      prod1 = cos(thetamed + thetamed) * cos(theta);     
      prod2 = sin(thetamed + thetamed)                   
         * sin(theta) * cos(diff);                      
      newtheta = acos(prod1 + prod2);
      prod3 = sin(theta) * sin(diff);
      dvsr = sin(newtheta);
      if (dvsr == 0.0)
         {
         quotient = 1.0;
         } /* divide by zero */
      else quotient = prod3 / dvsr;
      if (quotient > 1.0) quotient = 1.0;
      else if (quotient < -1.0) quotient = -1.0;
      newphi = asin(quotient);
      *philowptr++   = newphi;
      *thetalowptr++ = newtheta;
      node++;
      } /* for each vertex */
   vtxfromptr   = (int *) xw->vtxfrom;
   vtxtoptr     = (int *) xw->vtxto;
   vtxendptr    = (int *) vtxfromptr    + xw->totvtx;
   topfromptr   = (int *) xw->topfrom;
   topfromend   = (int *) xw->topfrom   + xw->tottri;
   lefttoptr    = (int *) xw->leftto;
   rghttoptr    = (int *) xw->rghtto;
   bbmidptr     = (int *) xw->bbmidpt;
   /* for each triangle */
   while (!xw->bball && topfromptr < topfromend)
      {
      topfromvtx  = *topfromptr++;
      lefttovtx   = *lefttoptr++;
      rghttovtx   = *rghttoptr++;
      basefrom    = lefttovtx;
      baseto      = rghttovtx;
      if (*(xw->byplst+topfromvtx)
	 || *(xw->byplst+lefttovtx)
	 || *(xw->byplst+rghttovtx))
	 continue;

      phi1        = *(xw->philow+topfromvtx);
      phi2        = *(xw->philow+lefttovtx);
      leftmidphi  = (phi1 + phi2) * 0.5;
      rghttophi   = *(xw->philow+rghttovtx);
      northmidphi = (leftmidphi + rghttophi) * 0.5;

      /* base strut */
      phi1     = *(xw->philow  +basefrom);
      theta1   = *(xw->thetalow+basefrom);
      phi2     = *(xw->philow  +baseto);
      theta2   = *(xw->thetalow+baseto);
      drawchord(xw,phi1,theta1,phi2,theta2);
      /* left strut */
      phi1     = *(xw->philow+topfromvtx);
      theta1   = *(xw->thetalow+topfromvtx);
      phi2     = *(xw->philow+lefttovtx);
      theta2   = *(xw->thetalow+lefttovtx);
      drawchord(xw,phi1,theta1,phi2,theta2);
      /* right strut */
      phi1     = *(xw->philow  +topfromvtx);
      theta1   = *(xw->thetalow+topfromvtx);
      phi2     = *(xw->philow  +rghttovtx);
      theta2   = *(xw->thetalow+rghttovtx);
      drawchord(xw,phi1,theta1,phi2,theta2);
      } /* for each triangle */

   /* for each buckyball */
   while (xw->bball && vtxfromptr < vtxendptr)
      {
      nodefrom = *vtxfromptr++;
      nodeto   = *vtxtoptr++;
      if (*(xw->byplst+nodefrom)
	 || *(xw->byplst+nodeto))
	 continue;
      phi1   = *(xw->philow+nodefrom);
      theta1 = *(xw->thetalow+nodefrom);
      phi2   = *(xw->philow+nodeto);
      theta2 = *(xw->thetalow+nodeto);
      drawchord(xw,phi1,theta1,phi2,theta2);
      } /* for each buckyball node */
   } /* c1t_front_side */
