/* c1o_back_top.c Version 0.4.0. Class I Octahedron */
/* Back View, Top Triangle */
/* Copyright (C) 2004-2010  dondalah721@yahoo.com (Dondalah) */

/* Xdome is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* Xdome is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       51 Franklin St, Fifth Floor */
/*       Boston, MA  02110-1301, USA */

/*									*/
/*      C1O_BACK_TOP: class I octahedron, back view                     */
/*                     top triangle                                     */
/*									*/

#include "xdome.h"

void c1o_back_top(xwfmt *xw)
   {
   int x,y,z;
   int row;
   int trunc;
   int node,nodefrom,nodeto;
   int rowlmt;
   int xlmt;
   double dblx,dbly,dblz;
   double root;
   double phi,theta;
   double phi1,theta1,phi2,theta2;
   int *vtxfromptr;
   int *vtxtoptr;
   int *vtxendptr;
   double *philstptr;
   double *thetalstptr;
   rowlmt = xw->freq + 1;
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   philstptr   = xw->philst;
   thetalstptr = xw->thetalst;
   node = xw->totvtx = 0;
   for (row=0;row<rowlmt;row++)
      {
      trunc = row % 3;
      xlmt = row + 1;
      for (x=0;x<xlmt;x++)
         {
         y = row - x;
         z = xw->freq - x - y;
         dblx = (double) x;
         dbly = (double) y;
         dblz = (double) z;
	 /* cotangent = x/y */
         if (dbly == 0.0)
            {
            if (dblx == 0.0) phi = 0.0;
            else
               {
	       phi = xw->rad90;
               } /* atan2 err */
            } /* if divide by zero */
         else phi = atan2(dblx,dbly);
         root  = sqrt((dblx * dblx) + (dbly * dbly));
         theta = atan2(root,dblz);
         if (x < row)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
                  *vtxtoptr++   = node + 1;
                  xw->totvtx++;
	          } /* if trunc == 1 */
	       } /* if buckyball */
	    else
	       {
               *vtxfromptr++ = node;
               *vtxtoptr++   = node + 1;
               xw->totvtx++;
	       } /* else not buckyball */
            } /* if x < row */
         if (row < xw->freq)
            {
	    if (xw->bball)
	       {
	       if (trunc == 1)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 1;
                  xw->totvtx++;
	          } /* if trunc == 1 */
	       else if (trunc == 2)
	          {
                  *vtxfromptr++ = node;
	          *vtxtoptr++   = node + row + 2;
                  xw->totvtx++;
	          } /* if trunc == 2 */
	       } /* if buckyball */
	    else
	       {
	       *vtxfromptr++ = node;
	       *vtxfromptr++ = node;
	       *vtxtoptr++   = node + row + 1;
	       *vtxtoptr++   = node + row + 2;
	       xw->totvtx   += 2;
	       } /* else not buckyball */
            } /* if x < row */
         *philstptr++   = phi;
         *thetalstptr++ = theta;
	 trunc++;
	 trunc %= 3;
         node++;
         } /* for each x */
      } /* for each row */
   xw->totnode = node;
   vtxfromptr  = xw->vtxfrom;
   vtxtoptr    = xw->vtxto;
   vtxendptr   = xw->vtxfrom + xw->totvtx;
   while (vtxfromptr < vtxendptr)
      {
      nodefrom = *vtxfromptr++;
      nodeto   = *vtxtoptr++;
      phi1   = *(xw->philst+nodefrom);
      theta1 = *(xw->thetalst+nodefrom);
      phi2   = *(xw->philst+nodeto);
      theta2 = *(xw->thetalst+nodeto);
      drawchord(xw,phi1,theta1,phi2,theta2);
      drawchord(xw,-phi1,theta1,-phi2,theta2);
      /* southern hemisphere */
      drawchord(xw,phi1,xw->rad180-theta1,
         phi2,xw->rad180-theta2);
      drawchord(xw,-phi1,xw->rad180-theta1,
         -phi2,xw->rad180-theta2);
      } /* for each node */
   } /* c1o_back_top */
