#!/usr/bin/make

# spinecc.mak Version 0.4.0. Compile spinecc.c.
# Copyright (C) 2004-2010 dondalah721@yahoo.com (Dondalah)

# Xdome is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# Xdome is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	51 Franklin St, Fifth Floor
# 	Boston, MA  02110-1301, USA

# Make sure that the Debian font package xfonts-base
# is installed on your system.  Or have the equivalent
# of xfonts-base installed.

# Debian font
################################ for VGA 640x480
################################ XFONT=\"7x13\"
################################ for XGA 1024x768
################################ XFONT=\"10x20\"
XFONT=\"10x20\"

# uncomment if you want the dome window in
# the upper left of your virtual desktop
# UPPERLEFT=-D UPPERLEFT

OBJ=spinecc.o \
	eccinit.o \
	eccfree.o \
	initx.o \
	spinmenu.o \
	parsecc.o \
	getspec.o \
	getpolar.o \
	getecc.o \
	bldecc.o \
	rotate.o \
	drawspin.o \
	getkey.o \
	getln.o \
	getbyte.o

CC=gcc

CFLAGS=-c -Wall -O6 -I. \
	-I/usr/X11R6/include/X11 \
        -DFONT=$(XFONT) \
	$(UPPERLEFT)

LDFLAGS=-L/usr/X11R6/lib -lX11 -lm

XXXCFLAGS=-c -Wall -O6 -I. \
	-I../xdome \
        -DFONT=$(XFONT) \
	$(UPPERLEFT)

XXXLDFLAGS=-L/usr/X11R6/lib -lX11 \
	-L../xdome -lxdome -lm

all:		$(OBJ) spinecc

spinecc:			$(OBJ)
	$(CC) -Wall -O6 $(OBJ) -o spinecc $(LDFLAGS)

spinecc.o:			spinecc.c
	$(CC) $(CFLAGS) spinecc.c

eccinit.o:		eccinit.c
	$(CC) $(CFLAGS) eccinit.c

eccfree.o:		eccfree.c
	$(CC) $(CFLAGS) eccfree.c

initx.o:		initx.c
	$(CC) $(CFLAGS) initx.c

spinmenu.o:		spinmenu.c
	$(CC) $(CFLAGS) spinmenu.c

parsecc.o:		parsecc.c
	$(CC) $(CFLAGS) parsecc.c

getspec.o:		getspec.c
	$(CC) $(CFLAGS) getspec.c

getpolar.o:		getpolar.c
	$(CC) $(CFLAGS) getpolar.c

getecc.o:		getecc.c
	$(CC) $(CFLAGS) getecc.c

bldecc.o:		bldecc.c
	$(CC) $(CFLAGS) bldecc.c

rotate.o:		rotate.c
	$(CC) $(CFLAGS) rotate.c

drawspin.o:		drawspin.c
	$(CC) $(CFLAGS) drawspin.c

getkey.o:		getkey.c
	$(CC) $(CFLAGS) getkey.c

getln.o:		getln.c
	$(CC) $(CFLAGS) getln.c

getbyte.o:		getbyte.c
	$(CC) $(CFLAGS) getbyte.c

clean:
	rm -f spinecc $(OBJ)
